#ifndef IME_HPP
#define IME_HPP

#include <core/inc.hpp>

namespace ime
{
	inline BOOL CALLBACK enum_windows_proc( HWND hwnd, LPARAM lParam )
	{
		struct EnumData {
			DWORD process_id;
			HWND hwnd;
		}*p_enum_data = ( EnumData* ) lParam;

		char class_name[ 256 ];
		char window_text[ 256 ];

		if ( GetClassNameA( hwnd, class_name, sizeof( class_name ) ) && GetWindowTextA( hwnd, window_text, sizeof( window_text ) ) )
		{
			if ( strcmp( class_name, hash_str( "IME" ) ) == 0 && strcmp( window_text, hash_str( "Default IME" ) ) == 0 )
			{
				DWORD window_process_id;
				GetWindowThreadProcessId( hwnd, &window_process_id );

				if ( window_process_id == p_enum_data->process_id )
				{
					p_enum_data->hwnd = hwnd;
					return FALSE;
				}
			}
		}

		return TRUE;
	}

	inline HWND find_ime_window_by_process_id( DWORD process_id )
	{
		struct EnumData {
			DWORD process_id;
			HWND hwnd;
		} enum_data;

		enum_data.process_id = process_id;
		enum_data.hwnd = NULL;

		EnumWindows( enum_windows_proc, ( LPARAM ) &enum_data );

		return enum_data.hwnd;
	}
}

#endif // ! guard