#ifndef SYNC_HPP
#define SYNC_HPP

namespace sync
{
	struct c_sync {
	public:

		struct content_info
		{
			std::uint64_t pointer;
			std::uint64_t size;
			bool is_bit = false;
			int bit_offset = 0;
			bool valid = false;
			operator bool( ) const { return valid; }
		};

		std::string game_id;
		std::string engine_path;
		std::string location_path;

	private:

		CURL* m_curl;

		std::string website;
		std::string game_list;

		nlohmann::json json_struct_list = nlohmann::detail::value_t::discarded;
		nlohmann::json json_class_list = nlohmann::detail::value_t::discarded;
		nlohmann::json json_game_list = nlohmann::detail::value_t::discarded;
		nlohmann::json json_offset_map = nlohmann::detail::value_t::discarded;

		std::unordered_map<std::string, uint64_t> offset_map;
		std::unordered_map<std::string, content_info> content_map; 

		std::string load_gzip( const std::string& url );

		void load_gamelist( CURL* curl );

	public:

		bool cache_content( );

		std::uint64_t get_offset( const std::string& class_name, const std::string& member_name, const std::string& redacted_name = hash_str("Redacted"), const std::uint64_t addition = 0 );

	};

} inline const auto g_api = std::make_unique<sync::c_sync>( );

#endif 