#pragma once
#include <core/inc.hpp>

auto console_interface::c_console::set_title( const char* title ) -> void {

    auto console_handle = GetConsoleWindow( );

    RECT r;
    GetWindowRect( console_handle, &r ); 
    MoveWindow( console_handle, r.left, r.top, 740, 650, TRUE );

    CONSOLE_FONT_INFOEX cfi;
    cfi.cbSize = sizeof( cfi );
    cfi.nFont = 0;
    cfi.dwFontSize.X = 0;                   
    cfi.dwFontSize.Y = 16;                
    cfi.FontFamily = FF_DONTCARE;
    cfi.FontWeight = FW_NORMAL;
    std::wcscpy( cfi.FaceName, hash_str( L"Cascadia Code" ) ); 
    SetCurrentConsoleFontEx( GetStdHandle( STD_OUTPUT_HANDLE ), FALSE, &cfi );
    ::SetWindowPos( console_handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_DRAWFRAME | SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW );
	SetConsoleTitleA( title );
}

auto console_interface::c_console::set_text( const char* str, ... ) -> void {

    char buffer[ 4096 ];

    va_list args;

    va_start( args, str );
    int rc = vsnprintf( buffer, sizeof( buffer ), str, args );

    va_end( args );

    std::cout << buffer << std::endl;
}


auto console_interface::c_console::set_text_success( const char* str, ... ) -> void {

    std::cout << hash_str( "[success] : " );

    char buffer[ 4096 ];

    va_list args;

    va_start( args, str );
    int rc = vsnprintf( buffer, sizeof( buffer ), str, args );

    va_end( args );

    std::cout << buffer << std::endl;
}

auto console_interface::c_console::set_text_failure( const char* str, ... ) -> void {
    std::cout << hash_str( "[problem] : " );

    char buffer[ 4096 ];

    va_list args;

    va_start( args, str );
    int rc = vsnprintf( buffer, sizeof( buffer ), str, args );

    va_end( args );

    std::cout << buffer << std::endl;
    std::cin.get( );
}

auto console_interface::c_console::set_text_point( const char* str, ... ) -> void {
    std::cout << hash_str( " > " );

    char buffer[ 4096 ];

    va_list args;

    va_start( args, str );
    int rc = vsnprintf( buffer, sizeof( buffer ), str, args );

    va_end( args );

    std::cout << buffer << std::endl;
}

auto console_interface::c_console::set_seperator( ) -> void {
    std::cout << hash_str( "................................................................" ) << std::endl;
}

auto console_interface::c_console::set_lab_execution( const char* lab, const char* lab_function ) -> void {
    std::cout << hash_str( "\n=== " );
    std::cout << lab;
    std::cout << hash_str( " :: " );
    std::cout << lab_function;
    std::cout << hash_str( " ===" ) << std::endl;
}

auto console_interface::c_console::set_error_code( int error_code ) -> void {
    std::ostringstream message;
    message << hash_str( "It seems we've run into some trouble on your machine.\n\n" )
        << hash_str( "Architecture: " ) << sizeof( void* ) * 8 << hash_str( "-bit\n" )
        << hash_str( "Code: 0x" ) << error_code << hash_str( "\n\n" )
        << hash_str( "Learn more about this at:\nhttps://setup.calamari.lol/troubleshooting" );

    MessageBoxA( nullptr, message.str( ).c_str( ), hash_str( "Calamari" ), MB_ICONERROR | MB_OK );
    ExitProcess( 1 );
}

auto console_interface::c_console::set_box( std::string text, const char* title, const std::uint32_t& code, bool error ) -> void {
    this->set_text_point( text.c_str( ) );

    std::string lpText = text
        + hash_str( "\n\nArchitecture: Fortnite" )
        + ( hash_str( "\nCode: 0x" ) + std::to_string( code ) )
        + hash_str( "\n\nLearn more about this at:\n" )
        + troubleshoot_url;

    MessageBoxA(
        0,
        lpText.c_str( ),
        title,
        error ? MB_ICONERROR | MB_OK : MB_ICONINFORMATION | MB_OK
    );
}