#ifndef VARS_HPP
#define VARS_HPP
#include <core/inc.hpp>

namespace settings
{
	class c_instance
	{
	public:
		c_instance( ) {}
		c_instance( const std::uintptr_t& inst )
		{
			this->instance = inst;
		}
		~c_instance( ) {}

	protected:
		std::uintptr_t instance = 0;

	public:
		operator std::uintptr_t( ) const
		{
			return this->instance;
		}
	};

	class c_vars : public c_instance
	{
	public:
		using c_instance::c_instance;

	public:
		void load( );
		void save( );
		void reset( );

	public:
		struct {
			int		aim_keycode;
			int		second_aim_keycode;
			int		target_bone;
			bool	enabled;
			bool	controller;
			float	fov_c;
			bool	prediction;
			bool	prediction_indicator;
			float	smooth;
			bool	ignore_team;
			bool	ignore_knocked;
			bool	ignore_invisible;
			bool	aim_when_held;
			int		aim_distance;
		} aim;

		struct {
			bool triggerbot;
			int	 trigger_keycode;
			int	 trigger_distance;

			bool enable_delay;
			int	 trigger_delay;

			bool shotgun_only;
		} trigger;

		struct {

			bool dark_sky;
			bool infinite_fuel;

			bool vehicle_teleport; 
			int vehicle_tp_key;
			int vehicle_tp_type;

			bool speed_hack;
			float speed_hack_limit;
			int speed_hack_key;

			bool bike_jump;
			float max_jump_force;
			float max_jump_forward;

			bool car_fly;
			int key_up;
			int key_down;

			bool remove_car_animations;
			bool disable_car_gravity;

			bool instant_brakes;
			bool grippy_cars;

			bool fov_changer;
			float camera_fov;
			float ads_fov;

			bool zoom;
			bool camera_zoom_effect;
			float zoom_speed;
			int zoom_keycode;
			int zoom_value;

			bool vehicle_speedhack;
			int vehicle_speed;

			bool vehicle_airstuck;
			int key_vehicle_airstuck;

			bool sniper_bullet_tp;
			bool instant_reload;

		} exploits;

		struct {
			bool enable;
			int	 selected_weapon;

			struct {
				bool	enabled;			
				float	smooth;
				float	weapon_fov;
				int		target_bone;
			} smg;

			struct {
				bool	enabled;				
				float	smooth;
				float	weapon_fov;
				int		target_bone;
			} ars;

			struct {
				bool	enabled;
				float	weapon_fov;
				float	smooth;
				int		target_bone;
			} shotgun;

			struct {
				bool	enabled;		
				float	weapon_fov;
				float	smooth;
				int		target_bone;
			} pistol;

			struct {
				bool	enabled;	
				float	weapon_fov;
				float	smooth;
				int		target_bone;
			} snipers;

			struct {
				bool enabled;			
				float	weapon_fov;
				float	smooth;
				int		target_bone;
				int		distance;
			} close_aim;

		} weapon_config;

		struct {

			float box_width;
			int render_distance;

			bool	esp;

			int box_type;

			bool	boxes;
			bool	corners;
			bool	rotating;
			int		boxes_mode;

			bool	boxes_filled;
			bool	boxes_outline;
			float	boxes_thickness;

			bool	arrows;
			int		arrows_mode;
			bool	filled_arrows;
			bool	arrows_outline;
			float	arrow_widht;
			float	arrow_radius;

			bool	head_dot;
			bool	head_dot_outline;
			bool	head_filled;
			float	head_radius;

			bool	username;
			bool	distance;
			bool	snapline;
			bool	team;
			bool	show_only_visible_snaplines;
			int		snapline_mode;
			int		snapline_end;
			bool	snapline_outline;
			int		snapline_x;
			int		snapline_y;
			bool	weapon;
			bool	weapon_tier_color;
			bool	weapon_tier_name;
			bool	weapon_ammo;
			bool	weapon_icon;
			bool	kill_count;
			bool	skeleton;
			bool	skeleton_outline;
			int		skeleton_mode;
			float	skeleton_thickness;
			float	skeleton_outline_thickness;
			bool	skeleton_joints;
			bool	skeleton_joints_outline;
			float	skeleton_joints_radius;
			bool	rank;
			bool	rank_text;
			bool	rank_icon;
			bool	rank_tier_color;
			bool	platform;
			bool	platform_text;
			bool	platform_icon;
			bool	platform_color;
			bool	movement;
			bool	view_direction;
			bool	radar;
			bool	flags;

			bool	show_target;
			bool	show_team;
			bool	show_dbno;
			bool	visibility_check;

			bool	spectators;

			bool	chams;
			int		selected_material;

			bool	wireframe;

			bool	targetline;

			bool mark_enemies;
			int mark_enemies_bind;

			bool mark_friendly;
			int mark_friendly_bind;

			bool china_hat;
			int		china_mode;
			int		hat_points;
			float		hat_radius;
			float		hat_height;
			bool china_outline;
			bool fading_hat;

		} visuals;

		struct {
			bool aiming;
			bool crouched;
			bool idle;
			bool walking;
			bool falling;
			bool swimming;
			bool flying;
			bool wounded;
			bool reloading;

		} flags;

		struct {

			float crosshair_color[ 4 ] = { 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f };
			float fov_color[ 4 ] = { 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f, 0.4f };
			float text_color[ 4 ] = { 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f };

			float box_color[ 4 ] = { 252.0f / 255.0f, 72.0f / 255.0f, 72.0f / 255.0f, 255.0f / 255.0f };
			float corner_box_color[ 4 ] = { 252.0f / 255.0f, 72.0f / 255.0f, 72.0f / 255.0f, 255.0f / 255.0f };
			float rotating_color[ 4 ] = { 252.0f / 255.0f, 72.0f / 255.0f, 72.0f / 255.0f, 255.0f / 255.0f };
			float fill_box_color[ 4 ] = { 0.0f / 255.0f, 0.0f / 255.0f, 0.0f / 255.0f, .0f / 255.0f };
			float skeleton_color[ 4 ] = { 252.0f / 255.0f, 72.0f / 255.0f, 72.0f / 255.0f, 255.0f / 255.0f };
			float skeleton_joints_color[ 4 ] = { 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f };
			float arrows_color[ 4 ] = { 252.0f / 255.0f, 72.0f / 255.0f, 72.0f / 255.0f, 255.0f / 255.0f };
			float arrows_filled_color[ 4 ] = { 252.0f / 255.0f, 72.0f / 255.0f, 72.0f / 255.0f, 255.0f / 255.0f };
			float head_dot_color [ 4 ] = { 235.f / 255.f, 64.f / 255.f, 52.f / 255.f, 255.0f / 255.0f };

			float teammate_color[ 4 ] = { 0.00f / 255.0f, 255.0f / 255.0f, 0.00f / 255.0f, 255.0f / 255.0f };
			float knocked_color[ 4 ] = { 204.f / 255.0f, 186.f / 255.0f, 72.f / 255.0f, 255.0f / 255.0f };

			float player_visible[ 4 ] = { 0.0f / 255.0f, 255.0f / 255.0f, 0.0f / 255.0f, 255.0f / 255.0f };
			float player_invisible[ 4 ] = { 255.0f / 255.0f, 0.0f / 255.0f, 0.0f / 255.0f, 255.0f / 255.0f };
			float text_visible[ 4 ] = { 0.0f / 255.0f, 255.0f / 255.0f, 0.0f / 255.0f, 255.0f / 255.0f };
			float text_invisible[ 4 ] = { 255.0f / 255.0f, 0.0f / 255.0f, 0.0f / 255.0f, 255.0f / 255.0f };

			float weapon_color[ 4 ] = { 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f };
			float rank_color[ 4 ] = { 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f };
			float team_color[ 4 ] = { 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f };
			float username_color [ 4 ] = { 252.0f / 255.0f, 72.0f / 255.0f, 72.0f / 255.0f, 255.0f / 255.0f };
			float distance_color [ 4 ] = { 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f };
			float kill_color[ 4 ] = { 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f };
			float snapline_color[ 4 ] = { 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f };
			float view_angle_color[ 4 ] = { 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f };
			float platform_color[ 4 ] = { 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f, 255.0f / 255.0f };
			float targeted_color[ 4 ] = { 252.0f / 255.0f, 72.0f / 255.0f, 72.0f / 255.0f, 255.0f / 255.0f };
			float targetline_color[ 4 ] = { 252.0f / 255.0f, 72.0f / 255.0f, 72.0f / 255.0f, 255.0f / 255.0f };
			float prediction_color[ 4 ] = { 252.0f / 255.0f, 72.0f / 255.0f, 72.0f / 255.0f, 255.0f / 255.0f };
			float bullet_tracers_color [ 4 ] = { 0.f / 255.f, 247.f / 255.f, 255.f / 255.f, 255.0f / 255.0f };
			float movement_tracers_color [ 4 ] = { 252.0f / 255.0f, 72.0f / 255.0f, 72.0f / 255.0f, 255.0f / 255.0f };

			float enemy_color [ 4 ] = { 255.f / 255.f, 0.0f / 255.f, 0.0f / 255.f, 255.0f / 255.0f };
			float friendly_color [ 4 ] = { 0.f / 255.f, 255.f / 255.f, 0.0f / 255.f, 255.0f / 255.0f };
			float hat_color[ 4 ] = { 252.0f / 255.0f, 72.0f / 255.0f, 72.0f / 255.0f, 255.0f / 255.0f };

		} colors;

		struct {
			float radar_width;
			float radar_height;
			float radar_size;
			float radar_distance;

			float radar_solid_fill_opacity; // 0.5f
			float radar_match_opacity; // 0.5f;
			float radar_match_outline_opacity; // 0.8f;
			float radar_match_color[ 4 ] = { 252.0f / 255.0f, 72.0f / 255.0f, 72.0f / 255.0f, 255.0f / 255.0f };

			bool radar_lines;
			float radar_match_fade_out; // 0.3f
			float radar_match_size; // 1.f
			float lines_color[ 4 ] = { 0.0f / 255.0f, 0.0f / 255.0f, 0.0f / 255.0f, 255.0f };

			bool display_fov;
			float radar_fov_opacity; // 0.2f
			float radar_fov_fade_out; // 0.3f
			float radar_fov_match_size; // 1.f
			float fov_color[ 4 ] = { 255.0f / 255.0f, 0.0f / 255.0f, 0.0f / 255.0f, 255.0f };

			bool display_world_entities;

			bool display_distance;
			bool outlined_dots;

			bool ignore_wounded;
			bool ignore_teammates;
			bool ignore_invisible;

			float radar_dot_color[ 4 ] = { 255.0f / 255.0f, 0.0f / 255.0f, 0.0f / 255.0f, 255.0f };

		} radar;

		struct {
			bool	enable;

			bool	show_searchables;
			bool	show_vehicles;
			bool    show_dropped;
			bool	show_world;

			struct {
				int world_render_distance;
				bool show_world_distance;

				bool weakspots;
			} w;

			struct {
				int searchables_render_distance;
				bool show_searchables_distance;

				bool chests;
				bool ammo_boxes;
				bool lammas;
				bool airdrops;
			} s;

			struct {
				int vehicles_render_distance;
				bool show_vehicles_distance;

				bool bikes;
				bool sedans;
			} v;

			struct {
				int dropped_render_distance;
				bool show_dropped_distance;
				bool show_dropped_rarity_color;
				bool show_dropped_rarity_name;
				
				bool sort_dropped_rarity;
				bool legendary;
				bool epic;
				bool rare;
				bool common;
				bool uncommon;

				bool stone;
				bool wood;
				bool metal;

				bool sniper_ammo;
				bool pistol_ammo;
				bool rifle_ammo;
				bool shotgun_ammo;
				bool grenade_ammo;

				bool smgs;
				bool ars;
				bool shotguns;
				bool pistols;
				bool snipers;

				bool bandages;
				bool medkit;
				bool slurp;
				bool chugjug;
				bool bigpot;
				bool minis;
				bool chugsplash;

			} d;

		} loot;

		struct {

			struct {
				float weakspot_color [ 4 ] = { 0.f / 255.f, 162.f / 255.f, 255.f / 255.f, 255.0f };
			} w;

			struct {
				float chest_color [ 4 ] = { 255.f / 255.f, 183.f / 255.f, 0.f / 255.f, 255.0f };
				float ammo_box_color [ 4 ] = { 0.f / 255.f, 76.f / 255.f, 255.f / 255.f, 255.0f };
				float lammas_color [ 4 ] = { 221.f / 255.f, 66.f / 255.f, 245.f / 255.f, 255.0f };
				float airdrop_color [ 4 ] = { 0.f / 255.f, 76.f / 255.f, 255.f / 255.f, 255.0f };
			} s;

			struct {
				float bikes_color [ 4 ] = { 191.f / 255.f, 191.f / 255.f, 191.f / 255.f, 255.0f };
				float sedans_color [ 4 ] = { 191.f / 255.f, 191.f / 255.f, 191.f / 255.f, 255.0f };
			} v;

			struct {
				float wood_color [ 4 ] = { 191.f / 255.f, 191.f / 255.f, 191.f / 255.f, 255.0f };
				float stone_color [ 4 ] = { 219.f / 255.f, 139.f / 255.f, 0.f / 255.f, 255.0f };
				float metal_color [ 4 ] = { 191.f / 255.f, 191.f / 255.f, 191.f / 255.f, 255.0f };

				float sniper_ammo_color [ 4 ] = { 255.f / 255.f, 238.f / 255.f, 0.f / 255.f, 255.0f };
				float pistol_ammo_color [ 4 ] = { 255.f / 255.f, 238.f / 255.f, 0.f / 255.f, 255.0f };
				float rifle_ammo_color [ 4 ] = { 255.f / 255.f, 238.f / 255.f, 0.f / 255.f, 255.0f };
				float shotgun_ammo_color [ 4 ] = { 255.f / 255.f, 0.f / 255.f, 0.f / 255.f, 255.0f };
				float grenade_ammo_color [ 4 ] = { 72.f / 255.f, 80.f / 255.f, 2.f / 255.f, 255.0f };

				float ars_color [ 4 ] = { 191.f / 255.f, 191.f / 255.f, 191.f / 255.f, 255.0f };
				float smgs_color [ 4 ] = { 191.f / 255.f, 191.f / 255.f, 191.f / 255.f, 255.0f };
				float shotguns_color [ 4 ] = { 191.f / 255.f, 191.f / 255.f, 191.f / 255.f, 255.0f };
				float pistols_color [ 4 ] = { 191.f / 255.f, 191.f / 255.f, 191.f / 255.f, 255.0f };
				float snipers_color [ 4 ] = { 191.f / 255.f, 191.f / 255.f, 191.f / 255.f, 255.0f };

				float bandages_color [ 4 ] = { 191.f / 255.f, 191.f / 255.f, 191.f / 255.f, 255.0f };
				float medkit_color [ 4 ] = { 196.f / 255.f, 0.f / 255.f, 1.f / 255.f, 255.0f };
				float slurp_color [ 4 ] = { 29.f / 255.f, 226.f / 255.f, 254.f / 255.f, 255.0f };
				float chugjug_color [ 4 ] = { 29.f / 255.f, 226.f / 255.f, 254.f / 255.f, 255.0f };
				float bigpot_color [ 4 ] = { 52.f / 255.f, 64.f / 255.f, 207.f / 255.f, 255.0f };
				float minis_color [ 4 ] = { 52.f / 255.f, 64.f / 255.f, 207.f / 255.f, 255.0f };
				float chugspalsh_color [ 4 ] = { 29.f / 255.f, 226.f / 255.f, 254.f / 255.f, 255.0f };
			} d;

		} world_colors;

		struct {
			bool	fov;
			bool	fps;
			bool	crosshair;
			int		selected_crosshair;
			int		aqua_is_not_going_to_be_happy;
			bool	show_keybinds;
			int		keybinds;
			int		eye_tracer_length;
			int		menu_key;
			int		maximum_distance;

			bool	menu;

			bool	movement_tracers;
			bool	movement_tracers_outline;
			bool	movement_tracers_fade;
			float	movement_tracers_thickness;
			float	movement_tracers_fade_speed;
			int		movement_tracers_mode;
			int		movement_tracers_lifetime;
			int		movement_tracers_line_mode;

			bool	bullet_tracers;
			int		bullet_tracers_mode;
			bool	bullet_tracers_outline;
			float	bullet_tracers_thickness;
			int		bullet_tracers_lifetime;
			int		bullet_tracers_line_mode;
			bool	bullet_tracers_fade_effect;
			float	bullet_tracers_fade_speed;

		} misc;

		struct {
			float rotation = 0.00f;
			bool circle_filled = false;

			float length;
			float thickness;
			float gap;
			float outline;

		} crosshair;

		struct {
			float	size;
		} font;

		struct {
			std::string branding;
		} name;

		struct{
			ImVec2 keybinds_position;
			ImVec2 spectators_position;
		} moveable;

		struct {
			float rgb_speed;
			float dotted_gap;
			float dashed_gap;
		} ui;


	};
}  inline const auto g_vars = std::make_unique<settings::c_vars>( );

#endif