#pragma once
#include <core/inc.hpp>

auto textures::c_textures::create_texture_from_memory( LPDIRECT3DDEVICE9 device, LPCVOID data, UINT data_size ) -> IDirect3DTexture9*
{
	IDirect3DTexture9* texture = nullptr;

	HRESULT result = D3DXCreateTextureFromFileInMemoryEx( device, data, data_size, 100, 100, D3DX_DEFAULT, 0, D3DFMT_UNKNOWN, D3DPOOL_DEFAULT, D3DX_DEFAULT, D3DX_DEFAULT, 0, NULL, NULL, &texture );
	if ( FAILED( result ) )
		return nullptr;

	return texture;
}

auto textures::c_textures::get_texture_from_memory( const std::string& item_name, LPCVOID data, UINT data_size ) -> IDirect3DTexture9*
{
	if ( m_memory_cache.find( item_name ) != m_memory_cache.end( ) )
		return m_memory_cache[ item_name ];

	IDirect3DTexture9* texture = create_texture_from_memory( g_render->p_device, data, data_size );
	if ( !texture )
		return nullptr;

	m_memory_cache.emplace( item_name, texture );
	return texture;
}