#ifndef ICONS_HPP
#define ICONS_HPP

namespace icons_data
{
	struct icon_data_map
	{
		LPCVOID data;
		UINT data_size;
		ImVec2 icon_size;
		IDirect3DTexture9* texture;

		bool operator<( const icon_data_map& other ) const
		{
			if ( data_size != other.data_size )
				return data_size < other.data_size;

			return data < other.data;
		}
	};

	class c_icons
	{
	public:

		std::multimap<icon_data_map, std::string> icons_map;

		bool render_icon( const std::string& item_name, const ImVec2& position, ImColor color = ImColor( 255, 255, 255 ) );
		icon_data_map get_icon_data( const std::string& item_name );

		explicit c_icons( );
	};
}
inline auto g_icons = std::make_shared<icons_data::c_icons>( );

#endif // !ICONS_HPP