#pragma once 
#include <core/inc.hpp>

icons_data::c_icons::c_icons( )
{
	this->icons_map.insert( { icon_data_map { &icons::weapons::ak47, sizeof( icons::weapons::ak47 ), ImVec2( 26, 10 ) }, hash_str( "rifle.ak" ) } ); 
	this->icons_map.insert( { icon_data_map { &icons::weapons::pump_shotgun, sizeof( icons::weapons::pump_shotgun ), ImVec2( 26, 7 ) }, hash_str( "shotgun.pump" ) } ); 
	this->icons_map.insert( { icon_data_map { &icons::weapons::mp5, sizeof( icons::weapons::mp5 ), ImVec2( 21, 9 ) }, hash_str( "smg.mp5" ) } ); 
	this->icons_map.insert( { icon_data_map { &icons::weapons::syringe, sizeof( icons::weapons::syringe ), ImVec2( 21, 7 ) }, hash_str( "syringe.medical" ) } ); 
	this->icons_map.insert( { icon_data_map { &icons::weapons::bolt_action, sizeof( icons::weapons::bolt_action ), ImVec2( 26, 8 ) }, hash_str( "rifle.bolt" ) } ); 

	this->icons_map.insert( { icon_data_map { &icons::ranks::champion, sizeof( icons::ranks::champion ), ImVec2( 20, 20 ) }, hash_str( "Champion" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::platinum3, sizeof( icons::ranks::platinum3 ), ImVec2( 20, 20 ) }, hash_str( "Platinum 3" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::platinum1, sizeof( icons::ranks::platinum1 ), ImVec2( 20, 20 ) }, hash_str( "Platinum 1" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::platinum2, sizeof( icons::ranks::platinum2 ), ImVec2( 20, 20 ) }, hash_str( "Platinum 2" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::gold2, sizeof( icons::ranks::gold2 ), ImVec2( 20, 20 ) }, hash_str( "Gold 2" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::elite, sizeof( icons::ranks::elite ), ImVec2( 20, 20 ) }, hash_str( "Elite" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::diamond1, sizeof( icons::ranks::diamond1 ), ImVec2( 20, 20 ) }, hash_str( "Diamond 1" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::diamond3, sizeof( icons::ranks::diamond3 ), ImVec2( 20, 20 ) }, hash_str( "Diamond 3" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::diamond2, sizeof( icons::ranks::diamond2 ), ImVec2( 20, 20 ) }, hash_str( "Diamond 2" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::gold1, sizeof( icons::ranks::gold1 ), ImVec2( 20, 20 ) }, hash_str( "Gold 1" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::unranked, sizeof( icons::ranks::unranked ), ImVec2( 20, 20 ) }, hash_str( "Unranked" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::unreal, sizeof( icons::ranks::unreal ), ImVec2( 20, 20 ) }, hash_str( "Unreal" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::bronze3, sizeof( icons::ranks::bronze3 ), ImVec2( 20, 20 ) }, hash_str( "Bronze 3" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::silver1, sizeof( icons::ranks::silver1 ), ImVec2( 20, 20 ) }, hash_str( "Silver 1" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::gold3, sizeof( icons::ranks::gold3 ), ImVec2( 20, 20 ) }, hash_str( "Gold 3" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::silver3, sizeof( icons::ranks::silver3 ), ImVec2( 20, 20 ) }, hash_str( "Silver 3" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::bronze1, sizeof( icons::ranks::bronze1 ), ImVec2( 20, 20 ) }, hash_str( "Bronze 1" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::bronze2, sizeof( icons::ranks::bronze2 ), ImVec2( 20, 20 ) }, hash_str( "Bronze 2" ) } );
	this->icons_map.insert( { icon_data_map { &icons::ranks::silver2, sizeof( icons::ranks::silver2 ), ImVec2( 20, 20 ) }, hash_str( "Silver 2" ) } );

	this->icons_map.insert( { icon_data_map { &icons::platforms::windows, sizeof( icons::platforms::windows ), ImVec2( 20, 20 ) }, hash_str( "WIN" ) } );
	this->icons_map.insert( { icon_data_map { &icons::platforms::nintendo, sizeof( icons::platforms::nintendo ), ImVec2( 20, 20 ) }, hash_str( "SWT" ) } );
	this->icons_map.insert( { icon_data_map { &icons::platforms::playstation, sizeof( icons::platforms::playstation ), ImVec2( 20, 20 ) }, hash_str( "PS4" ) } );
	this->icons_map.insert( { icon_data_map { &icons::platforms::playstation, sizeof( icons::platforms::playstation ), ImVec2( 20, 20 ) }, hash_str( "PS5" ) } );
	this->icons_map.insert( { icon_data_map { &icons::platforms::xbox, sizeof( icons::platforms::xbox ), ImVec2( 20, 20 ) }, hash_str( "XBL" ) } );
	this->icons_map.insert( { icon_data_map { &icons::platforms::xbox, sizeof( icons::platforms::xbox ), ImVec2( 20, 20 ) }, hash_str( "XSX" ) } );
	this->icons_map.insert( { icon_data_map { &icons::platforms::apple, sizeof( icons::platforms::apple ), ImVec2( 20, 20 ) }, hash_str( "MAC" ) } );
	this->icons_map.insert( { icon_data_map { &icons::platforms::apple, sizeof( icons::platforms::apple ), ImVec2( 20, 20 ) }, hash_str( "IOS" ) } );

	this->icons_map.insert( { icon_data_map { &icons::calamari, sizeof( icons::calamari ), ImVec2( 114, 114 ) }, hash_str( "Calamari" ) } );
}

auto icons_data::c_icons::render_icon( const std::string& item_name, const ImVec2& position, ImColor color ) -> bool
{
	for ( const auto& weapon : this->icons_map )
	{
		if ( weapon.second == item_name )
		{
			auto texture = g_textures->get_texture_from_memory(
				item_name,
				weapon.first.data,
				weapon.first.data_size
			);

			ImVec2 icon_size = weapon.first.icon_size;
			ImVec2 icon_position( position.x - ( weapon.first.icon_size.x / 2 ), position.y );
			ImVec2 bottom_right_rect( icon_position.x + icon_size.x, icon_position.y + icon_size.y );

			if ( texture ) {
				g_framework->add_image( texture, icon_position, bottom_right_rect, color );
				return true;
			}
		}
	}

	return false;
}

auto icons_data::c_icons::get_icon_data( const std::string& item_name ) -> icon_data_map
{
	for ( const auto& item : this->icons_map )
	{
		if ( item.second == item_name )
		{
			auto texture = g_textures->get_texture_from_memory(
				item_name,
				item.first.data,
				item.first.data_size
			);

			auto data = icon_data_map( );

			data.texture = texture;
			data.icon_size = item.first.icon_size;

			return data;
		}
	}

	return {};
}