﻿#ifndef INTERFACE_CPP
#define INTERFACE_CPP
#include <core/inc.hpp>

auto menu_interface::c_interface::load( ) -> void
{
	ImGui::GetStyle( ).ScrollbarSize = 1;
	ImGui::GetStyle( ).FrameBorderSize = 1;
	ImGui::GetStyle( ).FrameRounding = 0;
	ImGui::GetStyle( ).WindowPadding = ImVec2( 7.0f, 5.0f );
	ImGui::GetStyle( ).WindowTitleAlign = ImVec2( 0.5f, 0.5f );

	ImVec4* colors = ImGui::GetStyle( ).Colors;
	colors [ ImGuiCol_FrameBgHovered ] = ImColor( 156, 18, 18 );
	colors [ ImGuiCol_FrameBgActive ] = ImColor( 112, 18, 18 );
	colors [ ImGuiCol_FrameBg ] = ImColor( 112, 18, 18 );
	colors [ ImGuiCol_TitleBg ] = ImColor( 48, 48, 48, 255 );
	colors [ ImGuiCol_TitleBgActive ] = ImColor( 48, 48, 48, 255 );
	colors [ ImGuiCol_WindowBg ] = ImColor( 32, 32, 32, 255 );
	colors [ ImGuiCol_PopupBg ] = colors [ ImGuiCol_WindowBg ];
	colors [ ImGuiCol_HeaderActive ] = ImColor( 112, 18, 18 );
	colors [ ImGuiCol_HeaderHovered ] = ImColor( 156, 18, 18 );
	colors [ ImGuiCol_Header ] = ImColor( 156, 18, 18 );
	colors [ ImGuiCol_PlotHistogram ] = ImColor( 232, 135, 54, 255 );
	colors [ ImGuiCol_ButtonActive ] = ImColor( 112, 18, 18 );
	colors [ ImGuiCol_Button ] = ImColor( 112, 18, 18 );
	colors [ ImGuiCol_ButtonHovered ] = ImColor( 156, 18, 18 );
	colors [ ImGuiCol_CheckMark ] = ImColor( 255, 255, 255 );
}

auto menu_interface::c_interface::draw_interface( ) -> void
{
	ImGui::SetNextWindowSize( ImVec2( 96, 169 ) );

	if ( ImGui::Begin( g_vars->name.branding.c_str( ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize ) )
	{
		auto window_pos = ImGui::GetWindowPos( );
		auto window_size = ImGui::GetWindowSize( );

		static int radio_selected = 0;

		ImGui::CustomRadioButton( hash_str( "ESP" ), &radio_selected, 1 );
		ImGui::CustomRadioButton( hash_str( "RADAR" ), &radio_selected, 2 );
		ImGui::CustomRadioButton( hash_str( "AIM" ), &radio_selected, 3 );
		ImGui::CustomRadioButton( hash_str( "WORLD" ), &radio_selected, 4 );
		ImGui::CustomRadioButton( hash_str( "EXPLOITS" ), &radio_selected, 5 );
		ImGui::CustomRadioButton( hash_str( "SETTINGS" ), &radio_selected, 6 );

		switch ( radio_selected )
		{
		case 1:
		{
			ImGui::SetNextWindowPos( ImVec2( window_pos.x + window_size.x + 3.0f, window_pos.y ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "ESP" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

			static int subtab = 0;

			if ( ImGui::Subtab( hash_str( "Main" ), subtab == 0, { ImGui::GetWindowWidth( ) / 2 - ImGui::GetStyle( ).WindowPadding.x - ImGui::GetStyle( ).ItemSpacing.x / 2, ImGui::GetFrameHeight( ) } ) ) {
				subtab = 0;
			}

			ImGui::SameLine( );

			if ( ImGui::Subtab( hash_str( "Other" ), subtab == 1, { ImGui::GetWindowWidth( ) / 2 - ImGui::GetStyle( ).WindowPadding.x - ImGui::GetStyle( ).ItemSpacing.x / 2, ImGui::GetFrameHeight( ) } ) ) {
				subtab = 1;
			}

			switch ( subtab )
			{
			case 0:
			{
				ImGui::Spacing( );
				ImGui::Text( hash_str( "Enable Visuals" ) );

				ImGui::ColoredCheckbox( hash_str( "Visuals" ), g_vars->visuals.esp, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				if ( g_vars->visuals.esp )
				{
					ImGui::Spacing( );
					ImGui::Text( hash_str( "Box Selection" ) );

					ImGui::Combo( hash_str( "Box Type" ), &g_vars->visuals.box_type, box_modes, IM_ARRAYSIZE( box_modes ) );

					switch ( g_vars->visuals.box_type )
					{
					case 1:
						g_vars->visuals.corners = false;
						g_vars->visuals.rotating = false;
						g_vars->visuals.boxes = true;
						break;
					case 2:
						g_vars->visuals.corners = true;
						g_vars->visuals.rotating = false;
						g_vars->visuals.boxes = false;
						break;
					case 3:
						g_vars->visuals.corners = false;
						g_vars->visuals.rotating = true;
						g_vars->visuals.boxes = false;
						break;
					default:
						g_vars->visuals.corners = false;
						g_vars->visuals.rotating = false;
						g_vars->visuals.boxes = false;
						break;
					}

					if ( g_vars->visuals.box_type != 0 )
					{
						ImGui::Spacing( );
						ImGui::Text( hash_str( "Box Color Configuration" ) );

						ImGui::Combo( hash_str( "Box Color Mode" ), &g_vars->visuals.boxes_mode, color_modes, IM_ARRAYSIZE( color_modes ) );
						ImGui::ColoredCheckbox( hash_str( "Box Outline" ), g_vars->visuals.boxes_outline, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
						
						ImGui::Spacing( );
						ImGui::Text( hash_str( "Box Display Configuration" ) );
						
						if ( g_vars->visuals.boxes_outline ) ImGui::ColoredSliderFloat( hash_str( "Box Outline Thickness" ), &g_vars->visuals.boxes_thickness, 0.1f, 3.f, 0, IM_COL32( 255, 255, 255, 255 ) );
						ImGui::ColoredCheckbox( hash_str( "Filled Box" ), g_vars->visuals.boxes_filled, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.fill_box_color );
					}

					ImGui::Spacing( );
					ImGui::Text( hash_str( "Skeletons Configuration" ) );

					ImGui::ColoredCheckbox( hash_str( "Skeletons" ), g_vars->visuals.skeleton, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.skeleton_color );
					if ( g_vars->visuals.skeleton )
					{
						ImGui::Spacing( );
						ImGui::Text( hash_str( "Skeletons Color Configuration" ) );

						ImGui::Combo( hash_str( "Skeletons Color Mode" ), &g_vars->visuals.skeleton_mode, color_modes, IM_ARRAYSIZE( color_modes ) );
						ImGui::ColoredCheckbox( hash_str( "Outlined Skeletons" ), g_vars->visuals.skeleton_outline, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
						
						ImGui::Spacing( );
						ImGui::Text( hash_str( "Skeletons Display Configuration" ) );

						ImGui::ColoredSliderFloat( hash_str( "Bones Scale" ), &g_vars->visuals.skeleton_thickness, 0.01f, 4.f, 0, IM_COL32( 255, 255, 255, 255 ) );
						ImGui::ColoredSliderFloat( hash_str( "Bones Outline Scale" ), &g_vars->visuals.skeleton_outline_thickness, g_vars->visuals.skeleton_thickness, g_vars->visuals.skeleton_thickness + 4.f, 0, IM_COL32( 255, 255, 255, 255 ) );
						
						ImGui::Spacing( );
						ImGui::Text( hash_str( "Skeletons Joints" ) );

						ImGui::ColoredCheckbox( hash_str( "Skeleton Joints" ), g_vars->visuals.skeleton_joints, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.skeleton_joints_color );
						if ( g_vars->visuals.skeleton_joints )
						{
							ImGui::Spacing( );
							ImGui::Text( hash_str( "Skeletons Joints Configuration" ) );

							ImGui::ColoredCheckbox( hash_str( "Joints Outline" ), g_vars->visuals.skeleton_joints_outline, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
							ImGui::ColoredSliderFloat( hash_str( "Joints Scale" ), &g_vars->visuals.skeleton_joints_radius, 0.1f, 3.f, 0, IM_COL32( 255, 255, 255, 255 ) );
						}
					}

					ImGui::ColoredCheckbox( hash_str( "View Direction" ), g_vars->visuals.view_direction, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.view_angle_color );
					if ( g_vars->visuals.view_direction ) {

						ImGui::Spacing( );
						ImGui::Text( hash_str( "View Direction Configuration" ) );

						ImGui::ColoredSliderInt( hash_str( "View Direction Length" ), &g_vars->misc.eye_tracer_length, 50, 400, 0, IM_COL32( 255, 255, 255, 255 ) );
					}

					ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x, ImGui::GetWindowPos( ).y + ImGui::GetWindowHeight( ) + 3.0f ) );
					ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
					ImGui::Begin( hash_str( "SPECTATORS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_AlwaysAutoResize );
					
					ImGui::ColoredCheckbox( hash_str( "Spectators" ), g_vars->visuals.spectators, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				
					ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
					ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
					ImGui::Begin( hash_str( "VISUALS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );
				
					ImGui::Spacing( );
					ImGui::Text( hash_str( "Visuals Adjustments" ) );

					ImGui::ColoredCheckbox( hash_str( "Username" ), g_vars->visuals.username, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
					ImGui::ColoredCheckbox( hash_str( "Distance" ), g_vars->visuals.distance, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
					ImGui::ColoredCheckbox( hash_str( "Platform" ), g_vars->visuals.platform, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.platform_color );
					ImGui::ColoredCheckbox( hash_str( "Team ID" ), g_vars->visuals.team, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.team_color );
					ImGui::ColoredCheckbox( hash_str( "Kills" ), g_vars->visuals.kill_count, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.kill_color );

					ImGui::ColoredCheckbox( hash_str( "Display Flags" ), g_vars->visuals.flags, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

					flags [ 0 ].selected = g_vars->flags.aiming;
					flags [ 1 ].selected = g_vars->flags.crouched;
					flags [ 2 ].selected = g_vars->flags.falling;
					flags [ 3 ].selected = g_vars->flags.flying;
					flags [ 4 ].selected = g_vars->flags.idle;
					flags [ 5 ].selected = g_vars->flags.reloading;
					flags [ 6 ].selected = g_vars->flags.swimming;
					flags [ 7 ].selected = g_vars->flags.walking;
					flags [ 8 ].selected = g_vars->flags.wounded;

					ImGui::MultiSelect( hash_str( "Flags" ), flags );

					g_vars->flags.aiming = flags [ 0 ].selected;
					g_vars->flags.crouched = flags [ 1 ].selected;
					g_vars->flags.falling = flags [ 2 ].selected;
					g_vars->flags.flying = flags [ 3 ].selected;
					g_vars->flags.idle = flags [ 4 ].selected;
					g_vars->flags.reloading = flags [ 5 ].selected;
					g_vars->flags.swimming = flags [ 6 ].selected;
					g_vars->flags.walking = flags [ 7 ].selected;
					g_vars->flags.wounded = flags [ 8 ].selected;

					ImGui::ColoredCheckbox( hash_str( "Weapon" ), g_vars->visuals.weapon, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.weapon_color );
					if ( g_vars->visuals.weapon )
					{
						ImGui::Spacing( );
						ImGui::Text( hash_str( "Weapon Adjustments" ) );

						ImGui::ColoredCheckbox( hash_str( "Show Ammo" ), g_vars->visuals.weapon_ammo, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
						ImGui::ColoredCheckbox( hash_str( "Weapon Tier" ), g_vars->visuals.weapon_tier_name, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
						ImGui::ColoredCheckbox( hash_str( "Show Weapon Tier Color" ), g_vars->visuals.weapon_tier_color, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
						ImGui::ColoredCheckbox( hash_str( "Show Weapon Icon" ), g_vars->visuals.weapon_icon, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
					}

					ImGui::ColoredCheckbox( hash_str( "Arena Rank" ), g_vars->visuals.rank, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.rank_color );
					if ( g_vars->visuals.rank )
					{
						ImGui::Spacing( );
						ImGui::Text( hash_str( "Rank Adjustments" ) );

						ImGui::ColoredCheckbox( hash_str( "Show Rank Text" ), g_vars->visuals.rank_text, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
						ImGui::ColoredCheckbox( hash_str( "Show Rank Icon" ), g_vars->visuals.rank_icon, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
						ImGui::ColoredCheckbox( hash_str( "Show Rank Tier Color" ), g_vars->visuals.rank_tier_color, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
					}

					ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x, ImGui::GetWindowPos( ).y + ImGui::GetWindowHeight( ) + 3.0f ) );
					ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
					ImGui::Begin( hash_str( "CHAMS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_AlwaysAutoResize );
					
					ImGui::Spacing( );
					ImGui::Text( hash_str( "Glowing Chams" ) );

					ImGui::ColoredCheckbox( hash_str( "Player Chams" ), g_vars->visuals.chams, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
					ImGui::Combo( hash_str( "Material" ), &g_vars->visuals.selected_material, cham_parts, IM_ARRAYSIZE( cham_parts ) );

					ImGui::Spacing( );
					ImGui::Text( hash_str( "Wireframe Chams" ) );

					ImGui::ColoredCheckbox( hash_str( "Wireframe" ), g_vars->visuals.wireframe, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				}

				break;
			}

			case 1:
			{
				ImGui::Spacing( );
				ImGui::Text( hash_str( "Render Configuration" ) );

				ImGui::ColoredSliderInt( hash_str( "Render Distance" ), &g_vars->misc.maximum_distance, 0, 400, 0, IM_COL32( 255, 255, 255, 255 ) );
						
				ImGui::Spacing( );
				ImGui::Text( hash_str( "Visibility Configuration" ) );

				ImGui::ColoredCheckbox( hash_str( "Visibility Check" ), g_vars->visuals.visibility_check, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				if ( g_vars->visuals.visibility_check )
				{
					ImGui::Spacing( );
					ImGui::Text( hash_str( "Visible Colors" ) );

					ImGui::CustomColorEdit4( hash_str( "Visible Color" ), g_vars->colors.player_visible, ImGuiColorEditFlags_NoInputs | ImGuiColorEditFlags_NoLabel );

					ImGui::SetCursorPos( ImVec2( ImGui::GetCursorPos( ).x, ImGui::GetCursorPos( ).y - 4.0f ) );
					ImGui::CustomColorEdit4( hash_str( "Text Visible Color" ), g_vars->colors.text_visible, ImGuiColorEditFlags_NoInputs | ImGuiColorEditFlags_NoLabel );

					ImGui::Spacing( );
					ImGui::Text( hash_str( "Invisible Colors" ) );

					ImGui::SetCursorPos( ImVec2( ImGui::GetCursorPos( ).x, ImGui::GetCursorPos( ).y - 4.0f ) );
					ImGui::CustomColorEdit4( hash_str( "Invisible Color" ), g_vars->colors.player_invisible, ImGuiColorEditFlags_NoInputs | ImGuiColorEditFlags_NoLabel );

					ImGui::SetCursorPos( ImVec2( ImGui::GetCursorPos( ).x, ImGui::GetCursorPos( ).y - 4.0f ) );
					ImGui::CustomColorEdit4( hash_str( "Text Invisible Color" ), g_vars->colors.text_invisible, ImGuiColorEditFlags_NoInputs | ImGuiColorEditFlags_NoLabel );
				}

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Player Filter" ) );

				ImGui::ColoredCheckbox( hash_str( "Display Teammates" ), g_vars->visuals.show_team, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.teammate_color );
				ImGui::ColoredCheckbox( hash_str( "Display Knocked" ), g_vars->visuals.show_dbno, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.knocked_color );
				ImGui::ColoredCheckbox( hash_str( "Display Targeted" ), g_vars->visuals.show_target, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.targeted_color );
				
				ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x, ImGui::GetWindowPos( ).y + ImGui::GetWindowHeight( ) + 3.0f ) );
				ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
				ImGui::Begin( hash_str( "GENERAL" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_AlwaysAutoResize );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Chinese Hat" ) );

				ImGui::ColoredCheckbox( hash_str( "Chinese Hat" ), g_vars->visuals.china_hat, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.hat_color );
				ImGui::Combo( hash_str( "Hat Color Mode" ), &g_vars->visuals.china_mode, color_modes, IM_ARRAYSIZE( color_modes ) );
				ImGui::ColoredCheckbox( hash_str( "Hat Outline" ), g_vars->visuals.china_outline, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				ImGui::ColoredSliderInt( hash_str( "Hat Points" ), &g_vars->visuals.hat_points, 0, 60, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::ColoredSliderFloat( hash_str( "Hat Radius" ), &g_vars->visuals.hat_radius, 0.f, 150.f, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::ColoredSliderFloat( hash_str( "Hat Height" ), &g_vars->visuals.hat_height, 0.f, 150.f, 0, IM_COL32( 255, 255, 255, 255 ) );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Player Marking" ) );

				ImGui::ColoredCheckbox( hash_str( "Mark Friendly" ), g_vars->visuals.mark_friendly, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				ImGui::Hotkey( hash_str( "Friendly Key" ), &g_vars->visuals.mark_friendly_bind );

				ImGui::ColoredCheckbox( hash_str( "Mark Enemies" ), g_vars->visuals.mark_enemies, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				ImGui::Hotkey( hash_str( "Enemies Key" ), &g_vars->visuals.mark_enemies_bind );

				ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
				ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
				ImGui::Begin( hash_str( "INDICATORS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Arrow Indicators" ) );

				ImGui::ColoredCheckbox( hash_str( "Arrow Indicators" ), g_vars->visuals.arrows, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.arrows_color );
				if ( g_vars->visuals.arrows )
				{
					ImGui::Spacing( );
					ImGui::Text( hash_str( "Arrows Display Configuration" ) );

					ImGui::Combo( hash_str( "Arrows Color Mode" ), &g_vars->visuals.arrows_mode, color_modes, IM_ARRAYSIZE( color_modes ) );
					ImGui::ColoredCheckbox( hash_str( "Filled Arrows" ), g_vars->visuals.filled_arrows, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.arrows_filled_color );
					ImGui::ColoredCheckbox( hash_str( "Outlined Arrows" ), g_vars->visuals.arrows_outline, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
					
					ImGui::Spacing( );
					ImGui::Text( hash_str( "Arrows Dimensions Configuration" ) );
					
					ImGui::ColoredSliderFloat( hash_str( "Arrows Width" ), &g_vars->visuals.arrow_widht, 5.f, 25.f, 0, IM_COL32( 255, 255, 255, 255 ) );
					ImGui::ColoredSliderFloat( hash_str( "Arrows Radius" ), &g_vars->visuals.arrow_radius, 0.1f, 500.f, 0, IM_COL32( 255, 255, 255, 255 ) );
				}

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Snaplines Indicators" ) );

				ImGui::ColoredCheckbox( hash_str( "Snaplines" ), g_vars->visuals.snapline, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				if ( g_vars->visuals.snapline )
				{
					ImGui::Spacing( );
					ImGui::Text( hash_str( "Snapline Display Configuration" ) );

					ImGui::Combo( hash_str( "Snapline Color Mode" ), &g_vars->visuals.snapline_mode, color_modes, IM_ARRAYSIZE( color_modes ) );
					ImGui::ColoredCheckbox( hash_str( "Outlined Snaplines" ), g_vars->visuals.snapline_outline, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
					
					ImGui::Spacing( );
					ImGui::Text( hash_str( "Snapline Dimensions Configuration" ) );
					
					ImGui::ColoredSliderInt( hash_str( "Snaplines End" ), &g_vars->visuals.snapline_end, 0, 1, 0, IM_COL32( 255, 255, 255, 255 ) );
					ImGui::ColoredSliderInt( hash_str( "Snapline X-Axis" ), &g_vars->visuals.snapline_x, 0, ( int ) g_render->width, 0, IM_COL32( 255, 255, 255, 255 ) );
					ImGui::ColoredSliderInt( hash_str( "Snapline Y-Axis" ), &g_vars->visuals.snapline_y, 0, ( int ) g_render->height, 0, IM_COL32( 255, 255, 255, 255 ) );
				}

				ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x, ImGui::GetWindowPos( ).y + ImGui::GetWindowHeight( ) + 3.0f ) );
				ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
				ImGui::Begin( hash_str( "TRACERS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_AlwaysAutoResize );

				ImGui::ColoredCheckbox( hash_str( "Movement Tracers" ), g_vars->misc.movement_tracers, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.movement_tracers_color );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Tracers Configuration" ) );

				ImGui::Combo( hash_str( "Movement Color Mode" ), &g_vars->misc.movement_tracers_mode, color_modes, IM_ARRAYSIZE( color_modes ) );
				ImGui::Combo( hash_str( "Tracers Line Mode" ), &g_vars->misc.movement_tracers_line_mode, line_modes, IM_ARRAYSIZE( line_modes ) );
				ImGui::ColoredSliderInt( hash_str( "Tracers Lifetime" ), &g_vars->misc.movement_tracers_lifetime, 0, 8, 0, IM_COL32( 255, 255, 255, 255 ) );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Tracers Visual Configuration" ) );

				ImGui::ColoredSliderFloat( hash_str( "Tracers Thickness" ), &g_vars->misc.movement_tracers_thickness, 0.1f, 2.00f, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::ColoredCheckbox( hash_str( "Movement Tracers Outline" ), g_vars->misc.movement_tracers_outline, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Tracers Fade Configuration" ) );

				ImGui::ColoredCheckbox( hash_str( "Movement Tracers Fade" ), g_vars->misc.movement_tracers_fade, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				ImGui::ColoredSliderFloat( hash_str( "Fade Speed" ), &g_vars->misc.movement_tracers_fade_speed, 0.1f, 7.00f, 0, IM_COL32( 255, 255, 255, 255 ) );

				break;
			}
			}

			ImGui::End( );

			break;
		}

		case 2:
		{
			ImGui::SetNextWindowPos( ImVec2( window_pos.x + window_size.x + 3.0f, window_pos.y ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "RADAR" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

			ImGui::ColoredCheckbox( hash_str( "Radar" ), g_vars->visuals.radar, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->radar.radar_match_color );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Radar Configuration" ) );

			ImGui::ColoredSliderFloat( hash_str( "Size" ), &g_vars->radar.radar_size, 50.f, 1000.f, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Radar Opacity Configuration" ) );

			ImGui::ColoredSliderFloat( hash_str( "Solid Fill Opacity" ), &g_vars->radar.radar_solid_fill_opacity, 0.1f, 1.f, 0, IM_COL32( 255, 255, 255, 255 ) );
			ImGui::ColoredSliderFloat( hash_str( "Match Opacity" ), &g_vars->radar.radar_match_opacity, 0.0f, 1.f, 0, IM_COL32( 255, 255, 255, 255 ) );
			ImGui::ColoredSliderFloat( hash_str( "Match Outline Opacity" ), &g_vars->radar.radar_match_outline_opacity, 0.0f, 1.f, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Radar Distance Configuration" ) );

			ImGui::ColoredSliderFloat( hash_str( "Radar Distance" ), &g_vars->radar.radar_distance, 10.f, 500.f, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Radar Matches Configuration" ) );

			ImGui::ColoredCheckbox( hash_str( "Radar Matches" ), g_vars->radar.radar_lines, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->radar.lines_color );

			ImGui::ColoredSliderFloat( hash_str( "Match Fade Out" ), &g_vars->radar.radar_match_fade_out, 0.1f, 1.f, 0, IM_COL32( 255, 255, 255, 255 ) );
			ImGui::ColoredSliderFloat( hash_str( "Match Size" ), &g_vars->radar.radar_match_size, 0.1f, 3.f, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Radar FOV Configuration" ) );

			ImGui::ColoredCheckbox( hash_str( "Radar FOV" ), g_vars->radar.display_fov, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->radar.fov_color );

			ImGui::ColoredSliderFloat( hash_str( "FOV Opacity" ), &g_vars->radar.radar_fov_opacity, 0.1f, 1.f, 0, IM_COL32( 255, 255, 255, 255 ) );
			ImGui::ColoredSliderFloat( hash_str( "FOV Fade Out" ), &g_vars->radar.radar_fov_fade_out, 0.1f, 1.f, 0, IM_COL32( 255, 255, 255, 255 ) );
			ImGui::ColoredSliderFloat( hash_str( "FOV Match Size" ), &g_vars->radar.radar_fov_match_size, 0.1f, 3.f, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Radar Display Configuration" ) );

			ImGui::CustomColorEdit4( hash_str( "Entities Color" ), g_vars->radar.radar_dot_color, ImGuiColorEditFlags_NoInputs | ImGuiColorEditFlags_NoLabel );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Radar Entities Configuration" ) );

			ImGui::ColoredCheckbox( hash_str( "Show Entites Distance" ), g_vars->radar.display_distance, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::ColoredCheckbox( hash_str( "Outlined Entites" ), g_vars->radar.outlined_dots, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Radar Player Configuration" ) );

			ignore_parts [ 0 ].selected = g_vars->radar.ignore_wounded;
			ignore_parts [ 1 ].selected = g_vars->radar.ignore_teammates;
			ignore_parts [ 2 ].selected = g_vars->radar.ignore_invisible;

			ImGui::MultiSelect( hash_str( "Ignore Player Options" ), ignore_parts );

			g_vars->radar.ignore_wounded = ignore_parts [ 0 ].selected;
			g_vars->radar.ignore_teammates = ignore_parts [ 1 ].selected;
			g_vars->radar.ignore_invisible = ignore_parts [ 2 ].selected;

			ImGui::End( );

			break;
		}

		case 3:
		{
			ImGui::SetNextWindowPos( ImVec2( window_pos.x + window_size.x + 3.0f, window_pos.y ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "AIM" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

			ImGui::ColoredCheckbox( hash_str( "Aim Assist" ), g_vars->aim.enabled, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			if ( g_vars->aim.enabled )
			{
				ImGui::Spacing( );
				ImGui::Text( hash_str( "Aim Assist Configuration" ) );

				ImGui::Hotkey( hash_str( "Aim Assist Primary Key" ), &g_vars->aim.aim_keycode );
				ImGui::Hotkey( hash_str( "Aim Assist Secondary Key" ), &g_vars->aim.second_aim_keycode );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Aim Smoothing Configuration" ) );

				ImGui::ColoredSliderFloat( hash_str( "Aim Smoothing" ), &g_vars->aim.smooth, 0, 25, 0, IM_COL32( 255, 255, 255, 255 ) );
			}

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Aim Assist Configuration" ) );

			ImGui::ColoredSliderInt( hash_str( "Distance" ), &g_vars->aim.aim_distance, 0, 400, 0, IM_COL32( 255, 255, 255, 255 ) );
			ImGui::Combo( hash_str( "Target Bone" ), &g_vars->aim.target_bone, body_parts, IM_ARRAYSIZE( body_parts ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "FOV Configuration" ) );

			ImGui::ColoredCheckbox( hash_str( "Show Radius" ), g_vars->misc.fov, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::ColoredSliderFloat( hash_str( "Radius" ), &g_vars->aim.fov_c, 0, 1000, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Aimbot Filter" ) );

			ImGui::ColoredCheckbox( hash_str( "Only Aim When Weapon Held" ), g_vars->aim.aim_when_held, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::ColoredCheckbox( hash_str( "Prediction" ), g_vars->aim.prediction, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::ColoredCheckbox( hash_str( "Controller Support" ), g_vars->aim.controller, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Player Filter" ) );

			ImGui::ColoredCheckbox( hash_str( "Ignore Invisible" ), g_vars->aim.ignore_invisible, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::ColoredCheckbox( hash_str( "Ignore Knocked" ), g_vars->aim.ignore_knocked, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::ColoredCheckbox( hash_str( "Ignore Teammates" ), g_vars->aim.ignore_team, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Aimbot Visualization" ) );

			ImGui::ColoredCheckbox( hash_str( "Show Targetline" ), g_vars->visuals.targetline, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.targetline_color );

			ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "CONFIGS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Weapon Configuration" ) );

			ImGui::ColoredCheckbox( hash_str( "Weapon Configuration" ), g_vars->weapon_config.enable, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::Combo( hash_str( "Selected Weapon" ), &g_vars->weapon_config.selected_weapon, weapon_parts, IM_ARRAYSIZE( weapon_parts ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Configuration" ) );

			if ( g_vars->weapon_config.selected_weapon == 0 )
			{
				ImGui::ColoredCheckbox( hash_str( "Enable" ), g_vars->weapon_config.ars.enabled, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				ImGui::Spacing( );

				ImGui::ColoredSliderFloat( hash_str( "ARS Smoothing" ), &g_vars->weapon_config.ars.smooth, 0, 10, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::ColoredSliderFloat( hash_str( "FOV Radius" ), &g_vars->weapon_config.ars.weapon_fov, 0, 500, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::Combo( hash_str( "Selected Bone" ), &g_vars->weapon_config.ars.target_bone, body_parts, IM_ARRAYSIZE( body_parts ) );
			}

			if ( g_vars->weapon_config.selected_weapon == 1 )
			{
				ImGui::ColoredCheckbox( hash_str( "Enable" ), g_vars->weapon_config.shotgun.enabled, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				ImGui::Spacing( );

				ImGui::ColoredSliderFloat( hash_str( "Shotgun Smoothing" ), &g_vars->weapon_config.shotgun.smooth, 0, 10, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::ColoredSliderFloat( hash_str( "FOV Radius" ), &g_vars->weapon_config.shotgun.weapon_fov, 0, 500, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::Combo( hash_str( "Selected Bone" ), &g_vars->weapon_config.shotgun.target_bone, body_parts, IM_ARRAYSIZE( body_parts ) );
			}

			if ( g_vars->weapon_config.selected_weapon == 2 )
			{
				ImGui::ColoredCheckbox( hash_str( "Enable" ), g_vars->weapon_config.smg.enabled, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				ImGui::Spacing( );

				ImGui::ColoredSliderFloat( hash_str( "SMG Smoothing" ), &g_vars->weapon_config.smg.smooth, 0, 10, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::ColoredSliderFloat( hash_str( "FOV Radius" ), &g_vars->weapon_config.smg.weapon_fov, 0, 500, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::Combo( hash_str( "Selected Bone" ), &g_vars->weapon_config.smg.target_bone, body_parts, IM_ARRAYSIZE( body_parts ) );
			}

			if ( g_vars->weapon_config.selected_weapon == 3 )
			{
				ImGui::ColoredCheckbox( hash_str( "Enable" ), g_vars->weapon_config.pistol.enabled, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				ImGui::Spacing( );

				ImGui::ColoredSliderFloat( hash_str( "Pistol Smoothing" ), &g_vars->weapon_config.pistol.smooth, 0, 10, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::ColoredSliderFloat( hash_str( "FOV Radius" ), &g_vars->weapon_config.pistol.weapon_fov, 0, 500, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::Combo( hash_str( "Selected Bone" ), &g_vars->weapon_config.pistol.target_bone, body_parts, IM_ARRAYSIZE( body_parts ) );
			}

			if ( g_vars->weapon_config.selected_weapon == 4 )
			{
				ImGui::ColoredCheckbox( hash_str( "Enable" ), g_vars->weapon_config.snipers.enabled, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				ImGui::Spacing( );

				ImGui::ColoredSliderFloat( hash_str( "Sniper Smoothing" ), &g_vars->weapon_config.snipers.smooth, 0, 10, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::ColoredSliderFloat( hash_str( "FOV Radius" ), &g_vars->weapon_config.snipers.weapon_fov, 0, 500, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::Combo( hash_str( "Selected Bone" ), &g_vars->weapon_config.snipers.target_bone, body_parts, IM_ARRAYSIZE( body_parts ) );
			}

			if ( g_vars->weapon_config.selected_weapon == 5 )
			{
				ImGui::ColoredCheckbox( hash_str( "Enable" ), g_vars->weapon_config.close_aim.enabled, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				ImGui::Spacing( );

				ImGui::ColoredSliderInt( hash_str( "Close Aim Distance" ), &g_vars->weapon_config.close_aim.distance, 0, 25, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::ColoredSliderFloat( hash_str( "Close Smoothing" ), &g_vars->weapon_config.close_aim.smooth, 0, 10, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::ColoredSliderFloat( hash_str( "FOV Radius" ), &g_vars->weapon_config.close_aim.weapon_fov, 0, 500, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::Combo( hash_str( "Selected Bone" ), &g_vars->weapon_config.close_aim.target_bone, body_parts, IM_ARRAYSIZE( body_parts ) );
			}

			ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x, ImGui::GetWindowPos( ).y + ImGui::GetWindowHeight( ) + 3.0f ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "TRIGGERBOT" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_AlwaysAutoResize );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Triggerbot" ) );

			ImGui::ColoredCheckbox( hash_str( "Triggerbot" ), g_vars->trigger.triggerbot, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Triggerbot Configuration" ) );

			ImGui::Hotkey( hash_str( "Triggerbot Key" ), &g_vars->trigger.trigger_keycode );
			ImGui::ColoredSliderInt( hash_str( "Triggerbot Distance" ), &g_vars->trigger.trigger_distance, 30, 400, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Triggerbot Delay Configuration" ) );
			ImGui::ColoredSliderInt( hash_str( "Delay (ms)" ), &g_vars->trigger.trigger_delay, 1, 250, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Triggerbot Weapon Configuration" ) );

			ImGui::ColoredCheckbox( hash_str( "Triggerbot Shotguns Only" ), g_vars->trigger.shotgun_only, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::End( );

			break;
		}

		case 4:
		{
			ImGui::SetNextWindowPos( ImVec2( window_pos.x + window_size.x + 3.0f, window_pos.y ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "WORLD" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "World Visuals" ) );

			ImGui::ColoredCheckbox( hash_str( "Enable World Visuals" ), g_vars->loot.enable, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "World Visuals Options" ) );

			static int subtab = 0;

			if ( ImGui::Subtab( hash_str( "Searchables" ), subtab == 0, { ImGui::GetWindowWidth( ) - ImGui::GetStyle( ).WindowPadding.x - ImGui::GetStyle( ).ItemSpacing.x, ImGui::GetFrameHeight( ) } ) ) {
				subtab = 0;
			}

			if ( ImGui::Subtab( hash_str( "Vehicles" ), subtab == 1, { ImGui::GetWindowWidth( ) - ImGui::GetStyle( ).WindowPadding.x - ImGui::GetStyle( ).ItemSpacing.x, ImGui::GetFrameHeight( ) } ) ) {
				subtab = 1;
			}

			if ( ImGui::Subtab( hash_str( "Dropped" ), subtab == 2, { ImGui::GetWindowWidth( ) - ImGui::GetStyle( ).WindowPadding.x - ImGui::GetStyle( ).ItemSpacing.x, ImGui::GetFrameHeight( ) } ) ) {
				subtab = 2;
			}

			if ( ImGui::Subtab( hash_str( "Terrain" ), subtab == 3, { ImGui::GetWindowWidth( ) - ImGui::GetStyle( ).WindowPadding.x - ImGui::GetStyle( ).ItemSpacing.x, ImGui::GetFrameHeight( ) } ) ) {
				subtab = 3;
			}

			switch ( subtab )
			{
			case 0:
			{
				ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
				ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
				ImGui::Begin( hash_str( "SEARCHABLES" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Searchables" ) );

				ImGui::ColoredCheckbox( hash_str( "Show Searchables" ), g_vars->loot.show_searchables, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Searchables Configuration" ) );

				ImGui::ColoredCheckbox( hash_str( "Show Searchables Distance" ), g_vars->loot.s.show_searchables_distance, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Searchables Render Configuration" ) );

				ImGui::ColoredSliderInt( hash_str( "Searchables Render Distance" ), &g_vars->loot.s.searchables_render_distance, 50, 500, 0, IM_COL32( 255, 255, 255, 255 ) );

				ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
				ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
				ImGui::Begin( hash_str( "OPTIONS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

				ImGui::ColoredCheckbox( hash_str( "Chests" ), g_vars->loot.s.chests, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.s.chest_color );
				ImGui::ColoredCheckbox( hash_str( "Ammo Box" ), g_vars->loot.s.ammo_boxes, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.s.ammo_box_color );
				ImGui::ColoredCheckbox( hash_str( "Lamma's" ), g_vars->loot.s.lammas, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.s.lammas_color );
				ImGui::ColoredCheckbox( hash_str( "Airdrop's" ), g_vars->loot.s.airdrops, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.s.airdrop_color );

				break;
			}

			case 1:
			{
				ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
				ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
				ImGui::Begin( hash_str( "VEHICLES" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Vehicles" ) );

				ImGui::ColoredCheckbox( hash_str( "Show Vehicles" ), g_vars->loot.show_vehicles, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Vehicles Configuration" ) );

				ImGui::ColoredCheckbox( hash_str( "Show Vehicles Distance" ), g_vars->loot.v.show_vehicles_distance, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Vehicles Render Configuration" ) );

				ImGui::ColoredSliderInt( hash_str( "Vehicles Render Distance" ), &g_vars->loot.v.vehicles_render_distance, 50, 500, 0, IM_COL32( 255, 255, 255, 255 ) );

				ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
				ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
				ImGui::Begin( hash_str( "OPTIONS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );
				
				ImGui::ColoredCheckbox( hash_str( "Bikes" ), g_vars->loot.v.bikes, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.v.bikes_color );
				ImGui::ColoredCheckbox( hash_str( "Sedans" ), g_vars->loot.v.sedans, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.v.sedans_color );

				break;
			}

			case 2:
			{
				ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
				ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
				ImGui::Begin( hash_str( "DROPPED" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Dropped" ) );

				ImGui::ColoredCheckbox( hash_str( "Show Dropped" ), g_vars->loot.show_dropped, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Dropped Configuration" ) );

				ImGui::ColoredCheckbox( hash_str( "Show Dropped Distance" ), g_vars->loot.d.show_dropped_distance, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				ImGui::ColoredCheckbox( hash_str( "Show Dropped Rarity Color" ), g_vars->loot.d.show_dropped_rarity_color, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				ImGui::ColoredCheckbox( hash_str( "Show Dropped Rarity Name" ), g_vars->loot.d.show_dropped_rarity_name, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Dropped Render Configuration" ) );

				ImGui::ColoredSliderInt( hash_str( "Dropped Render Distance" ), &g_vars->loot.d.dropped_render_distance, 50, 500, 0, IM_COL32( 255, 255, 255, 255 ) );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Dropped Filter's" ) );

				ImGui::ColoredCheckbox( hash_str( "Sort By Rarity" ), g_vars->loot.d.sort_dropped_rarity, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				rarities [ 0 ].selected = g_vars->loot.d.legendary;
				rarities [ 1 ].selected = g_vars->loot.d.epic;
				rarities [ 2 ].selected = g_vars->loot.d.rare;
				rarities [ 3 ].selected = g_vars->loot.d.common;
				rarities [ 4 ].selected = g_vars->loot.d.uncommon;

				ImGui::MultiSelect( hash_str( "Rarities" ), rarities );

				g_vars->loot.d.legendary = rarities [ 0 ].selected;
				g_vars->loot.d.epic = rarities [ 1 ].selected;
				g_vars->loot.d.rare = rarities [ 2 ].selected;
				g_vars->loot.d.common = rarities [ 3 ].selected;
				g_vars->loot.d.uncommon = rarities [ 4 ].selected;

				ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
				ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
				ImGui::Begin( hash_str( "OPTIONS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );
				
				ImGui::Spacing( );
				ImGui::Text( hash_str( "Materials" ) );

				ImGui::ColoredCheckbox( hash_str( "Wood" ), g_vars->loot.d.wood, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.wood_color );
				ImGui::ColoredCheckbox( hash_str( "Stone" ), g_vars->loot.d.stone, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.stone_color );
				ImGui::ColoredCheckbox( hash_str( "Metal" ), g_vars->loot.d.metal, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.metal_color );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Ammunition" ) );

				ImGui::ColoredCheckbox( hash_str( "Pistol Ammo" ), g_vars->loot.d.pistol_ammo, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.pistol_ammo_color );
				ImGui::ColoredCheckbox( hash_str( "Shotgun Ammo" ), g_vars->loot.d.shotgun_ammo, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.shotgun_ammo_color );
				ImGui::ColoredCheckbox( hash_str( "Rifle Ammo" ), g_vars->loot.d.rifle_ammo, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.rifle_ammo_color );
				ImGui::ColoredCheckbox( hash_str( "Sniper Ammo" ), g_vars->loot.d.sniper_ammo, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.sniper_ammo_color );
				ImGui::ColoredCheckbox( hash_str( "Grenade Ammo" ), g_vars->loot.d.grenade_ammo, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.grenade_ammo_color );


				ImGui::Spacing( );
				ImGui::Text( hash_str( "Heals" ) );

				ImGui::ColoredCheckbox( hash_str( "Mini Shield" ), g_vars->loot.d.minis, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.minis_color );
				ImGui::ColoredCheckbox( hash_str( "Big Pot" ), g_vars->loot.d.bigpot, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.bigpot_color );
				ImGui::ColoredCheckbox( hash_str( "Chug Jug" ), g_vars->loot.d.chugjug, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.chugjug_color );
				ImGui::ColoredCheckbox( hash_str( "Chug Splash" ), g_vars->loot.d.chugsplash, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.chugspalsh_color );
				ImGui::ColoredCheckbox( hash_str( "Slurp Juice" ), g_vars->loot.d.slurp, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.slurp_color );
				ImGui::ColoredCheckbox( hash_str( "Bandages" ), g_vars->loot.d.bandages, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.bandages_color );
				ImGui::ColoredCheckbox( hash_str( "Medkits" ), g_vars->loot.d.medkit, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.medkit_color );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Weapons" ) );

				ImGui::ColoredCheckbox( hash_str( "Assault Rifles" ), g_vars->loot.d.ars, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.ars_color );
				ImGui::ColoredCheckbox( hash_str( "Shotguns" ), g_vars->loot.d.shotguns, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.shotguns_color );
				ImGui::ColoredCheckbox( hash_str( "Submachines" ), g_vars->loot.d.smgs, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.smgs_color );
				ImGui::ColoredCheckbox( hash_str( "Pistols" ), g_vars->loot.d.pistols, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.pistols_color );
				ImGui::ColoredCheckbox( hash_str( "Snipers" ), g_vars->loot.d.snipers, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.d.snipers_color );

				break;
			}

			case 3:
			{
				ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
				ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
				ImGui::Begin( hash_str( "Terrain" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Terrain" ) );

				ImGui::ColoredCheckbox( hash_str( "Show Terrain" ), g_vars->loot.show_world, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Terrain Configuration" ) );

				ImGui::ColoredCheckbox( hash_str( "Show Terrain Distance" ), g_vars->loot.w.show_world_distance, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Terrain Render Configuration" ) );

				ImGui::ColoredSliderInt( hash_str( "Terrain Render Distance" ), &g_vars->loot.w.world_render_distance, 50, 500, 0, IM_COL32( 255, 255, 255, 255 ) );

				ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
				ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
				ImGui::Begin( hash_str( "OPTIONS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

				ImGui::ColoredCheckbox( hash_str( "Weakspots" ), g_vars->loot.w.weakspots, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->world_colors.w.weakspot_color );
				
				break;
			}

			}

			ImGui::End( );

			break;
		}

		case 5:
		{
			ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "VEHICLE EXPLOITS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_AlwaysAutoResize );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Vehicle Speedhack" ) );

			ImGui::ColoredCheckbox( hash_str( "Vehicle Speedhack" ), g_vars->exploits.vehicle_speedhack, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::ColoredSliderInt( hash_str( "Speed" ), &g_vars->exploits.vehicle_speed, 0, 1000, 0, IM_COL32( 255, 255, 255, 255 ) );
			
			ImGui::Spacing( );
			ImGui::Text( hash_str( "Vehicle Fly" ) );

			ImGui::ColoredCheckbox( hash_str( "Vehicle Fly" ), g_vars->exploits.car_fly, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::Hotkey( hash_str( "Fly Up Key" ), &g_vars->exploits.key_up );
			ImGui::Hotkey( hash_str( "Fly Down Key" ), &g_vars->exploits.key_down );	

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Vehicle Airstuck" ) );

			ImGui::ColoredCheckbox( hash_str( "Vehicle Airstuck" ), g_vars->exploits.vehicle_airstuck, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::Hotkey( hash_str( "Airstuck Key" ), &g_vars->exploits.key_vehicle_airstuck );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Vehicle Gravity" ) );

			ImGui::ColoredCheckbox( hash_str( "Vehicle Gravity" ), g_vars->exploits.disable_car_gravity, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Vehicle Options" ) );

			ImGui::ColoredCheckbox( hash_str( "Infinite Fuel" ), g_vars->exploits.infinite_fuel, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::ColoredCheckbox( hash_str( "Instant Brakes" ), g_vars->exploits.instant_brakes, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::ColoredCheckbox( hash_str( "Instant Vehicle Animations" ), g_vars->exploits.remove_car_animations, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Motorcycle Configuration" ) );

			ImGui::ColoredCheckbox( hash_str( "Motorcycle Jump" ), g_vars->exploits.bike_jump, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::ColoredSliderFloat( hash_str( "Max Jump Force" ), &g_vars->exploits.max_jump_force, 0, 10000, 0, IM_COL32( 255, 255, 255, 255 ) );
			ImGui::ColoredSliderFloat( hash_str( "Max Jump Forward" ), &g_vars->exploits.max_jump_forward, 0, 5000, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x, ImGui::GetWindowPos( ).y + ImGui::GetWindowHeight( ) + 3.0f ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "VEHICLE TELEPORT" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_AlwaysAutoResize );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Vehicle Teleport" ) );

			ImGui::ColoredCheckbox( hash_str( "Teleport To Player" ), g_vars->exploits.vehicle_teleport, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), TRUE );

			ImGui::Combo( hash_str( "Teleport Type" ), &g_vars->exploits.vehicle_tp_type, tp_modes, IM_ARRAYSIZE( tp_modes ) );
			ImGui::Hotkey( hash_str( "Teleport Key" ), &g_vars->exploits.vehicle_tp_key );

			ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "CAMERA" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_AlwaysAutoResize );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Viewmodel Options" ) );

			ImGui::ColoredCheckbox( hash_str( "Camera FOV Changer" ), g_vars->exploits.fov_changer, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Field Of View Options" ) );

			ImGui::ColoredSliderFloat( hash_str( "Normal FOV" ), &g_vars->exploits.camera_fov, 30.f, 200.f, 0, IM_COL32( 255, 255, 255, 255 ) );
			ImGui::ColoredSliderFloat( hash_str( "ADS FOV" ), &g_vars->exploits.ads_fov, 30.f, 200.f, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Zoom" ) );

			ImGui::ColoredCheckbox( hash_str( "Zoom" ), g_vars->exploits.zoom, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Zoom Configuration" ) );

			ImGui::ColoredSliderInt( hash_str( "Zoom Radius" ), &g_vars->exploits.zoom_value, 10, 130, 0, IM_COL32( 255, 255, 255, 255 ) );
			ImGui::Hotkey( hash_str( "Zoom Key" ), &g_vars->exploits.zoom_keycode );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Smooth Zoom Configuration" ) );

			ImGui::ColoredCheckbox( hash_str( "Smooth Zoom" ), g_vars->exploits.camera_zoom_effect, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::ColoredSliderFloat( hash_str( "Zoom Speed" ), &g_vars->exploits.zoom_speed, 0.1f, 0.3f, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x, ImGui::GetWindowPos( ).y + ImGui::GetWindowHeight( ) + 3.0f ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "WORLD EXPLOITS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_AlwaysAutoResize );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "World Options" ) );

			ImGui::ColoredCheckbox( hash_str( "Sky Changer" ), g_vars->exploits.dark_sky, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x, ImGui::GetWindowPos( ).y + ImGui::GetWindowHeight( ) + 3.0f ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "WEAPON EXPLOITS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_AlwaysAutoResize );
			
			ImGui::Spacing( );
			ImGui::Text( hash_str( "Weapon Options" ) );

			ImGui::ColoredCheckbox( hash_str( "Bullet Teleport" ), g_vars->exploits.sniper_bullet_tp, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), TRUE );
		
			ImGui::Spacing( );
			ImGui::Text( hash_str( "Tracers" ) );

			ImGui::ColoredCheckbox( hash_str( "Bullet Tracers" ), g_vars->misc.bullet_tracers, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.bullet_tracers_color );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Tracers Configuration" ) );

			ImGui::Combo( hash_str( "Bullet Color Mode" ), &g_vars->misc.bullet_tracers_mode, color_modes, IM_ARRAYSIZE( color_modes ) );
			ImGui::Combo( hash_str( "Tracers Line Mode" ), &g_vars->misc.bullet_tracers_line_mode, line_modes, IM_ARRAYSIZE( line_modes ) );
			ImGui::ColoredSliderInt( hash_str( "Tracers Lifetime" ), &g_vars->misc.bullet_tracers_lifetime, 0, 8, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Tracers Visual Configuration" ) );

			ImGui::ColoredSliderFloat( hash_str( "Tracers Thickness" ), &g_vars->misc.bullet_tracers_thickness, 0.1f, 2.00f, 0, IM_COL32( 255, 255, 255, 255 ) );
			ImGui::ColoredCheckbox( hash_str( "Bullet Tracers Outline" ), g_vars->misc.bullet_tracers_outline, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Tracers Fade Configuration" ) );

			ImGui::ColoredCheckbox( hash_str( "Bullet Tracers Fade" ), g_vars->misc.bullet_tracers_fade_effect, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::ColoredSliderFloat( hash_str( "Fade Speed" ), &g_vars->misc.bullet_tracers_fade_speed, 0.1f, 7.00f, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::End( );

			break;
		}

		case 6:
		{
			ImGui::SetNextWindowPos( ImVec2( window_pos.x + window_size.x + 3.0f, window_pos.y ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "SETTINGS" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Key Configuration" ) );

			ImGui::Hotkey( hash_str( "Menu Key" ), &g_vars->misc.menu_key );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "UI Configuration" ) );

			ImGui::ColoredCheckbox( hash_str( "Framerate" ), g_vars->misc.fps, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Keybinds Configuration" ) );

			ImGui::ColoredCheckbox( hash_str( "Show Keybinds" ), g_vars->misc.show_keybinds, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
			ImGui::Combo( hash_str( "Keybinds Style" ), &g_vars->misc.keybinds, keybind_parts, IM_ARRAYSIZE( keybind_parts ) );


			ImGui::Spacing( );
			ImGui::Text( hash_str( "Config's" ) );

			static int config = 0;

			ImGui::Combo( hash_str( "Selected Config" ), &config, config_modes, IM_ARRAYSIZE( config_modes ) );

			if ( ImGui::Button( hash_str( "Save Config" ), { ImGui::GetWindowWidth( ) - ImGui::GetStyle( ).WindowPadding.x * 2, ImGui::GetFrameHeight( ) } ) )
			{
				if ( g_config->save( config ) ) {
					g_debug_callback->add_callback( I_INFO3916699, ImColor( 77, 77, 177 ), hash_str( "Config has been successfuly saved." ), hash_str( "Info" ), 6.f );
				}
				else {
					g_debug_callback->add_callback( I_INFO3916699, ImColor( 177, 77, 77 ), hash_str( "Failed to save selected config!" ), hash_str( "Error" ), 6.f );
				}
			}

			if ( ImGui::Button( hash_str( "Load Config" ), { ImGui::GetWindowWidth( ) - ImGui::GetStyle( ).WindowPadding.x * 2, ImGui::GetFrameHeight( ) } ) )
			{
				if ( g_config->load( config ) ) {
					g_debug_callback->add_callback( I_INFO3916699, ImColor( 77, 77, 177 ), hash_str( "Config has been successfuly loaded." ), hash_str( "Info" ), 6.f );
				}
				else {
					g_debug_callback->add_callback( I_INFO3916699, ImColor( 177, 77, 77 ), hash_str( "Failed to load selected config!" ), hash_str( "Error" ), 6.f );
				}
			}

			if ( ImGui::Button( hash_str( "Exit" ), { ImGui::GetWindowWidth() - ImGui::GetStyle().WindowPadding.x * 2, ImGui::GetFrameHeight() } ) )
			{
				COLORREF color = RGB( 0, 0, 0 );

				HDC hdc = GetDC( g_render->overlay );
				if ( hdc ) {
					RECT rect;
					GetClientRect( g_render->overlay, &rect );
					HBRUSH hBrush = CreateSolidBrush( color );
					FillRect( hdc, &rect, hBrush );
					DeleteObject( hBrush );
					ReleaseDC( g_render->overlay, hdc );
				}

				exit( 0 );
			}

			ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x + ImGui::GetWindowWidth( ) + 3.0f, window_pos.y ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "CROSSHAIR" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_UnsavedDocument | ImGuiWindowFlags_AlwaysAutoResize );

			ImGui::ColoredCheckbox( hash_str( "Crosshair" ), g_vars->misc.crosshair, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ), false, g_vars->colors.crosshair_color );
			if ( g_vars->misc.crosshair ) {

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Crosshair Selection" ) );

				ImGui::Combo( hash_str( "Style" ), &g_vars->misc.selected_crosshair, crosshair_parts, IM_ARRAYSIZE( crosshair_parts ) );

				ImGui::Spacing( );
				ImGui::Text( hash_str( "Crosshair Configuration" ) );

				if ( g_vars->misc.selected_crosshair == 1 ) {
					ImGui::ColoredCheckbox( hash_str( "Filled Circle" ), g_vars->crosshair.circle_filled, ImVec2( -FLT_MIN, 0.0f ), IM_COL32( 255, 255, 255, 255 ), ImGui::GetColorU32( ImGuiCol_HeaderActive ), IM_COL32( 174, 25, 1, 255 ) );
				}

				ImGui::ColoredSliderFloat( hash_str( "Length" ), &g_vars->crosshair.length, 0, 10, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::ColoredSliderFloat( hash_str( "Thickness" ), &g_vars->crosshair.thickness, 0, 6, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::ColoredSliderFloat( hash_str( "Gap" ), &g_vars->crosshair.gap, -6, 6, 0, IM_COL32( 255, 255, 255, 255 ) );
				ImGui::ColoredSliderFloat( hash_str( "Outline" ), &g_vars->crosshair.outline, 0, 6, 0, IM_COL32( 255, 255, 255, 255 ) );
			}

			ImGui::SetNextWindowPos( ImVec2( ImGui::GetWindowPos( ).x, ImGui::GetWindowPos( ).y + ImGui::GetWindowHeight( ) + 3.0f ) );
			ImGui::SetNextWindowSize( ImVec2( 250, 0.0f ) );
			ImGui::Begin( hash_str( "CONFIGURATION" ), nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_AlwaysAutoResize );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Indicators Configuration" ) );

			ImGui::ColoredSliderFloat( hash_str( "Dotted Lines Gap" ), &g_vars->ui.dotted_gap, 0.1f, 10.00f, 0, IM_COL32( 255, 255, 255, 255 ) );
			ImGui::ColoredSliderFloat( hash_str( "Dashed Lines Gap" ), &g_vars->ui.dashed_gap, 0.1f, 10.00f, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::Spacing( );
			ImGui::Text( hash_str( "Visuals Configuration" ) );

			ImGui::ColoredSliderFloat( hash_str( "RGB Speed" ), &g_vars->ui.rgb_speed, 0.1f, 3.f, 0, IM_COL32( 255, 255, 255, 255 ) );

			ImGui::End( );

			break;
		}
		}
	}

	ImGui::End( );
}

#endif // ! guard