#ifndef EFFECTS_HPP
#define EFFECTS_HPP

namespace effects
{
    class Effect
    {
    private:

        struct Snowflake
        {
            ImVec2 pos;
            float speed;
            float size;
            float alpha;
            float rotation;
            float rotation_speed;
        };

        std::vector<Snowflake> snowflakes;

        const int MAX_SNOWFLAKES = 50;
        const float MIN_SPEED = 20.0f;
        const float MAX_SPEED = 50.0f;
        const float MIN_SIZE = 8.0f;   
        const float MAX_SIZE = 16.0f;   

    public:

        Effect( ) 
        {
            for ( int i = 0; i < MAX_SNOWFLAKES; i++ ) {
                AddSnowflake( true );
            }
        }

        void DrawSnowflake( ImDrawList* drawList, const ImVec2& center, float size, float rotation, float alpha );
        void AddSnowflake( bool randomY = false );
        void UpdateSnow( float deltaTime );
        void RenderSnow( );

    public:

        void render_snow_effect( ) 
        {
            static Effect snowEffect;
            static float lastTime = ImGui::GetTime( );

            float currentTime = ImGui::GetTime( );
            float deltaTime = currentTime - lastTime;
            lastTime = currentTime;

            snowEffect.UpdateSnow( deltaTime );
            snowEffect.RenderSnow( );
        }
    };

} inline auto g_effects = std::make_unique<effects::Effect>( );


#endif // !NOTIFICATIONS_HPP