#pragma once
#include <commdlg.h>
namespace config
{
	class u_controls
	{
	public:

		bool boolean( const std::string& key, bool& value, bool is_write, std::string cfg_path );
		bool string( const std::string& key, std::string& value, bool is_write, std::string cfg_path );
		bool color( const std::string& key, float* color, bool is_write, std::string cfg_path );
		bool integer( const std::string& key, int& value, bool is_write, std::string cfg_path );
		bool floating( const std::string& key, float& value, bool is_write, std::string cfg_path );
	};

	class u_configuration : public u_controls
	{
	private:

		std::string parent_path = hash_str( "C:\\Fortnite" );

		std::string legit = hash_str( "C:\\Fortnite\\legit.cfg" );
		std::string semi_legit = hash_str( "C:\\Fortnite\\semi_legit.cfg" );
		std::string rage = hash_str( "C:\\Fortnite\\rage.cfg" );

	public:

		[[nodiscard]] std::string get_config( const unsigned int& cfg );

		bool load( const unsigned int& cfg );
		bool save( const unsigned int& cfg );

	public:

		std::wstring open_file( const std::wstring& extension, const std::wstring& description, const std::wstring& pattern ) 
		{
			wchar_t filename[ MAX_PATH ] = L"";

			OPENFILENAMEW ofn;
			ZeroMemory( &ofn, sizeof( ofn ) );
			ofn.lStructSize = sizeof( ofn );
			ofn.hwndOwner = nullptr;

			std::wstring filter = description + L'\0' + pattern + L'\0';

			ofn.lpstrFilter = filter.c_str( );
			ofn.lpstrFile = filename;
			ofn.nMaxFile = MAX_PATH;
			ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
			ofn.lpstrDefExt = extension.c_str( );

			if ( GetOpenFileNameW( &ofn ) )
			{
				SetWindowPos( GetParent( ofn.hwndOwner ), HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE );
				return filename;
			}
			return L"";
		}

		std::wstring save_file( const std::wstring& extension, const std::wstring& description, const std::wstring& pattern ) 
		{
			wchar_t filename[ MAX_PATH ] = L"";

			OPENFILENAMEW ofn;
			ZeroMemory( &ofn, sizeof( ofn ) );
			ofn.lStructSize = sizeof( ofn );
			ofn.hwndOwner = nullptr;

			std::wstring filter = description + L'\0' + pattern + L'\0';

			ofn.lpstrFilter = filter.c_str( );
			ofn.lpstrFile = filename;
			ofn.nMaxFile = MAX_PATH;
			ofn.Flags = OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT;
			ofn.lpstrDefExt = extension.c_str( );

			if ( GetSaveFileNameW( &ofn ) )
			{
				SetWindowPos( GetParent( ofn.hwndOwner ), HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE );
				return filename;
			}
			return L"";
		}
	};
}
inline auto g_config = std::make_unique<config::u_configuration>( );