#pragma once
#include <core/inc.hpp>

auto config::u_controls::boolean( const std::string& key,
	bool& value,
	bool is_write,
	std::string cfg_path
) -> bool
{
	try {

		if ( is_write ) {

			std::string value_str = value ? hash_str( "1" ) : hash_str( "0" );

			if ( !WritePrivateProfileStringA( hash_str( "options" ), key.c_str( ), value_str.c_str( ), cfg_path.c_str( ) ) ) {
				return false;
			}
		}
		else {

			if ( !std::filesystem::exists( cfg_path ) ) {
				return false;
			}

			constexpr size_t buffer_size = 100;
			char buf[ buffer_size ];

			if ( !GetPrivateProfileStringA( hash_str( "options" ), key.c_str( ), hash_str( "NULL" ), buf, buffer_size, cfg_path.c_str( ) ) ) {
				return false;
			}

			std::string result( buf );
			if ( result != hash_str( "1" ) && result != hash_str( "0" ) ) {
				return false;
			}

			value = ( result == hash_str( "1" ) );
		}

		return true;
	}
	catch ( const std::exception& e ) {
		return false;
	}
}

auto config::u_controls::string( const std::string& key,
	std::string& value,
	bool is_write,
	std::string cfg_path
) -> bool
{
	try {

		if ( is_write ) {

			if ( !WritePrivateProfileStringA( hash_str( "options" ), key.c_str( ), value.c_str( ), cfg_path.c_str( ) ) ) {
				return false;
			}
		}
		else {

			if ( !std::filesystem::exists( cfg_path ) ) {
				return false;
			}

			constexpr size_t buffer_size = 100;
			char buf[ buffer_size ];

			if ( !GetPrivateProfileStringA( hash_str( "options" ), key.c_str( ), hash_str( "NULL" ), buf, buffer_size, cfg_path.c_str( ) ) ) {
				return false;
			}

			std::string result( buf );

			value = ( result );
		}

		return true;
	}
	catch ( const std::exception& e ) {
		return false;
	}
}

auto config::u_controls::floating( const std::string& key,
	float& value,
	bool is_write,
	std::string cfg_path
) -> bool
{
	try {
		if ( is_write ) {

			std::string value_string = std::to_string( value );

			if ( !WritePrivateProfileStringA( hash_str( "options" ), key.c_str( ), value_string.c_str( ), cfg_path.c_str( ) ) ) {
				return false;
			}

		}
		else {

			if ( !std::filesystem::exists( cfg_path ) ) {
				return false;
			}

			constexpr size_t buffer_size = 100;
			char buf[ buffer_size ];

			if ( !GetPrivateProfileStringA( hash_str( "options" ), key.c_str( ), hash_str( "NULL" ), buf, buffer_size, cfg_path.c_str( ) ) ) {
				return false;
			}

			std::string result( buf );
			try {
				value = std::stof( result );
			}
			catch ( const std::invalid_argument& e ) {
				return false;
			}
			catch ( const std::out_of_range& e ) {
				return false;
			}
		}

		return true;
	}
	catch ( const std::exception& e ) {
		return false;
	}
}

auto config::u_controls::integer( const std::string& key,
	int& value,
	bool is_write,
	std::string cfg_path
) -> bool
{
	try {

		if ( is_write ) {

			std::string value_string = std::to_string( value );

			if ( !WritePrivateProfileStringA( hash_str( "options" ), key.c_str( ), value_string.c_str( ), cfg_path.c_str( ) ) ) {
				return false;
			}

		}
		else {

			if ( !std::filesystem::exists( cfg_path ) ) {
				return false;
			}

			constexpr size_t buffer_size = 100;
			char buf[ buffer_size ];

			if ( !GetPrivateProfileStringA( hash_str( "options" ), key.c_str( ), hash_str( "NULL" ), buf, buffer_size, cfg_path.c_str( ) ) ) {
				return false;
			}

			if ( std::string( buf ) == hash_str( "NULL" ) ) {
				return false;
			}

			try {
				value = std::stoi( buf );
			}
			catch ( const std::invalid_argument& e ) {
				return false;
			}
			catch ( const std::out_of_range& e ) {
				return false;
			}
		}

		return true;
	}
	catch ( const std::exception& e ) {
		return false;
	}
}


auto config::u_controls::color( const std::string& key,
	float* color,
	bool is_write,
	std::string cfg_path
) -> bool
{
	try {
		if ( is_write ) {

			std::string color_string = std::to_string( color[ 0 ] ) + hash_str( " " )
				+ std::to_string( color[ 1 ] ) + hash_str( " " )
				+ std::to_string( color[ 2 ] ) + hash_str( " " )
				+ std::to_string( color[ 3 ] );

			if ( !WritePrivateProfileStringA( hash_str( "options" ), key.c_str( ), color_string.c_str( ), cfg_path.c_str( ) ) ) {
				return false;
			}

		}
		else {

			if ( !std::filesystem::exists( cfg_path ) ) {
				return false;
			}

			constexpr size_t buffer_size = 100;
			char buf[ buffer_size ];

			if ( !GetPrivateProfileStringA( hash_str( "options" ), key.c_str( ), hash_str( "NULL" ), buf, buffer_size, cfg_path.c_str( ) ) ) {
				return false;
			}

			std::string color_string( buf );
			std::stringstream color_stream( color_string );

			for ( int i = 0; i < 4; ++i ) {
				if ( !( color_stream >> color[ i ] ) ) {
					return false;
				}
			}

		}

		return true;
	}
	catch ( const std::exception& e ) {
		return false;
	}
}

auto config::u_configuration::get_config( const unsigned int& cfg ) -> std::string
{
	std::filesystem::path path = this->parent_path;
	if ( !std::filesystem::exists( path ) ) std::filesystem::create_directories( path );

	switch ( cfg )
	{
	case 0:
		return this->legit;
		break;
	case 1:
		return this->semi_legit;
		break;
	case 2:
		return this->rage;
		break;
	default:
		return this->legit;
		break;
	}
	return this->legit;
}

auto config::u_configuration::save( const unsigned int& cfg ) -> bool
{
	std::string cfg_path = get_config( cfg );

	this->integer( hash_str( "aim.aim_keycode" ), g_vars->aim.aim_keycode, true, cfg_path );
	this->integer( hash_str( "aim.second_aim_keycode" ), g_vars->aim.second_aim_keycode, true, cfg_path );
	this->integer( hash_str( "aim.target_bone" ), g_vars->aim.target_bone, true, cfg_path );
	this->integer( hash_str( "aim.aim_distance" ), g_vars->aim.aim_distance, true, cfg_path );

	this->boolean( hash_str( "aim.enabled" ), g_vars->aim.enabled, true, cfg_path );
	this->boolean( hash_str( "aim.controller" ), g_vars->aim.controller, true, cfg_path );
	this->boolean( hash_str( "aim.prediction" ), g_vars->aim.prediction, true, cfg_path );
	this->boolean( hash_str( "aim.prediction_indicator" ), g_vars->aim.prediction_indicator, true, cfg_path );
	this->boolean( hash_str( "aim.ignore_team" ), g_vars->aim.ignore_team, true, cfg_path );
	this->boolean( hash_str( "aim.ignore_knocked" ), g_vars->aim.ignore_knocked, true, cfg_path );
	this->boolean( hash_str( "aim.ignore_invisible" ), g_vars->aim.ignore_invisible, true, cfg_path );
	this->boolean( hash_str( "aim.aim_when_held" ), g_vars->aim.aim_when_held, true, cfg_path );

	this->floating( hash_str( "aim.fov_c" ), g_vars->aim.fov_c, true, cfg_path );
	this->floating( hash_str( "aim.smooth" ), g_vars->aim.smooth, true, cfg_path );

	this->boolean( hash_str( "weapon_config.enable" ), g_vars->weapon_config.enable, true, cfg_path );
	this->integer( hash_str( "weapon_config.selected_weapon" ), g_vars->weapon_config.selected_weapon, true, cfg_path );

	this->boolean( hash_str( "smg.enabled" ), g_vars->weapon_config.smg.enabled, true, cfg_path );
	this->floating( hash_str( "smg.smooth" ), g_vars->weapon_config.smg.smooth, true, cfg_path );
	this->floating( hash_str( "smg.weapon_fov" ), g_vars->weapon_config.smg.weapon_fov, true, cfg_path );
	this->integer( hash_str( "smg.target_bone" ), g_vars->weapon_config.smg.target_bone, true, cfg_path );

	this->boolean( hash_str( "ars.enabled" ), g_vars->weapon_config.ars.enabled, true, cfg_path );
	this->floating( hash_str( "ars.smooth" ), g_vars->weapon_config.ars.smooth, true, cfg_path );
	this->floating( hash_str( "ars.weapon_fov" ), g_vars->weapon_config.ars.weapon_fov, true, cfg_path );
	this->integer( hash_str( "ars.target_bone" ), g_vars->weapon_config.ars.target_bone, true, cfg_path );

	this->boolean( hash_str( "shotgun.enabled" ), g_vars->weapon_config.shotgun.enabled, true, cfg_path );
	this->floating( hash_str( "shotgun.weapon_fov" ), g_vars->weapon_config.shotgun.weapon_fov, true, cfg_path );
	this->floating( hash_str( "shotgun.smooth" ), g_vars->weapon_config.shotgun.smooth, true, cfg_path );
	this->integer( hash_str( "shotgun.target_bone" ), g_vars->weapon_config.shotgun.target_bone, true, cfg_path );

	this->boolean( hash_str( "pistol.enabled" ), g_vars->weapon_config.pistol.enabled, true, cfg_path );
	this->floating( hash_str( "pistol.weapon_fov" ), g_vars->weapon_config.pistol.weapon_fov, true, cfg_path );
	this->floating( hash_str( "pistol.smooth" ), g_vars->weapon_config.pistol.smooth, true, cfg_path );
	this->integer( hash_str( "pistol.target_bone" ), g_vars->weapon_config.pistol.target_bone, true, cfg_path );

	this->boolean( hash_str( "snipers.enabled" ), g_vars->weapon_config.snipers.enabled, true, cfg_path );
	this->floating( hash_str( "snipers.weapon_fov" ), g_vars->weapon_config.snipers.weapon_fov, true, cfg_path );
	this->floating( hash_str( "snipers.smooth" ), g_vars->weapon_config.snipers.smooth, true, cfg_path );
	this->integer( hash_str( "snipers.target_bone" ), g_vars->weapon_config.snipers.target_bone, true, cfg_path );

	this->boolean( hash_str( "close_aim.enabled" ), g_vars->weapon_config.close_aim.enabled, true, cfg_path );
	this->floating( hash_str( "close_aim.weapon_fov" ), g_vars->weapon_config.close_aim.weapon_fov, true, cfg_path );
	this->floating( hash_str( "close_aim.smooth" ), g_vars->weapon_config.close_aim.smooth, true, cfg_path );
	this->integer( hash_str( "close_aim.target_bone" ), g_vars->weapon_config.close_aim.target_bone, true, cfg_path );
	this->integer( hash_str( "close_aim.distance" ), g_vars->weapon_config.close_aim.distance, true, cfg_path );

	this->floating( hash_str( "visuals.box_width" ), g_vars->visuals.box_width, true, cfg_path );
	this->floating( hash_str( "visuals.boxes_thickness" ), g_vars->visuals.boxes_thickness, true, cfg_path );
	this->floating( hash_str( "visuals.arrow_width" ), g_vars->visuals.arrow_widht, true, cfg_path );
	this->floating( hash_str( "visuals.arrow_radius" ), g_vars->visuals.arrow_radius, true, cfg_path );
	this->floating( hash_str( "visuals.skeleton_thickness" ), g_vars->visuals.skeleton_thickness, true, cfg_path );
	this->floating( hash_str( "visuals.skeleton_joints_radius" ), g_vars->visuals.skeleton_joints_radius, true, cfg_path );

	this->integer( hash_str( "visuals.render_distance" ), g_vars->visuals.render_distance, true, cfg_path );
	this->integer( hash_str( "visuals.boxes_mode" ), g_vars->visuals.boxes_mode, true, cfg_path );
	this->integer( hash_str( "visuals.arrows_mode" ), g_vars->visuals.arrows_mode, true, cfg_path );
	this->integer( hash_str( "visuals.snapline_mode" ), g_vars->visuals.snapline_mode, true, cfg_path );
	this->integer( hash_str( "visuals.snapline_end" ), g_vars->visuals.snapline_end, true, cfg_path );
	this->integer( hash_str( "visuals.snapline_x" ), g_vars->visuals.snapline_x, true, cfg_path );
	this->integer( hash_str( "visuals.snapline_y" ), g_vars->visuals.snapline_y, true, cfg_path );
	this->integer( hash_str( "visuals.skeleton_mode" ), g_vars->visuals.skeleton_mode, true, cfg_path );

	this->boolean( hash_str( "visuals.esp" ), g_vars->visuals.esp, true, cfg_path );
	this->boolean( hash_str( "visuals.boxes" ), g_vars->visuals.boxes, true, cfg_path );
	this->boolean( hash_str( "visuals.corners" ), g_vars->visuals.corners, true, cfg_path );
	this->boolean( hash_str( "visuals.rotating" ), g_vars->visuals.rotating, true, cfg_path );
	this->boolean( hash_str( "visuals.boxes_filled" ), g_vars->visuals.boxes_filled, true, cfg_path );
	this->boolean( hash_str( "visuals.boxes_outline" ), g_vars->visuals.boxes_outline, true, cfg_path );
	this->boolean( hash_str( "visuals.arrows" ), g_vars->visuals.arrows, true, cfg_path );
	this->boolean( hash_str( "visuals.filled_arrows" ), g_vars->visuals.filled_arrows, true, cfg_path );
	this->boolean( hash_str( "visuals.arrows_outline" ), g_vars->visuals.arrows_outline, true, cfg_path );
	this->boolean( hash_str( "visuals.username" ), g_vars->visuals.username, true, cfg_path );
	this->boolean( hash_str( "visuals.distance" ), g_vars->visuals.distance, true, cfg_path );
	this->boolean( hash_str( "visuals.snapline" ), g_vars->visuals.snapline, true, cfg_path );
	this->boolean( hash_str( "visuals.team" ), g_vars->visuals.team, true, cfg_path );
	this->boolean( hash_str( "visuals.show_only_visible_snaplines" ), g_vars->visuals.show_only_visible_snaplines, true, cfg_path );
	this->boolean( hash_str( "visuals.snapline_outline" ), g_vars->visuals.snapline_outline, true, cfg_path );
	this->boolean( hash_str( "visuals.weapon" ), g_vars->visuals.weapon, true, cfg_path );
	this->boolean( hash_str( "visuals.weapon_tier_color" ), g_vars->visuals.weapon_tier_color, true, cfg_path );
	this->boolean( hash_str( "visuals.weapon_tier_name" ), g_vars->visuals.weapon_tier_name, true, cfg_path );
	this->boolean( hash_str( "visuals.weapon_ammo" ), g_vars->visuals.weapon_ammo, true, cfg_path );
	this->boolean( hash_str( "visuals.weapon_icon" ), g_vars->visuals.weapon_icon, true, cfg_path );
	this->boolean( hash_str( "visuals.kill_count" ), g_vars->visuals.kill_count, true, cfg_path );
	this->boolean( hash_str( "visuals.skeleton" ), g_vars->visuals.skeleton, true, cfg_path );
	this->boolean( hash_str( "visuals.skeleton_outline" ), g_vars->visuals.skeleton_outline, true, cfg_path );
	this->floating( hash_str( "visuals.skeleton_outline_thickness" ), g_vars->visuals.skeleton_outline_thickness, true, cfg_path );
	this->boolean( hash_str( "visuals.skeleton_joints" ), g_vars->visuals.skeleton_joints, true, cfg_path );
	this->boolean( hash_str( "visuals.skeleton_joints_outline" ), g_vars->visuals.skeleton_joints_outline, true, cfg_path );
	this->boolean( hash_str( "visuals.rank" ), g_vars->visuals.rank, true, cfg_path );
	this->boolean( hash_str( "visuals.rank_text" ), g_vars->visuals.rank_text, true, cfg_path );
	this->boolean( hash_str( "visuals.rank_icon" ), g_vars->visuals.rank_icon, true, cfg_path );
	this->boolean( hash_str( "visuals.rank_tier_color" ), g_vars->visuals.rank_tier_color, true, cfg_path );
	this->boolean( hash_str( "visuals.platform" ), g_vars->visuals.platform, true, cfg_path );
	this->boolean( hash_str( "visuals.platform_text" ), g_vars->visuals.platform_text, true, cfg_path );
	this->boolean( hash_str( "visuals.platform_icon" ), g_vars->visuals.platform_icon, true, cfg_path );
	this->boolean( hash_str( "visuals.platform_color" ), g_vars->visuals.platform_color, true, cfg_path );
	this->boolean( hash_str( "visuals.movement" ), g_vars->visuals.movement, true, cfg_path );
	this->boolean( hash_str( "visuals.view_direction" ), g_vars->visuals.view_direction, true, cfg_path );
	this->boolean( hash_str( "visuals.radar" ), g_vars->visuals.radar, true, cfg_path );
	this->boolean( hash_str( "visuals.flags" ), g_vars->visuals.flags, true, cfg_path );
	this->boolean( hash_str( "visuals.show_target" ), g_vars->visuals.show_target, true, cfg_path );
	this->boolean( hash_str( "visuals.show_team" ), g_vars->visuals.show_team, true, cfg_path );
	this->boolean( hash_str( "visuals.show_dbno" ), g_vars->visuals.show_dbno, true, cfg_path );
	this->boolean( hash_str( "visuals.visibility_check" ), g_vars->visuals.visibility_check, true, cfg_path );
	this->boolean( hash_str( "visuals.targetline" ), g_vars->visuals.targetline, true, cfg_path );
	this->boolean( hash_str( "visuals.mark_enemies" ), g_vars->visuals.mark_enemies, true, cfg_path );
	this->integer( hash_str( "visuals.mark_enemies_bind" ), g_vars->visuals.mark_enemies_bind, true, cfg_path );
	this->boolean( hash_str( "visuals.mark_friendly" ), g_vars->visuals.mark_friendly, true, cfg_path );
	this->integer( hash_str( "visuals.mark_friendly_bind" ), g_vars->visuals.mark_friendly_bind, true, cfg_path );

	this->boolean( hash_str( "flags.aiming" ), g_vars->flags.aiming, true, cfg_path );
	this->boolean( hash_str( "flags.crouched" ), g_vars->flags.crouched, true, cfg_path );
	this->boolean( hash_str( "flags.idle" ), g_vars->flags.idle, true, cfg_path );
	this->boolean( hash_str( "flags.walking" ), g_vars->flags.walking, true, cfg_path );
	this->boolean( hash_str( "flags.falling" ), g_vars->flags.falling, true, cfg_path );
	this->boolean( hash_str( "flags.swimming" ), g_vars->flags.swimming, true, cfg_path );
	this->boolean( hash_str( "flags.flying" ), g_vars->flags.flying, true, cfg_path );
	this->boolean( hash_str( "flags.wounded" ), g_vars->flags.wounded, true, cfg_path );
	this->boolean( hash_str( "flags.reloading" ), g_vars->flags.reloading, true, cfg_path );

	this->color( hash_str( "colors.crosshair_color" ), g_vars->colors.crosshair_color, true, cfg_path );
	this->color( hash_str( "colors.fov_color" ), g_vars->colors.fov_color, true, cfg_path );
	this->color( hash_str( "colors.text_color" ), g_vars->colors.text_color, true, cfg_path );

	this->color( hash_str( "colors.box_color" ), g_vars->colors.box_color, true, cfg_path );
	this->color( hash_str( "colors.corner_box_color" ), g_vars->colors.corner_box_color, true, cfg_path );
	this->color( hash_str( "colors.rotating_color" ), g_vars->colors.rotating_color, true, cfg_path );
	this->color( hash_str( "colors.fill_box_color" ), g_vars->colors.fill_box_color, true, cfg_path );
	this->color( hash_str( "colors.skeleton_color" ), g_vars->colors.skeleton_color, true, cfg_path );
	this->color( hash_str( "colors.skeleton_joints_color" ), g_vars->colors.skeleton_joints_color, true, cfg_path );
	this->color( hash_str( "colors.arrows_color" ), g_vars->colors.arrows_color, true, cfg_path );
	this->color( hash_str( "colors.arrows_filled_color" ), g_vars->colors.arrows_filled_color, true, cfg_path );

	this->color( hash_str( "colors.teammate_color" ), g_vars->colors.teammate_color, true, cfg_path );
	this->color( hash_str( "colors.knocked_color" ), g_vars->colors.knocked_color, true, cfg_path );

	this->color( hash_str( "colors.player_visible" ), g_vars->colors.player_visible, true, cfg_path );
	this->color( hash_str( "colors.player_invisible" ), g_vars->colors.player_invisible, true, cfg_path );
	this->color( hash_str( "colors.text_visible" ), g_vars->colors.text_visible, true, cfg_path );
	this->color( hash_str( "colors.text_invisible" ), g_vars->colors.text_invisible, true, cfg_path );

	this->color( hash_str( "colors.weapon_color" ), g_vars->colors.weapon_color, true, cfg_path );
	this->color( hash_str( "colors.distance_color" ), g_vars->colors.distance_color, true, cfg_path );
	this->color( hash_str( "colors.username_color" ), g_vars->colors.username_color, true, cfg_path );
	this->color( hash_str( "colors.rank_color" ), g_vars->colors.rank_color, true, cfg_path );
	this->color( hash_str( "colors.team_color" ), g_vars->colors.team_color, true, cfg_path );
	this->color( hash_str( "colors.kill_color" ), g_vars->colors.kill_color, true, cfg_path );
	this->color( hash_str( "colors.snapline_color" ), g_vars->colors.snapline_color, true, cfg_path );
	this->color( hash_str( "colors.view_angle_color" ), g_vars->colors.view_angle_color, true, cfg_path );
	this->color( hash_str( "colors.platform_color" ), g_vars->colors.platform_color, true, cfg_path );
	this->color( hash_str( "colors.targeted_color" ), g_vars->colors.targeted_color, true, cfg_path );
	this->color( hash_str( "colors.targetline_color" ), g_vars->colors.targetline_color, true, cfg_path );
	this->color( hash_str( "colors.prediction_color" ), g_vars->colors.prediction_color, true, cfg_path );
	this->color( hash_str( "colors.enemy_color" ), g_vars->colors.enemy_color, true, cfg_path );
	this->color( hash_str( "colors.friendly_color" ), g_vars->colors.friendly_color, true, cfg_path );
	this->color( hash_str( "colors.movement_tracers_color" ), g_vars->colors.movement_tracers_color, true, cfg_path );

	this->floating( hash_str( "radar.radar_width" ), g_vars->radar.radar_width, true, cfg_path );
	this->floating( hash_str( "radar.radar_height" ), g_vars->radar.radar_height, true, cfg_path );
	this->floating( hash_str( "radar.radar_size" ), g_vars->radar.radar_size, true, cfg_path );
	this->floating( hash_str( "radar.radar_distance" ), g_vars->radar.radar_distance, true, cfg_path );

	this->floating( hash_str( "radar.radar_solid_fill_opacity" ), g_vars->radar.radar_solid_fill_opacity, true, cfg_path );
	this->floating( hash_str( "radar.radar_match_opacity" ), g_vars->radar.radar_match_opacity, true, cfg_path );
	this->floating( hash_str( "radar.radar_match_outline_opacity" ), g_vars->radar.radar_match_outline_opacity, true, cfg_path );
	this->color( hash_str( "radar.radar_match_color" ), g_vars->radar.radar_match_color, true, cfg_path );

	this->floating( hash_str( "radar.radar_match_fade_out" ), g_vars->radar.radar_match_fade_out, true, cfg_path );
	this->floating( hash_str( "radar.radar_match_size" ), g_vars->radar.radar_match_size, true, cfg_path );
	this->color( hash_str( "radar.lines_color" ), g_vars->radar.lines_color, true, cfg_path );

	this->floating( hash_str( "radar.radar_fov_opacity" ), g_vars->radar.radar_fov_opacity, true, cfg_path );
	this->floating( hash_str( "radar.radar_fov_fade_out" ), g_vars->radar.radar_fov_fade_out, true, cfg_path );
	this->floating( hash_str( "radar.radar_fov_match_size" ), g_vars->radar.radar_fov_match_size, true, cfg_path );
	this->color( hash_str( "radar.fov_color" ), g_vars->radar.fov_color, true, cfg_path );

	this->color( hash_str( "radar.radar_dot_color" ), g_vars->radar.radar_dot_color, true, cfg_path );

	this->boolean( hash_str( "radar.radar_lines" ), g_vars->radar.radar_lines, true, cfg_path );
	this->boolean( hash_str( "radar.display_fov" ), g_vars->radar.display_fov, true, cfg_path );
	this->boolean( hash_str( "radar.display_world_entities" ), g_vars->radar.display_world_entities, true, cfg_path );
	this->boolean( hash_str( "radar.display_distance" ), g_vars->radar.display_distance, true, cfg_path );
	this->boolean( hash_str( "radar.outlined_dots" ), g_vars->radar.outlined_dots, true, cfg_path );
	this->boolean( hash_str( "radar.ignore_wounded" ), g_vars->radar.ignore_wounded, true, cfg_path );
	this->boolean( hash_str( "radar.ignore_teammates" ), g_vars->radar.ignore_teammates, true, cfg_path );
	this->boolean( hash_str( "radar.ignore_invisible" ), g_vars->radar.ignore_invisible, true, cfg_path );

	this->floating( hash_str( "crosshair.rotation" ), g_vars->crosshair.rotation, true, cfg_path );
	this->floating( hash_str( "crosshair.length" ), g_vars->crosshair.length, true, cfg_path );
	this->floating( hash_str( "crosshair.thickness" ), g_vars->crosshair.thickness, true, cfg_path );
	this->floating( hash_str( "crosshair.gap" ), g_vars->crosshair.gap, true, cfg_path );
	this->floating( hash_str( "crosshair.outline" ), g_vars->crosshair.outline, true, cfg_path );

	this->boolean( hash_str( "crosshair.circle_filled" ), g_vars->crosshair.circle_filled, true, cfg_path );

	this->boolean( hash_str( "misc.fov" ), g_vars->misc.fov, true, cfg_path );
	this->boolean( hash_str( "misc.fps" ), g_vars->misc.fps, true, cfg_path );
	this->boolean( hash_str( "misc.crosshair" ), g_vars->misc.crosshair, true, cfg_path );

	this->integer( hash_str( "misc.selected_crosshair" ), g_vars->misc.selected_crosshair, true, cfg_path );
	this->boolean( hash_str( "misc.show_keybinds" ), g_vars->misc.show_keybinds, true, cfg_path );
	this->integer( hash_str( "misc.keybinds" ), g_vars->misc.keybinds, true, cfg_path );
	this->integer( hash_str( "misc.eye_tracer_length" ), g_vars->misc.eye_tracer_length, true, cfg_path );
	this->integer( hash_str( "misc.menu_key" ), g_vars->misc.menu_key, true, cfg_path );
	this->integer( hash_str( "misc.maximum_distance" ), g_vars->misc.maximum_distance, true, cfg_path );

	this->boolean( hash_str( "misc.movement_tracers" ), g_vars->misc.movement_tracers, true, cfg_path );
	this->integer( hash_str( "misc.movement_tracers_mode" ), g_vars->misc.movement_tracers_mode, true, cfg_path );
	this->boolean( hash_str( "misc.movement_tracers_outline" ), g_vars->misc.movement_tracers_outline, true, cfg_path );

	this->boolean( hash_str( "trigger.triggerbot" ), g_vars->trigger.triggerbot, true, cfg_path );
	this->integer( hash_str( "trigger.trigger_keycode" ), g_vars->trigger.trigger_keycode, true, cfg_path );
	this->integer( hash_str( "trigger.trigger_distance" ), g_vars->trigger.trigger_distance, true, cfg_path );
	this->boolean( hash_str( "trigger.shotgun_only" ), g_vars->trigger.shotgun_only, true, cfg_path );
	this->boolean( hash_str( "trigger.enable_delay" ), g_vars->trigger.enable_delay, true, cfg_path );
	this->integer( hash_str( "trigger.trigger_delay" ), g_vars->trigger.trigger_delay, true, cfg_path );

	this->boolean( hash_str( "exploits.dark_sky" ), g_vars->exploits.dark_sky, true, cfg_path );
	this->boolean( hash_str( "exploits.infinite_fuel" ), g_vars->exploits.infinite_fuel, true, cfg_path );
	this->boolean( hash_str( "exploits.vehicle_teleport" ), g_vars->exploits.vehicle_teleport, true, cfg_path );
	this->integer( hash_str( "exploits.vehicle_tp_key" ), g_vars->exploits.vehicle_tp_key, true, cfg_path );
	this->integer( hash_str( "exploits.vehicle_tp_type" ), g_vars->exploits.vehicle_tp_type, true, cfg_path );
	this->boolean( hash_str( "exploits.speed_hack" ), g_vars->exploits.speed_hack, true, cfg_path );
	this->floating( hash_str( "exploits.speed_hack_limit" ), g_vars->exploits.speed_hack_limit, true, cfg_path );
	this->integer( hash_str( "exploits.speed_hack_key" ), g_vars->exploits.speed_hack_key, true, cfg_path );
	this->boolean( hash_str( "exploits.bike_jump" ), g_vars->exploits.bike_jump, true, cfg_path );
	this->floating( hash_str( "exploits.max_jump_force" ), g_vars->exploits.max_jump_force, true, cfg_path );
	this->floating( hash_str( "exploits.max_jump_forward" ), g_vars->exploits.max_jump_forward, true, cfg_path );
	this->boolean( hash_str( "exploits.car_fly" ), g_vars->exploits.car_fly, true, cfg_path );
	this->integer( hash_str( "exploits.key_up" ), g_vars->exploits.key_up, true, cfg_path );
	this->integer( hash_str( "exploits.key_down" ), g_vars->exploits.key_down, true, cfg_path );
	this->boolean( hash_str( "exploits.remove_car_animations" ), g_vars->exploits.remove_car_animations, true, cfg_path );
	this->boolean( hash_str( "exploits.disable_car_gravity" ), g_vars->exploits.disable_car_gravity, true, cfg_path );
	this->boolean( hash_str( "exploits.instant_brakes" ), g_vars->exploits.instant_brakes, true, cfg_path );
	this->boolean( hash_str( "exploits.grippy_cars" ), g_vars->exploits.grippy_cars, true, cfg_path );
	this->boolean( hash_str( "exploits.fov_changer" ), g_vars->exploits.fov_changer, true, cfg_path );
	this->floating( hash_str( "exploits.camera_fov" ), g_vars->exploits.camera_fov, true, cfg_path );
	this->floating( hash_str( "exploits.ads_fov" ), g_vars->exploits.ads_fov, true, cfg_path );
	this->boolean( hash_str( "exploits.vehicle_speedhack" ), g_vars->exploits.vehicle_speedhack, true, cfg_path );
	this->integer( hash_str( "exploits.vehicle_speed" ), g_vars->exploits.vehicle_speed, true, cfg_path );
	this->boolean( hash_str( "exploits.vehicle_airstuck" ), g_vars->exploits.vehicle_airstuck, true, cfg_path );
	this->integer( hash_str( "exploits.key_vehicle_airstuck" ), g_vars->exploits.key_vehicle_airstuck, true, cfg_path );
	this->boolean( hash_str( "exploits.sniper_bullet_tp" ), g_vars->exploits.sniper_bullet_tp, true, cfg_path );
	this->boolean( hash_str( "exploits.instant_reload" ), g_vars->exploits.instant_reload, true, cfg_path );

	return true;
}

auto config::u_configuration::load( const unsigned int& cfg
) -> bool
{
	std::string cfg_path = get_config( cfg );

	this->integer( hash_str( "aim.aim_keycode" ), g_vars->aim.aim_keycode, false, cfg_path );
	this->integer( hash_str( "aim.second_aim_keycode" ), g_vars->aim.second_aim_keycode, false, cfg_path );
	this->integer( hash_str( "aim.target_bone" ), g_vars->aim.target_bone, false, cfg_path );
	this->integer( hash_str( "aim.aim_distance" ), g_vars->aim.aim_distance, false, cfg_path );

	this->boolean( hash_str( "aim.enabled" ), g_vars->aim.enabled, false, cfg_path );
	this->boolean( hash_str( "aim.controller" ), g_vars->aim.controller, false, cfg_path );
	this->boolean( hash_str( "aim.prediction" ), g_vars->aim.prediction, false, cfg_path );
	this->boolean( hash_str( "aim.prediction_indicator" ), g_vars->aim.prediction_indicator, false, cfg_path );
	this->boolean( hash_str( "aim.ignore_team" ), g_vars->aim.ignore_team, false, cfg_path );
	this->boolean( hash_str( "aim.ignore_knocked" ), g_vars->aim.ignore_knocked, false, cfg_path );
	this->boolean( hash_str( "aim.ignore_invisible" ), g_vars->aim.ignore_invisible, false, cfg_path );
	this->boolean( hash_str( "aim.aim_when_held" ), g_vars->aim.aim_when_held, false, cfg_path );

	this->floating( hash_str( "aim.fov_c" ), g_vars->aim.fov_c, false, cfg_path );
	this->floating( hash_str( "aim.smooth" ), g_vars->aim.smooth, false, cfg_path );

	this->boolean( hash_str( "weapon_config.enable" ), g_vars->weapon_config.enable, false, cfg_path );
	this->integer( hash_str( "weapon_config.selected_weapon" ), g_vars->weapon_config.selected_weapon, false, cfg_path );

	this->boolean( hash_str( "smg.enabled" ), g_vars->weapon_config.smg.enabled, false, cfg_path );
	this->floating( hash_str( "smg.smooth" ), g_vars->weapon_config.smg.smooth, false, cfg_path );
	this->floating( hash_str( "smg.weapon_fov" ), g_vars->weapon_config.smg.weapon_fov, false, cfg_path );
	this->integer( hash_str( "smg.target_bone" ), g_vars->weapon_config.smg.target_bone, false, cfg_path );

	this->boolean( hash_str( "ars.enabled" ), g_vars->weapon_config.ars.enabled, false, cfg_path );
	this->floating( hash_str( "ars.smooth" ), g_vars->weapon_config.ars.smooth, false, cfg_path );
	this->floating( hash_str( "ars.weapon_fov" ), g_vars->weapon_config.ars.weapon_fov, false, cfg_path );
	this->integer( hash_str( "ars.target_bone" ), g_vars->weapon_config.ars.target_bone, false, cfg_path );

	this->boolean( hash_str( "shotgun.enabled" ), g_vars->weapon_config.shotgun.enabled, false, cfg_path );
	this->floating( hash_str( "shotgun.weapon_fov" ), g_vars->weapon_config.shotgun.weapon_fov, false, cfg_path );
	this->floating( hash_str( "shotgun.smooth" ), g_vars->weapon_config.shotgun.smooth, false, cfg_path );
	this->integer( hash_str( "shotgun.target_bone" ), g_vars->weapon_config.shotgun.target_bone, false, cfg_path );

	this->boolean( hash_str( "pistol.enabled" ), g_vars->weapon_config.pistol.enabled, false, cfg_path );
	this->floating( hash_str( "pistol.weapon_fov" ), g_vars->weapon_config.pistol.weapon_fov, false, cfg_path );
	this->floating( hash_str( "pistol.smooth" ), g_vars->weapon_config.pistol.smooth, false, cfg_path );
	this->integer( hash_str( "pistol.target_bone" ), g_vars->weapon_config.pistol.target_bone, false, cfg_path );

	this->boolean( hash_str( "snipers.enabled" ), g_vars->weapon_config.snipers.enabled, false, cfg_path );
	this->floating( hash_str( "snipers.weapon_fov" ), g_vars->weapon_config.snipers.weapon_fov, false, cfg_path );
	this->floating( hash_str( "snipers.smooth" ), g_vars->weapon_config.snipers.smooth, false, cfg_path );
	this->integer( hash_str( "snipers.target_bone" ), g_vars->weapon_config.snipers.target_bone, false, cfg_path );

	this->boolean( hash_str( "close_aim.enabled" ), g_vars->weapon_config.close_aim.enabled, false, cfg_path );
	this->floating( hash_str( "close_aim.weapon_fov" ), g_vars->weapon_config.close_aim.weapon_fov, false, cfg_path );
	this->floating( hash_str( "close_aim.smooth" ), g_vars->weapon_config.close_aim.smooth, false, cfg_path );
	this->integer( hash_str( "close_aim.target_bone" ), g_vars->weapon_config.close_aim.target_bone, false, cfg_path );
	this->integer( hash_str( "close_aim.distance" ), g_vars->weapon_config.close_aim.distance, false, cfg_path );

	this->floating( hash_str( "visuals.box_width" ), g_vars->visuals.box_width, false, cfg_path );
	this->floating( hash_str( "visuals.boxes_thickness" ), g_vars->visuals.boxes_thickness, false, cfg_path );
	this->floating( hash_str( "visuals.arrow_width" ), g_vars->visuals.arrow_widht, false, cfg_path );
	this->floating( hash_str( "visuals.arrow_radius" ), g_vars->visuals.arrow_radius, false, cfg_path );
	this->floating( hash_str( "visuals.skeleton_thickness" ), g_vars->visuals.skeleton_thickness, false, cfg_path );
	this->floating( hash_str( "visuals.skeleton_joints_radius" ), g_vars->visuals.skeleton_joints_radius, false, cfg_path );

	this->integer( hash_str( "visuals.render_distance" ), g_vars->visuals.render_distance, false, cfg_path );
	this->integer( hash_str( "visuals.boxes_mode" ), g_vars->visuals.boxes_mode, false, cfg_path );
	this->integer( hash_str( "visuals.arrows_mode" ), g_vars->visuals.arrows_mode, false, cfg_path );
	this->integer( hash_str( "visuals.snapline_mode" ), g_vars->visuals.snapline_mode, false, cfg_path );
	this->integer( hash_str( "visuals.snapline_end" ), g_vars->visuals.snapline_end, false, cfg_path );
	this->integer( hash_str( "visuals.snapline_x" ), g_vars->visuals.snapline_x, false, cfg_path );
	this->integer( hash_str( "visuals.snapline_y" ), g_vars->visuals.snapline_y, false, cfg_path );
	this->integer( hash_str( "visuals.skeleton_mode" ), g_vars->visuals.skeleton_mode, false, cfg_path );

	this->boolean( hash_str( "visuals.esp" ), g_vars->visuals.esp, false, cfg_path );
	this->boolean( hash_str( "visuals.boxes" ), g_vars->visuals.boxes, false, cfg_path );
	this->boolean( hash_str( "visuals.corners" ), g_vars->visuals.corners, false, cfg_path );
	this->boolean( hash_str( "visuals.rotating" ), g_vars->visuals.rotating, false, cfg_path );
	this->boolean( hash_str( "visuals.boxes_filled" ), g_vars->visuals.boxes_filled, false, cfg_path );
	this->boolean( hash_str( "visuals.boxes_outline" ), g_vars->visuals.boxes_outline, false, cfg_path );
	this->boolean( hash_str( "visuals.arrows" ), g_vars->visuals.arrows, false, cfg_path );
	this->boolean( hash_str( "visuals.filled_arrows" ), g_vars->visuals.filled_arrows, false, cfg_path );
	this->boolean( hash_str( "visuals.arrows_outline" ), g_vars->visuals.arrows_outline, false, cfg_path );
	this->boolean( hash_str( "visuals.username" ), g_vars->visuals.username, false, cfg_path );
	this->boolean( hash_str( "visuals.distance" ), g_vars->visuals.distance, false, cfg_path );
	this->boolean( hash_str( "visuals.snapline" ), g_vars->visuals.snapline, false, cfg_path );
	this->boolean( hash_str( "visuals.team" ), g_vars->visuals.team, false, cfg_path );
	this->boolean( hash_str( "visuals.show_only_visible_snaplines" ), g_vars->visuals.show_only_visible_snaplines, false, cfg_path );
	this->boolean( hash_str( "visuals.snapline_outline" ), g_vars->visuals.snapline_outline, false, cfg_path );
	this->boolean( hash_str( "visuals.weapon" ), g_vars->visuals.weapon, false, cfg_path );
	this->boolean( hash_str( "visuals.weapon_tier_color" ), g_vars->visuals.weapon_tier_color, false, cfg_path );
	this->boolean( hash_str( "visuals.weapon_tier_name" ), g_vars->visuals.weapon_tier_name, false, cfg_path );
	this->boolean( hash_str( "visuals.weapon_ammo" ), g_vars->visuals.weapon_ammo, false, cfg_path );
	this->boolean( hash_str( "visuals.weapon_icon" ), g_vars->visuals.weapon_icon, false, cfg_path );
	this->boolean( hash_str( "visuals.kill_count" ), g_vars->visuals.kill_count, false, cfg_path );
	this->boolean( hash_str( "visuals.skeleton" ), g_vars->visuals.skeleton, false, cfg_path );
	this->boolean( hash_str( "visuals.skeleton_outline" ), g_vars->visuals.skeleton_outline, false, cfg_path );
	this->floating( hash_str( "visuals.skeleton_outline_thickness" ), g_vars->visuals.skeleton_outline_thickness, false, cfg_path );
	this->boolean( hash_str( "visuals.skeleton_joints" ), g_vars->visuals.skeleton_joints, false, cfg_path );
	this->boolean( hash_str( "visuals.skeleton_joints_outline" ), g_vars->visuals.skeleton_joints_outline, false, cfg_path );
	this->boolean( hash_str( "visuals.rank" ), g_vars->visuals.rank, false, cfg_path );
	this->boolean( hash_str( "visuals.rank_text" ), g_vars->visuals.rank_text, false, cfg_path );
	this->boolean( hash_str( "visuals.rank_icon" ), g_vars->visuals.rank_icon, false, cfg_path );
	this->boolean( hash_str( "visuals.rank_tier_color" ), g_vars->visuals.rank_tier_color, false, cfg_path );
	this->boolean( hash_str( "visuals.platform" ), g_vars->visuals.platform, false, cfg_path );
	this->boolean( hash_str( "visuals.platform_text" ), g_vars->visuals.platform_text, false, cfg_path );
	this->boolean( hash_str( "visuals.platform_icon" ), g_vars->visuals.platform_icon, false, cfg_path );
	this->boolean( hash_str( "visuals.platform_color" ), g_vars->visuals.platform_color, false, cfg_path );
	this->boolean( hash_str( "visuals.movement" ), g_vars->visuals.movement, false, cfg_path );
	this->boolean( hash_str( "visuals.view_direction" ), g_vars->visuals.view_direction, false, cfg_path );
	this->boolean( hash_str( "visuals.radar" ), g_vars->visuals.radar, false, cfg_path );
	this->boolean( hash_str( "visuals.flags" ), g_vars->visuals.flags, false, cfg_path );
	this->boolean( hash_str( "visuals.show_target" ), g_vars->visuals.show_target, false, cfg_path );
	this->boolean( hash_str( "visuals.show_team" ), g_vars->visuals.show_team, false, cfg_path );
	this->boolean( hash_str( "visuals.show_dbno" ), g_vars->visuals.show_dbno, false, cfg_path );
	this->boolean( hash_str( "visuals.visibility_check" ), g_vars->visuals.visibility_check, false, cfg_path );
	this->boolean( hash_str( "visuals.targetline" ), g_vars->visuals.targetline, false, cfg_path );
	this->boolean( hash_str( "visuals.mark_enemies" ), g_vars->visuals.mark_enemies, false, cfg_path );
	this->integer( hash_str( "visuals.mark_enemies_bind" ), g_vars->visuals.mark_enemies_bind, false, cfg_path );
	this->boolean( hash_str( "visuals.mark_friendly" ), g_vars->visuals.mark_friendly, false, cfg_path );
	this->integer( hash_str( "visuals.mark_friendly_bind" ), g_vars->visuals.mark_friendly_bind, false, cfg_path );

	this->boolean( hash_str( "flags.aiming" ), g_vars->flags.aiming, false, cfg_path );
	this->boolean( hash_str( "flags.crouched" ), g_vars->flags.crouched, false, cfg_path );
	this->boolean( hash_str( "flags.idle" ), g_vars->flags.idle, false, cfg_path );
	this->boolean( hash_str( "flags.walking" ), g_vars->flags.walking, false, cfg_path );
	this->boolean( hash_str( "flags.falling" ), g_vars->flags.falling, false, cfg_path );
	this->boolean( hash_str( "flags.swimming" ), g_vars->flags.swimming, false, cfg_path );
	this->boolean( hash_str( "flags.flying" ), g_vars->flags.flying, false, cfg_path );
	this->boolean( hash_str( "flags.wounded" ), g_vars->flags.wounded, false, cfg_path );
	this->boolean( hash_str( "flags.reloading" ), g_vars->flags.reloading, false, cfg_path );

	this->color( hash_str( "colors.crosshair_color" ), g_vars->colors.crosshair_color, false, cfg_path );
	this->color( hash_str( "colors.fov_color" ), g_vars->colors.fov_color, false, cfg_path );
	this->color( hash_str( "colors.text_color" ), g_vars->colors.text_color, false, cfg_path );

	this->color( hash_str( "colors.box_color" ), g_vars->colors.box_color, false, cfg_path );
	this->color( hash_str( "colors.corner_box_color" ), g_vars->colors.corner_box_color, false, cfg_path );
	this->color( hash_str( "colors.rotating_color" ), g_vars->colors.rotating_color, false, cfg_path );
	this->color( hash_str( "colors.fill_box_color" ), g_vars->colors.fill_box_color, false, cfg_path );
	this->color( hash_str( "colors.skeleton_color" ), g_vars->colors.skeleton_color, false, cfg_path );
	this->color( hash_str( "colors.skeleton_joints_color" ), g_vars->colors.skeleton_joints_color, false, cfg_path );
	this->color( hash_str( "colors.arrows_color" ), g_vars->colors.arrows_color, false, cfg_path );
	this->color( hash_str( "colors.arrows_filled_color" ), g_vars->colors.arrows_filled_color, false, cfg_path );

	this->color( hash_str( "colors.teammate_color" ), g_vars->colors.teammate_color, false, cfg_path );
	this->color( hash_str( "colors.knocked_color" ), g_vars->colors.knocked_color, false, cfg_path );

	this->color( hash_str( "colors.player_visible" ), g_vars->colors.player_visible, false, cfg_path );
	this->color( hash_str( "colors.player_invisible" ), g_vars->colors.player_invisible, false, cfg_path );
	this->color( hash_str( "colors.text_visible" ), g_vars->colors.text_visible, false, cfg_path );
	this->color( hash_str( "colors.text_invisible" ), g_vars->colors.text_invisible, false, cfg_path );

	this->color( hash_str( "colors.weapon_color" ), g_vars->colors.weapon_color, false, cfg_path );
	this->color( hash_str( "colors.distance_color" ), g_vars->colors.distance_color, false, cfg_path );
	this->color( hash_str( "colors.username_color" ), g_vars->colors.username_color, false, cfg_path );
	this->color( hash_str( "colors.rank_color" ), g_vars->colors.rank_color, false, cfg_path );
	this->color( hash_str( "colors.team_color" ), g_vars->colors.team_color, false, cfg_path );
	this->color( hash_str( "colors.kill_color" ), g_vars->colors.kill_color, false, cfg_path );
	this->color( hash_str( "colors.snapline_color" ), g_vars->colors.snapline_color, false, cfg_path );
	this->color( hash_str( "colors.view_angle_color" ), g_vars->colors.view_angle_color, false, cfg_path );
	this->color( hash_str( "colors.platform_color" ), g_vars->colors.platform_color, false, cfg_path );
	this->color( hash_str( "colors.targeted_color" ), g_vars->colors.targeted_color, false, cfg_path );
	this->color( hash_str( "colors.targetline_color" ), g_vars->colors.targetline_color, false, cfg_path );
	this->color( hash_str( "colors.prediction_color" ), g_vars->colors.prediction_color, false, cfg_path );
	this->color( hash_str( "colors.enemy_color" ), g_vars->colors.enemy_color, false, cfg_path );
	this->color( hash_str( "colors.friendly_color" ), g_vars->colors.friendly_color, false, cfg_path );
	this->color( hash_str( "colors.movement_tracers_color" ), g_vars->colors.movement_tracers_color, false, cfg_path );

	this->floating( hash_str( "radar.radar_width" ), g_vars->radar.radar_width, false, cfg_path );
	this->floating( hash_str( "radar.radar_height" ), g_vars->radar.radar_height, false, cfg_path );
	this->floating( hash_str( "radar.radar_size" ), g_vars->radar.radar_size, false, cfg_path );
	this->floating( hash_str( "radar.radar_distance" ), g_vars->radar.radar_distance, false, cfg_path );

	this->floating( hash_str( "radar.radar_solid_fill_opacity" ), g_vars->radar.radar_solid_fill_opacity, false, cfg_path );
	this->floating( hash_str( "radar.radar_match_opacity" ), g_vars->radar.radar_match_opacity, false, cfg_path );
	this->floating( hash_str( "radar.radar_match_outline_opacity" ), g_vars->radar.radar_match_outline_opacity, false, cfg_path );
	this->color( hash_str( "radar.radar_match_color" ), g_vars->radar.radar_match_color, false, cfg_path );

	this->floating( hash_str( "radar.radar_match_fade_out" ), g_vars->radar.radar_match_fade_out, false, cfg_path );
	this->floating( hash_str( "radar.radar_match_size" ), g_vars->radar.radar_match_size, false, cfg_path );
	this->color( hash_str( "radar.lines_color" ), g_vars->radar.lines_color, false, cfg_path );

	this->floating( hash_str( "radar.radar_fov_opacity" ), g_vars->radar.radar_fov_opacity, false, cfg_path );
	this->floating( hash_str( "radar.radar_fov_fade_out" ), g_vars->radar.radar_fov_fade_out, false, cfg_path );
	this->floating( hash_str( "radar.radar_fov_match_size" ), g_vars->radar.radar_fov_match_size, false, cfg_path );
	this->color( hash_str( "radar.fov_color" ), g_vars->radar.fov_color, false, cfg_path );

	this->color( hash_str( "radar.radar_dot_color" ), g_vars->radar.radar_dot_color, false, cfg_path );

	this->boolean( hash_str( "radar.radar_lines" ), g_vars->radar.radar_lines, false, cfg_path );
	this->boolean( hash_str( "radar.display_fov" ), g_vars->radar.display_fov, false, cfg_path );
	this->boolean( hash_str( "radar.display_world_entities" ), g_vars->radar.display_world_entities, false, cfg_path );
	this->boolean( hash_str( "radar.display_distance" ), g_vars->radar.display_distance, false, cfg_path );
	this->boolean( hash_str( "radar.outlined_dots" ), g_vars->radar.outlined_dots, false, cfg_path );
	this->boolean( hash_str( "radar.ignore_wounded" ), g_vars->radar.ignore_wounded, false, cfg_path );
	this->boolean( hash_str( "radar.ignore_teammates" ), g_vars->radar.ignore_teammates, false, cfg_path );
	this->boolean( hash_str( "radar.ignore_invisible" ), g_vars->radar.ignore_invisible, false, cfg_path );

	this->floating( hash_str( "crosshair.rotation" ), g_vars->crosshair.rotation, false, cfg_path );
	this->floating( hash_str( "crosshair.length" ), g_vars->crosshair.length, false, cfg_path );
	this->floating( hash_str( "crosshair.thickness" ), g_vars->crosshair.thickness, false, cfg_path );
	this->floating( hash_str( "crosshair.gap" ), g_vars->crosshair.gap, false, cfg_path );
	this->floating( hash_str( "crosshair.outline" ), g_vars->crosshair.outline, false, cfg_path );

	this->boolean( hash_str( "crosshair.circle_filled" ), g_vars->crosshair.circle_filled, false, cfg_path );

	this->boolean( hash_str( "misc.fov" ), g_vars->misc.fov, false, cfg_path );
	this->boolean( hash_str( "misc.fps" ), g_vars->misc.fps, false, cfg_path );
	this->boolean( hash_str( "misc.crosshair" ), g_vars->misc.crosshair, false, cfg_path );

	this->integer( hash_str( "misc.selected_crosshair" ), g_vars->misc.selected_crosshair, false, cfg_path );
	this->boolean( hash_str( "misc.show_keybinds" ), g_vars->misc.show_keybinds, false, cfg_path );
	this->integer( hash_str( "misc.keybinds" ), g_vars->misc.keybinds, false, cfg_path );
	this->integer( hash_str( "misc.eye_tracer_length" ), g_vars->misc.eye_tracer_length, false, cfg_path );
	this->integer( hash_str( "misc.menu_key" ), g_vars->misc.menu_key, false, cfg_path );
	this->integer( hash_str( "misc.maximum_distance" ), g_vars->misc.maximum_distance, false, cfg_path );

	this->integer( hash_str( "misc.aqua_is_not_going_to_be_happy" ), g_vars->misc.aqua_is_not_going_to_be_happy, false, cfg_path );

	this->boolean( hash_str( "misc.movement_tracers" ), g_vars->misc.movement_tracers, false, cfg_path );
	this->integer( hash_str( "misc.movement_tracers_mode" ), g_vars->misc.movement_tracers_mode, false, cfg_path );
	this->boolean( hash_str( "misc.movement_tracers_outline" ), g_vars->misc.movement_tracers_outline, false, cfg_path );

	this->boolean( hash_str( "trigger.triggerbot" ), g_vars->trigger.triggerbot, false, cfg_path );
	this->integer( hash_str( "trigger.trigger_keycode" ), g_vars->trigger.trigger_keycode, false, cfg_path );
	this->integer( hash_str( "trigger.trigger_distance" ), g_vars->trigger.trigger_distance, false, cfg_path );
	this->boolean( hash_str( "trigger.shotgun_only" ), g_vars->trigger.shotgun_only, false, cfg_path );
	this->boolean( hash_str( "trigger.enable_delay" ), g_vars->trigger.enable_delay, false, cfg_path );
	this->integer( hash_str( "trigger.trigger_delay" ), g_vars->trigger.trigger_delay, false, cfg_path );

	this->boolean( hash_str( "exploits.dark_sky" ), g_vars->exploits.dark_sky, false, cfg_path );
	this->boolean( hash_str( "exploits.infinite_fuel" ), g_vars->exploits.infinite_fuel, false, cfg_path );
	this->boolean( hash_str( "exploits.vehicle_teleport" ), g_vars->exploits.vehicle_teleport, false, cfg_path );
	this->integer( hash_str( "exploits.vehicle_tp_key" ), g_vars->exploits.vehicle_tp_key, false, cfg_path );
	this->integer( hash_str( "exploits.vehicle_tp_type" ), g_vars->exploits.vehicle_tp_type, false, cfg_path );
	this->boolean( hash_str( "exploits.speed_hack" ), g_vars->exploits.speed_hack, false, cfg_path );
	this->floating( hash_str( "exploits.speed_hack_limit" ), g_vars->exploits.speed_hack_limit, false, cfg_path );
	this->integer( hash_str( "exploits.speed_hack_key" ), g_vars->exploits.speed_hack_key, false, cfg_path );
	this->boolean( hash_str( "exploits.bike_jump" ), g_vars->exploits.bike_jump, false, cfg_path );
	this->floating( hash_str( "exploits.max_jump_force" ), g_vars->exploits.max_jump_force, false, cfg_path );
	this->floating( hash_str( "exploits.max_jump_forward" ), g_vars->exploits.max_jump_forward, false, cfg_path );
	this->boolean( hash_str( "exploits.car_fly" ), g_vars->exploits.car_fly, false, cfg_path );
	this->integer( hash_str( "exploits.key_up" ), g_vars->exploits.key_up, false, cfg_path );
	this->integer( hash_str( "exploits.key_down" ), g_vars->exploits.key_down, false, cfg_path );
	this->boolean( hash_str( "exploits.remove_car_animations" ), g_vars->exploits.remove_car_animations, false, cfg_path );
	this->boolean( hash_str( "exploits.disable_car_gravity" ), g_vars->exploits.disable_car_gravity, false, cfg_path );
	this->boolean( hash_str( "exploits.instant_brakes" ), g_vars->exploits.instant_brakes, false, cfg_path );
	this->boolean( hash_str( "exploits.grippy_cars" ), g_vars->exploits.grippy_cars, false, cfg_path );
	this->boolean( hash_str( "exploits.fov_changer" ), g_vars->exploits.fov_changer, false, cfg_path );
	this->floating( hash_str( "exploits.camera_fov" ), g_vars->exploits.camera_fov, false, cfg_path );
	this->floating( hash_str( "exploits.ads_fov" ), g_vars->exploits.ads_fov, false, cfg_path );
	this->boolean( hash_str( "exploits.vehicle_speedhack" ), g_vars->exploits.vehicle_speedhack, false, cfg_path );
	this->integer( hash_str( "exploits.vehicle_speed" ), g_vars->exploits.vehicle_speed, false, cfg_path );
	this->boolean( hash_str( "exploits.vehicle_airstuck" ), g_vars->exploits.vehicle_airstuck, false, cfg_path );
	this->integer( hash_str( "exploits.key_vehicle_airstuck" ), g_vars->exploits.key_vehicle_airstuck, false, cfg_path );
	this->boolean( hash_str( "exploits.sniper_bullet_tp" ), g_vars->exploits.sniper_bullet_tp, false, cfg_path );
	this->boolean( hash_str( "exploits.instant_reload" ), g_vars->exploits.instant_reload, false, cfg_path );

	return true;
}