#pragma once
#ifndef INC_HPP
#define INC_HPP

#define IMGUI_DEFINE_MATH_OPERATORS
#define M_PI   3.14159265358979323846264338327950288

#include <math.h>
#include <cmath>
#include <filesystem>

#include <dependencies/vmp/include/VMProtectSDK.h>

#include <core/hash.hpp>
#include <core/ntos/ia32.hpp>
#include <core/import.hpp>

// libraries
#include <curl/curl.h>
#include <nlohmann/json.hpp>
#include <gzip/decompress.hpp>
#include <dependencies/console/console.hpp>
#include <resources/ime/ime.hpp>
#include <resources/bits/font.h>
#include <resources/bits/icons.h>

// kernel structs
#include <dependencies/efi/ntos/ia32.hpp>
#include <dependencies/efi/ntos/md5.hpp>

// pbd components
#include <dependencies/efi/pdb/pdb.hpp>

// efi components
#include <dependencies/efi/efi.hpp>

// sync ( auto-update )
#include <dependencies/sync/sync.hpp>

// math
#include <core/game/math/vector.hpp>

// direct-x 9
#include <d3dx9.h>
#include <d3d9.h>
#pragma comment (lib, "d3d9.lib")
#pragma comment (lib, "d3dx9.lib")
#include <resources/d3d9/d3dx9.h>

// imgui v1.90.4
#include <resources/imgui/imgui.h>
#include <resources/imgui/imgui_impl_dx9.h>
#include <resources/imgui/imgui_impl_win32.h>
#include <resources/imgui/imgui_internal.h>

// unicodes
#include <resources/unicodes/unicodes.hpp>

// handlers
#include <core/handlers/keybinds/keybinds.hpp>

// debug stoff
#include <core/event/notifications/notify.hpp>

// vars
#include <core/vars/vars.hpp>

// engine
#include <core/game/engine/engine.hpp>
#include <core/game/objects/object_sdk.hpp>
#include <core/game/objects/objects.hpp>

// events
#include <core/event/event_handler.hpp>

// textures
#include <core/map/textures/textures.hpp>

// icons
#include <core/map/icons.hpp>

// prediction
#include <core/game/prediction/prediction.hpp>

// effects
#include <core/interface/effects/effects.hpp>

// configs
#include <core/interface/configs/config.hpp>

// features
#include <core/game/features/features.hpp>

// mouse
#include <core/event/mouse/mouse.hpp>

// render
#include <core/drawing/drawing.hpp>
#include <core/interface/interface.hpp>
#include <core/render/render.hpp>

#endif