#ifndef PREDICTION_CPP
#define PREDICTION_CPP

#include <core/inc.hpp>

prediction::c_prediction::c_prediction()
{
 /*   weapon_map.emplace( weapon_data_map( 60000.f, 2.f, 7, 2.09 ), hash_str( "Hand Cannon" ) );
    weapon_map.emplace( weapon_data_map( 80000.f, 3.5f, 30, 2.41 ), hash_str( "Warforged Assault Rifle" ) );
    weapon_map.emplace( weapon_data_map( 80000.f, 3.5f, 30, 2.30 ), hash_str( "Tactical Assault Rifle" ) );
    weapon_map.emplace( weapon_data_map( 80000.f, 3.5f, 30, 2.30 ), hash_str( "Nemesis AR" ) );
    weapon_map.emplace( weapon_data_map( 80000.f, 3.5f, 30, 2.30 ), hash_str( "Striker AR" ) );
    weapon_map.emplace( weapon_data_map( 96000.f, 2.5f, 10, 2.50 ), hash_str( "Huntress DMR" ) );
    weapon_map.emplace( weapon_data_map( 75000.f, 3.0f, 50, 3.00 ), hash_str( "Drum Gun" ) );
    weapon_map.emplace( weapon_data_map( 70000.f, 3.0f, 25, 2.60 ), hash_str( "Harbinger SMG" ) );
    weapon_map.emplace( weapon_data_map( 70000.f, 3.0f, 25, 2.60 ), hash_str( "Hyper SMG" ) );
    weapon_map.emplace( weapon_data_map( 70000.f, 3.0f, 25, 2.60 ), hash_str( "Thunder Burst SMG" ) );
    weapon_map.emplace( weapon_data_map( 75000.f, 3.0f, 25, 2.60 ), hash_str( "Midas Drum Gun" ) );
    weapon_map.emplace( weapon_data_map( 50000.f, 3.5f, 5, 2.60 ), hash_str( "Reaper Sniper Rifle" ) );
    weapon_map.emplace( weapon_data_map( 60000.f, 2.0f, 10, 2.09 ), hash_str( "Ranger Pistol" ) );
    weapon_map.emplace( weapon_data_map( 45000.f, 0.f, 1, 3.30f ), hash_str( "Bolt Action Sniper Rifle" ) );
    weapon_map.emplace( weapon_data_map( 45000.f, 0.f, 1, 1.90f ), hash_str( "Hunting Rifle" ) );
    weapon_map.emplace( weapon_data_map( 45000.f, 0.f, 1, 4.30f ), hash_str( "Heavy Sniper Rifle" ) );
    weapon_map.emplace( weapon_data_map( 45000.f, 0.f, 1, 1.90f ), hash_str( "Suppressed Sniper Rifle" ) );
    weapon_map.emplace( weapon_data_map( 53000.f, 0.f, 10, 2.75f ), hash_str( "Thermal DMR" ) );*/
}

auto prediction::c_prediction::get_weapon_data(
    const std::string& weapon ) -> weapon_data_map
{
    for ( const auto& it : weapon_map ) {
        if ( it.second == weapon ) return it.first;
    }
}

auto prediction::c_prediction::resolve_position(
    prediction::prediction_context& ctx ) -> math::vector3
{
    math::vector3 target = ctx.position;

    float horizontalTime = ctx.distance / ctx.weapon_data_map.bullet_speed;
    float verticalTime = ctx.distance / ctx.weapon_data_map.bullet_speed;

    target.x += ctx.player_velocity.x * horizontalTime;
    target.y += ctx.player_velocity.y * horizontalTime;
    target.z += ctx.player_velocity.z * verticalTime + abs( -980 * ctx.weapon_data_map.bullet_scale ) * 0.5f * ( verticalTime * verticalTime );

    return target;
}

#endif // !PREDICTION_CPP