#ifndef OBJECTS_HPP
#define OBJECTS_HPP

namespace object
{
	class c_movement_tracer
	{
	public:
		math::vector3 movement_position;
		std::chrono::time_point<std::chrono::steady_clock> timestamp;
	};

	inline std::vector<c_movement_tracer> movement_tracer;

	class c_weapon_info
	{
	public:
		std::string			m_name;
		int			        m_ammo_count;
		bool			    m_reloading;
		enums::fort_rarity  m_tier;
		enums::EFortWeaponCoreAnimation animation_type;
	};

	class c_movement_mode
	{
	public:

		bool		m_is_aiming;
		bool		m_is_crouched;
		bool		m_is_idle;
		bool		m_is_walking;
		bool		m_is_falling;
		bool		m_is_swimming;
		bool		m_is_flying;
	};

	class c_closest
	{
	public:
		game::a_fort_player_pawn_athena* m_actor;
		game::a_fort_player_state_athena* m_state;
		game::u_skeletal_mesh_component* m_mesh;
		game::u_scene_component* m_root_component;

		float distance;
		bool  is_teammate;
		bool  is_visible;
		bool  is_dbno;

		float	crosshair_space;

		math::vector3 m_head_screen{};
		math::vector3 m_root_screen{};
		math::vector3 m_predicted_position{};

		std::string	m_username;
	};

	struct pickup_info
	{
		enums::fort_rarity actor_tier;
		std::string actor_name;
	};

	class c_spectator
	{
	public:
		int			index;
		std::string	name;
	};

	class c_world
	{
	public:
		std::string name_private;
		game::a_fort_player_pawn* actor;
		game::u_scene_component* root_component;

		int		distance;
		math::vector3	relative_location;

		enums::ItemGroup item_group;
		pickup_info pickup_info;
	};

	class c_list 
	{
	public:
		game::a_fort_player_pawn_athena* m_actor;
		game::a_fort_player_state_athena* m_state;
		game::u_skeletal_mesh_component* m_mesh;
		game::u_scene_component* m_root_component;

		bool	m_is_teammate;
		bool	m_is_on_screen;

		bool    m_is_friendly;
		bool    m_is_enemy;

		bool	is_dbno;
		bool	is_bot;
		bool	is_visible;
		
		bounds::bounds_t o;
		engine::frotator rotation;

		std::uint32_t m_team_index;
		std::uint32_t m_kill_count;
		std::string m_username;
		std::string m_platform;

		enums::FRankedProgressReplicatedData m_rank_information;
		c_weapon_info	m_weapon_info;
		c_movement_mode m_movement;
	};

	class c_levels {
	public:
		game::a_fort_player_pawn* m_actor;
		std::string m_name;
		game::u_scene_component* m_root_comp;
		math::vector3 m_location;
		float m_distance;
		game::u_fort_item_definition* m_pickup_entry;
		ImColor m_tier_color;
		std::string m_item_name;
	};

	class projcetiles
	{
	public:
		math::vector3	start_point;
		math::vector3	hit_point;
		std::chrono::time_point<std::chrono::steady_clock> timestamp;
	};

	class movements
	{
	public:
		math::vector3	position;
		std::chrono::time_point<std::chrono::steady_clock> timestamp;
	};
}

#endif // ! guard