#ifndef WORLD_CPP
#define WORLD_CPP

#include <core/inc.hpp>

auto cheat_interface::c_visual::render_world( ) -> void
{
	try {

		if ( !g_vars->loot.enable ) return;

		if ( !g_ctx->view_state ) return;

		if ( g_ctx->m_world_items.size( ) < 1 ) return;

		for ( auto& item : g_ctx->m_world_items )
		{
			if ( !item.root_component->is_valid( ) ) continue;

			auto relative_screen = g_engine->world_to_screen( item.relative_location );
			if ( !g_engine->in_screen( relative_screen ) ) continue;

			switch ( item.item_group )
			{
			case enums::ItemGroup::Marker:
			{
				if ( g_vars->exploits.vehicle_teleport && item.name_private.find( hash_str( "B_AthenaPlayerMarker_WithCustomization_C" ) ) != std::string::npos )
				{
					std::string item_name = hash_str( "Waypoint Marker" ); auto text_padding = 0.00f;

					g_framework->render_world_object(
						text_padding,
						ImVec2( relative_screen.x, relative_screen.y ),
						item_name,
						item.distance,
						ImColor( g_vars->world_colors.s.chest_color[ 0 ], g_vars->world_colors.s.chest_color[ 1 ], g_vars->world_colors.s.chest_color[ 2 ] ),
						TRUE
					);
				}
				break;
			}
			case enums::ItemGroup::Searchables:
			{
				if ( !g_vars->loot.show_searchables ) continue;

				if ( g_vars->loot.s.chests && item.name_private.find( hash_str( "Tiered_Chest" ) ) != std::string::npos )
				{
					std::string item_name = hash_str( "Chest" ); auto text_padding = 0.00f;

					g_framework->render_world_object(
						text_padding,
						ImVec2( relative_screen.x, relative_screen.y ),
						item_name,
						item.distance,
						ImColor( g_vars->world_colors.s.chest_color [ 0 ], g_vars->world_colors.s.chest_color [ 1 ], g_vars->world_colors.s.chest_color [ 2 ] ),
						g_vars->loot.s.show_searchables_distance
					);
				}

				if ( g_vars->loot.s.ammo_boxes && item.name_private.find( hash_str( "Tiered_Ammo" ) ) != std::string::npos )
				{
					std::string item_name = hash_str( "Ammo Box" ); auto text_padding = 0.00f;

					g_framework->render_world_object(
						text_padding,
						ImVec2( relative_screen.x, relative_screen.y ),
						item_name,
						item.distance,
						ImColor( g_vars->world_colors.s.ammo_box_color [ 0 ], g_vars->world_colors.s.ammo_box_color [ 1 ], g_vars->world_colors.s.ammo_box_color [ 2 ] ),
						g_vars->loot.s.show_searchables_distance
					);
				}

				if ( g_vars->loot.s.lammas && item.name_private.find( hash_str( "AthenaSupplyDrop_Llama_C" ) ) != std::string::npos )
				{
					std::string item_name = hash_str( "Lamma" ); auto text_padding = 0.00f;

					g_framework->render_world_object(
						text_padding,
						ImVec2( relative_screen.x, relative_screen.y ),
						item_name,
						item.distance,
						ImColor( g_vars->world_colors.s.lammas_color [ 0 ], g_vars->world_colors.s.lammas_color [ 1 ], g_vars->world_colors.s.lammas_color [ 2 ] ),
						g_vars->loot.s.show_searchables_distance
					);
				}

				if ( g_vars->loot.s.airdrops && item.name_private.find( hash_str( "B_SpecialSupplyDrop_Base_BlastBerry_C" ) ) != std::string::npos )
				{
					std::string item_name = hash_str( "Supply Drop" ); auto text_padding = 0.00f;

					g_framework->render_world_object(
						text_padding,
						ImVec2( relative_screen.x, relative_screen.y ),
						item_name,
						item.distance,
						ImColor( g_vars->world_colors.s.airdrop_color [ 0 ], g_vars->world_colors.s.airdrop_color [ 1 ], g_vars->world_colors.s.airdrop_color [ 2 ] ),
						g_vars->loot.s.show_searchables_distance
					);
				}

				break;
			}

			case enums::ItemGroup::Dropped:
			{
				if ( !g_vars->loot.show_dropped ) continue;

				if ( item.name_private.find( hash_str( "FortPickupAthena" ) ) != std::string::npos )
				{
					std::string tier_name = get_weapon_tier_name( item.pickup_info.actor_tier );
					ImColor tier_color = get_weapon_color( item.pickup_info.actor_tier );

					if ( g_vars->loot.d.wood && item.pickup_info.actor_name == hash_str( "Wood" ) )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.wood_color [ 0 ], g_vars->world_colors.d.wood_color [ 1 ], g_vars->world_colors.d.wood_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}

					if ( g_vars->loot.d.stone && item.pickup_info.actor_name == hash_str( "Stone" ) )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.stone_color [ 0 ], g_vars->world_colors.d.stone_color [ 1 ], g_vars->world_colors.d.stone_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}

					if ( g_vars->loot.d.pistol_ammo && item.pickup_info.actor_name == hash_str( "Ammo: Light Bullets" ) )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.pistol_ammo_color [ 0 ], g_vars->world_colors.d.pistol_ammo_color [ 1 ], g_vars->world_colors.d.pistol_ammo_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}

					if ( g_vars->loot.d.rifle_ammo && item.pickup_info.actor_name == hash_str( "Ammo: Medium Bullets" ) )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.rifle_ammo_color [ 0 ], g_vars->world_colors.d.rifle_ammo_color [ 1 ], g_vars->world_colors.d.rifle_ammo_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}

					if ( g_vars->loot.d.shotgun_ammo && item.pickup_info.actor_name == hash_str( "Ammo: Shells" ) )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.shotgun_ammo_color [ 0 ], g_vars->world_colors.d.shotgun_ammo_color [ 1 ], g_vars->world_colors.d.shotgun_ammo_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}

					if ( g_vars->loot.d.sniper_ammo && item.pickup_info.actor_name == hash_str( "Ammo: Heavy Bullets" ) )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.sniper_ammo_color [ 0 ], g_vars->world_colors.d.sniper_ammo_color [ 1 ], g_vars->world_colors.d.sniper_ammo_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}

					if ( g_vars->loot.d.grenade_ammo && item.pickup_info.actor_name == hash_str( "Ammo: Rockets" ) )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.grenade_ammo_color [ 0 ], g_vars->world_colors.d.grenade_ammo_color [ 1 ], g_vars->world_colors.d.grenade_ammo_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}

					if ( g_vars->loot.d.shotguns && item.pickup_info.actor_name.find( hash_str( "Shotgun" ) ) != std::string::npos )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						ImColor set_item_color = g_vars->loot.d.show_dropped_rarity_color ? tier_color
							: ImColor( g_vars->world_colors.d.shotguns_color [ 0 ], g_vars->world_colors.d.shotguns_color [ 1 ], g_vars->world_colors.d.shotguns_color [ 2 ] );

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							set_item_color,
							g_vars->loot.d.show_dropped_distance,
							g_vars->loot.d.show_dropped_rarity_name,
							tier_name
						);
					}

					if ( g_vars->loot.d.ars && item.pickup_info.actor_name.find( hash_str( "Rifle" ) ) != std::string::npos
						|| item.pickup_info.actor_name.find( hash_str( "AR" ) ) != std::string::npos  )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						ImColor set_item_color = g_vars->loot.d.show_dropped_rarity_color ? tier_color
							: ImColor( g_vars->world_colors.d.ars_color [ 0 ], g_vars->world_colors.d.ars_color [ 1 ], g_vars->world_colors.d.ars_color [ 2 ] );

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							set_item_color,
							g_vars->loot.d.show_dropped_distance,
							g_vars->loot.d.show_dropped_rarity_name,
							tier_name
						);
					}

					if ( g_vars->loot.d.smgs && item.pickup_info.actor_name.find( hash_str( "SMG" ) ) != std::string::npos )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						ImColor set_item_color = g_vars->loot.d.show_dropped_rarity_color ? tier_color
							: ImColor( g_vars->world_colors.d.smgs_color [ 0 ], g_vars->world_colors.d.smgs_color [ 1 ], g_vars->world_colors.d.smgs_color [ 2 ] );

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							set_item_color,
							g_vars->loot.d.show_dropped_distance,
							g_vars->loot.d.show_dropped_rarity_name,
							tier_name
						);
					}

					if ( g_vars->loot.d.pistols && item.pickup_info.actor_name.find( hash_str( "Pistol" ) ) != std::string::npos )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						ImColor set_item_color = g_vars->loot.d.show_dropped_rarity_color ? tier_color
							: ImColor( g_vars->world_colors.d.pistols_color [ 0 ], g_vars->world_colors.d.pistols_color [ 1 ], g_vars->world_colors.d.pistols_color [ 2 ] );

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							set_item_color,
							g_vars->loot.d.show_dropped_distance,
							g_vars->loot.d.show_dropped_rarity_name,
							tier_name
						);
					}

					if ( g_vars->loot.d.snipers && item.pickup_info.actor_name.find( hash_str( "Sniper" ) ) != std::string::npos )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						ImColor set_item_color = g_vars->loot.d.show_dropped_rarity_color ? tier_color
							: ImColor( g_vars->world_colors.d.snipers_color [ 0 ], g_vars->world_colors.d.snipers_color [ 1 ], g_vars->world_colors.d.snipers_color [ 2 ] );

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							set_item_color,
							g_vars->loot.d.show_dropped_distance,
							g_vars->loot.d.show_dropped_rarity_name,
							tier_name
						);
					}

					if ( g_vars->loot.d.bandages && item.pickup_info.actor_name == hash_str( "Bandage" ) )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.bandages_color [ 0 ], g_vars->world_colors.d.bandages_color [ 1 ], g_vars->world_colors.d.bandages_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}

					if ( g_vars->loot.d.minis && item.pickup_info.actor_name == hash_str( "Small Shield Potion" ) )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.minis_color [ 0 ], g_vars->world_colors.d.minis_color [ 1 ], g_vars->world_colors.d.minis_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}

					if ( g_vars->loot.d.bigpot && item.pickup_info.actor_name == hash_str( "Shield Potion" ) )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.bigpot_color [ 0 ], g_vars->world_colors.d.bigpot_color [ 1 ], g_vars->world_colors.d.bigpot_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}

					if ( g_vars->loot.d.medkit && item.pickup_info.actor_name == hash_str( "Med Kit" ) )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.medkit_color [ 0 ], g_vars->world_colors.d.medkit_color [ 1 ], g_vars->world_colors.d.medkit_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}

					if ( g_vars->loot.d.slurp && item.pickup_info.actor_name == hash_str( "Slurp Juice" ) )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.slurp_color [ 0 ], g_vars->world_colors.d.slurp_color [ 1 ], g_vars->world_colors.d.slurp_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}

					if ( g_vars->loot.d.chugsplash && item.pickup_info.actor_name.find( hash_str( "Chug Splash" ) ) != std::string::npos
						|| item.pickup_info.actor_name.find( hash_str( "Gold Splash" ) ) != std::string::npos 
						)
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.chugspalsh_color [ 0 ], g_vars->world_colors.d.chugspalsh_color [ 1 ], g_vars->world_colors.d.chugspalsh_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}

					if ( g_vars->loot.d.chugjug && item.pickup_info.actor_name == hash_str( "Chug Jug" ) )
					{
						std::string item_name = item.pickup_info.actor_name; auto text_padding = 0.00f;

						g_framework->render_world_object(
							text_padding,
							ImVec2( relative_screen.x, relative_screen.y ),
							item_name,
							item.distance,
							ImColor( g_vars->world_colors.d.chugjug_color [ 0 ], g_vars->world_colors.d.chugjug_color [ 1 ], g_vars->world_colors.d.chugjug_color [ 2 ] ),
							g_vars->loot.d.show_dropped_distance
						);
					}
				}

				break;
			}

			case enums::ItemGroup::Vehicles:
			{
				if ( !g_vars->loot.show_vehicles ) continue;

				if ( g_vars->loot.v.bikes && item.name_private.find( hash_str( "Motorcycle_Sport_Vehicle_C" ) ) != std::string::npos )
				{
					std::string item_name = hash_str( "Bike" ); auto text_padding = 0.00f;

					g_framework->render_world_object(
						text_padding,
						ImVec2( relative_screen.x, relative_screen.y ),
						item_name,
						item.distance,
						ImColor( g_vars->world_colors.v.bikes_color [ 0 ], g_vars->world_colors.v.bikes_color [ 1 ], g_vars->world_colors.v.bikes_color [ 2 ] ),
						g_vars->loot.v.show_vehicles_distance
					);
				}

				if ( g_vars->loot.v.sedans && item.name_private.find( hash_str( "Valet_BasicSUV_Vehicle_C" ) ) != std::string::npos )
				{
					std::string item_name = hash_str( "Sedan" ); auto text_padding = 0.00f;

					g_framework->render_world_object(
						text_padding,
						ImVec2( relative_screen.x, relative_screen.y ),
						item_name,
						item.distance,
						ImColor( g_vars->world_colors.v.sedans_color [ 0 ], g_vars->world_colors.v.sedans_color [ 1 ], g_vars->world_colors.v.sedans_color [ 2 ] ),
						g_vars->loot.v.show_vehicles_distance
					);
				}

				break;
			}

			case enums::ItemGroup::World:
			{
				if ( !g_vars->loot.show_world ) continue;

				if ( g_vars->loot.w.weakspots && item.name_private.find( hash_str( "WeakSpot_C" ) ) != std::string::npos )
				{
					std::string item_name = hash_str( "Weakspot" ); auto text_padding = 0.00f;

					g_framework->render_world_object(
						text_padding,
						ImVec2( relative_screen.x, relative_screen.y ),
						item_name,
						item.distance,
						ImColor( g_vars->world_colors.w.weakspot_color [ 0 ], g_vars->world_colors.w.weakspot_color [ 1 ], g_vars->world_colors.w.weakspot_color [ 2 ] ),
						g_vars->loot.w.show_world_distance
					);
				}

				break;
			}
			}
		}

	}
	catch ( const std::exception& e ) {
		m_log->set_text_point( hash_str( "exception caught in entity render thread" ) );
		return;
	}
	catch ( ... ) {
		m_log->set_text_point( hash_str( "exception caught in entity render thread" ) );
		return;
	}
}

#endif