#ifndef MISC_HPP
#define MISC_HPP

namespace misc
{
	class c_misc
	{
	public:
		std::mutex movement_mutex {};
		std::mutex projectiles_mutex {};

		std::vector<object::movements> g_movement_positions {};
		std::vector<object::projcetiles> g_projectiles {};

	public:
		void update_function( std::uint32_t time, std::chrono::steady_clock::time_point& timestamp, std::function<void( )> task )
		{
			auto current_time = std::chrono::steady_clock::now( );
			if ( ( current_time - timestamp ) >= std::chrono::milliseconds( time ) ) {
				task( );
				timestamp = current_time;
			}
		}

		void first_tick( );
		void cache_misc( );
	};

} inline auto g_misc = std::make_unique<misc::c_misc>( );

#endif // !MISC_HPP
