#pragma once
#include <XInput.h>
#include <Windows.h>
#pragma comment(lib, "XInput.lib")

namespace ControllerSupport
{
	class XboxController
	{
	private:
		XINPUT_STATE _controllerState;
		int controllerNum;
	public:
		XboxController( int playerNumber );
		XINPUT_STATE GetControllerState( );
	};

	XboxController::XboxController( int playerNumber )
	{
		controllerNum = playerNumber - 1;
	}

	XINPUT_STATE XboxController::GetControllerState( )
	{
		ZeroMemory( &_controllerState, sizeof( XINPUT_STATE ) );

		XInputGetState( controllerNum, &_controllerState );

		return _controllerState;
	}

	XboxController* ControllerUser = new XboxController( 1 );

	bool IsPressingRightTrigger( )
	{
		if ( ControllerUser->GetControllerState( ).Gamepad.bRightTrigger )
			return true;

		return false;
	}
	bool IsPressingLeftTrigger( )
	{
		if ( ControllerUser->GetControllerState( ).Gamepad.bLeftTrigger )
			return true;

		return false;
	}
}