#ifndef OBJECT_EVENTS_HPP
#define OBJECT_EVENTS_HPP

namespace object_event
{
	class c_entity
	{
	public:
		game::a_game_state_base* game_state{ };
		game::u_world* uworld{ };

		std::vector<object::c_list> m_temp_players{ };
		std::vector<object::c_world> m_temp_world{ };
		std::vector<object::c_spectator> m_temp_spectators{ };

		std::unordered_map<game::a_fort_player_state_athena*, std::string> m_name_cache;
		std::chrono::high_resolution_clock::time_point m_timepoint;

		std::unordered_map<game::a_fort_player_pawn*, std::string> m_world_cache;
		std::unordered_map<game::a_fort_player_pawn*, game::u_scene_component*> m_root_cache;
		std::vector<object::c_levels>  m_levels_cache;
		std::unordered_map<game::a_fort_player_pawn*, game::u_fort_item_definition*> m_pickup_cache;
		std::unordered_map<game::a_fort_player_pawn*, ImColor> m_tier_color_cache;
		std::unordered_map<game::a_fort_player_pawn*, std::string> m_item_name_cache;

	public:

		std::vector<object::c_list> m_players{ };
		std::vector<object::c_world> m_world_items{ };
		std::vector<object::c_spectator> m_spectators{ };

	public:
		ALWAYS_INLINE ~c_entity( ) = default;

		void reset( ) { this->m_temp_players.clear( ); }
		void reset_world( ) { this->m_temp_world.clear( ); }
		void reset_spectators( ) { this->m_temp_spectators.clear( ); }

		std::uint32_t size( ) { return this->m_players.size( ); }
		std::uint32_t size_world( ) { return this->m_world_items.size( ); }
		std::uint32_t size_spectators( ) { return this->m_spectators.size( ); }

		void get_network( const game::u_world& world );
		void get_objects( );
		void get_levels( );
		void get_lobby_actors( );
		void get_spectators( );

	public:

		bool in_lobby = false;
		game::u_scene_view_state* view_state{ };

		struct 
		{
			int	team_id;

			std::string	weapon_name;
			game::a_fort_weapon* weapon;
			enums::EFortWeaponCoreAnimation animation_type;

			game::a_fort_player_state_athena* player_state;
			game::a_fort_player_pawn_athena* player_pawn;
			game::a_player_controller* player_controller;
			game::u_localplayer* local_player;
		} localplayer;
	};

} inline auto g_ctx = std::make_unique<object_event::c_entity>( );


#endif // ! guard