#ifndef NOTIFICATIONS_HPP
#define NOTIFICATIONS_HPP

namespace debug
{
    class NotificationSystem
    {
    private:
        struct Notification
        {
            const char8_t* icon;
            ImColor icon_col;
            std::string title;
            std::string message;
            float showTime;
            float duration;
            bool isActive;
            float currentOffset = 0.0f;
        };

        std::vector<Notification> notifications;
        const float FADE_TIME = 0.5f;
        const float NOTIFICATION_HEIGHT = 78.0f;
        const float STACK_OFFSET = 3.0f;
        const float EXPANDED_SPACING = 8.0f;
        const float ANIMATION_SPEED = 10.0f;
        bool isHovered = false;

        ImU32 GetBackgroundColor( float alpha ) {
            return IM_COL32( 48, 40, 40, ( int ) ( 255 * alpha ) );
        }

        ImU32 GetIconColor( float alpha ) {
            return IM_COL32( 156, 18, 18, ( int ) ( 255 * alpha ) );
        }

        ImU32 GetTitleColor( float alpha ) {
            return IM_COL32( 255, 255, 255, ( int ) ( 255 * alpha ) );
        }

        ImU32 GetTextColor( float alpha ) {
            return IM_COL32( 255, 255, 255, ( int ) ( 80 * alpha ) );
        }

        ImU32 GetShadowColor( float alpha ) {
            return IM_COL32( 0, 0, 0, ( int ) ( 100 * alpha ) );
        }

        void CleanupExpiredNotifications( )
        {
            auto currentTime = ImGui::GetTime( );

            notifications.erase(
                std::remove_if(
                    notifications.begin( ),
                    notifications.end( ),
                    [ currentTime ] ( const Notification& notif ) {
                        return !notif.isActive && ( currentTime - notif.showTime > notif.duration + 1.0f );
                    }
                ),
                notifications.end( )
            );
        }

    public:

        void add_callback( const char8_t* icon, ImColor icon_col, const std::string& message, const std::string& title = "Notification", float duration = 3.0f )
        {
            notifications.insert( notifications.begin( ),
                {
                    icon,
                    icon_col,
                    title,
                    message,
                    static_cast< float >( ImGui::GetTime( ) ),
                    duration,
                    true,
                    0.0f
                } );
        }

        void render_notifications( );
    };

} inline auto g_debug_callback = std::make_unique<debug::NotificationSystem>( );


#endif // !NOTIFICATIONS_HPP