#ifndef MOUSE_HPP
#define MOUSE_HPP

namespace mouse
{
	enum InjectedInputMouseOptions
	{
		move = 1,
		left_up = 4,
		left_down = 2,
		right_up = 8,
		right_down = 16
	};

	typedef struct _InjectedInputMouseInfo
	{
		int DeltaX;
		int DeltaY;
		unsigned int MouseData;
		InjectedInputMouseOptions MouseOptions;
		unsigned int TimeOffsetInMilliseconds;
		void* ExtraInfo;
	} InjectedInputMouseInfo;


	class c_mouse
	{
	public:
		bool initialize_handler( );

		void encrypt_function_bytes( BYTE* bytes, size_t size );
		void decrypt_function_bytes( BYTE* bytes, size_t size );

		bool NtInjectMouse( InjectedInputMouseInfo* input, int count );
		bool simulate_left_click( );
	};
}
inline auto g_mouse = std::make_shared<mouse::c_mouse>( );

#endif // !MOUSE_HPP