#ifndef SDK_HPP
#define SDK_HPP

#define current_address reinterpret_cast<uint64_t>(this )

#define declare_member(type, name, offset) type name() { return g_vm->read<type>(current_address + offset); } 
#define apply_member(type, name, offset) void name( type val ) { g_vm->write<type>(current_address + offset, val); }

#include <cstdint>

#include <workspace/unity/classes/sdk/base_class.hpp>
#include <workspace/unity/classes/sdk/screen.hpp>

#include <workspace/unity/classes/sdk/unity.hpp>

#include <workspace/unity/classes/il2cpp/il2cpp_class.hpp>
#include <workspace/unity/classes/il2cpp/il2cpp_object.hpp>

#include <workspace/unity/classes/sdk/game_object.hpp>
#include <workspace/unity/classes/sdk/object.hpp>
#include <workspace/unity/classes/sdk/transform.hpp>
#include <workspace/unity/classes/sdk/marshal_by_ref_object.hpp>
#include <workspace/unity/classes/sdk/component.hpp>
#include <workspace/unity/classes/sdk/renderer.hpp>
#include <workspace/unity/classes/sdk/behaviour.hpp>
#include <workspace/unity/classes/sdk/mono_behaviour.hpp>

#include <workspace/unity/classes/sdk/fps_camera.hpp>

#include <workspace/unity/classes/sdk/item.hpp>
#include <workspace/unity/classes/sdk/container_collection.hpp>
#include <workspace/unity/classes/sdk/compound_item.hpp>

#include <workspace/unity/classes/sdk/weapon.hpp>
#include <workspace/unity/classes/sdk/new_recoil_shot_effect.hpp>
#include <workspace/unity/classes/sdk/shot_effector.hpp>
#include <workspace/unity/classes/sdk/walk_effector.hpp>
#include <workspace/unity/classes/sdk/force_effector.hpp>
#include <workspace/unity/classes/sdk/breath_effector.hpp>
#include <workspace/unity/classes/sdk/procedural_weapon_animation.hpp>

#include <workspace/unity/classes/sdk/skill_manager.hpp>
#include <workspace/unity/classes/sdk/profile.hpp>

#include <workspace/unity/classes/sdk/movement_context.hpp>

#include <workspace/unity/classes/sdk/body_renderer.hpp>
#include <workspace/unity/classes/sdk/skeleton.hpp>
#include <workspace/unity/classes/sdk/player_body.hpp>

#include <workspace/unity/classes/sdk/player.hpp>
#include <workspace/unity/classes/sdk/network_player.hpp>
#include <workspace/unity/classes/sdk/client_player.hpp>
#include <workspace/unity/classes/sdk/observed_player_view.hpp>

#include <workspace/unity/classes/sdk/game_world.hpp>

#endif // !SDK_HPP
