#ifndef OBJECTS_HPP
#define OBJECTS_HPP

namespace sdk {
	namespace object {

		class c_local_player {
		public:
			c_local_player( ) : main_player( nullptr ) { };
			~c_local_player( ) = default;

			sdk::c_player* main_player;
		};

		struct c_bone_info {
		public:
			c_bone_info( unity::c_transform* transform, enums::e_bone_ids id ) : transform( transform ), id( id ), position( math::vector3( ) ) { };
			~c_bone_info( ) = default;

			unity::c_transform* transform;

			enums::e_bone_ids id;
			math::vector3 position;
		};

		class c_skeleton {
		public:
			c_skeleton( ) : bones( std::vector<c_bone_info>( ) ) { }
			~c_skeleton( ) { bones.clear( ); }

			std::vector<c_bone_info> bones;
		};

		struct c_actor_flags {
		public:
			c_actor_flags( ) : is_on_screen( false ) { }
			~c_actor_flags( ) = default;

			bool is_on_screen : 1;
		};

		class c_actor {
		public:
			c_actor( ) : game_object( nullptr ), transform( nullptr ), player( 0 ), player_body( nullptr ), transforms( nullptr ), origin_position( math::vector3( ) ) { };
			~c_actor( ) = default;

			unity::c_game_object* game_object;
			unity::c_transform* transform;

			std::uint64_t player;
			sdk::c_player_body* player_body;

			unity::list<unity::c_transform*>* transforms;

			int distance;
			math::vector3 origin_position;

			c_skeleton skeleton;
			c_actor_flags flags;
		};

		class c_entity {
		public:
			c_entity( ) = default;
			~c_entity( ) = default;

		};
	}
}


#endif // !OBJECTS_HPP