#pragma once

namespace unity {
	
	template <typename T>
	struct c_dynamic_array {
		T data;
		uint64_t label;
		size_t size;
		size_t capacity;
	};

	template <typename T>
	class list : public sdk::c_base_class {
	public:
		declare_member( T, _items, 0x10 );
		declare_member( std::uint32_t, _size, 0x18 );

	public:
		inline T get( const T& _items, std::uint32_t index ) {
			return g_vm->read<T>( reinterpret_cast< std::uint64_t >( _items ) + 0x20 + ( index * 0x8 ) );
		}
	};

	template <typename T>
	class array : public sdk::c_base_class {
	public:
		declare_member( std::uint32_t, size, 0x18 );

	public:
		inline T get( std::uint32_t index ) {
			return g_vm->read<T>( current_address + 0x20 + ( index * 0x8 ) );
		}
	};

	template<typename T>
	class buffer_list : public sdk::c_base_class {
	public:
		declare_member( std::uint64_t, buffer, 0x10 );
		declare_member( std::uint32_t, count, 0x18 );

	public:
		inline T get( const std::uint64_t& buffer, std::uint32_t index ) {
			return g_vm->read<T>( buffer + 0x20 + ( index * 0x8 ) );
		}
	};

	class float_buff : public sdk::c_base_class {
	public:
		inline void set( float value ) {
			g_vm->write<float>( current_address + 0x30, value );
		}
	};

	class string : public sdk::c_base_class {
	public:
		static constexpr int max_len = 1024;

		declare_member( int, _stringLength, 0x10 );
		apply_member( int, _stringLength, 0x10 );

		declare_member( char, _firstChar, 0x14 );

		inline std::string get( ) {
			if ( !memory::is_valid( current_address ) )
				return { };

			const auto len = _stringLength( );
			if ( len <= 0 || len > max_len )
				return { };

			std::wstring buffer( len, L'\0' );
			g_vm->read_physical( current_address + 0x14, buffer.data( ), buffer.size( ) * sizeof( wchar_t ), false );

			return std::string( buffer.begin( ), buffer.end( ) );
		}

		inline void set( const std::wstring& buffer ) {
			const auto len = buffer.length( );
			if ( len <= 0 || len > max_len )
				return;

			_stringLength( len );
			g_vm->write_physical( current_address + 0x14, ( std::uint8_t* ) buffer.c_str( ), len * sizeof( wchar_t ) );
		}
	};
}