#pragma once

namespace unity {

	struct TransformData
	{
		std::uint64_t pTransformArray;
		char pad [ 0x20 ]; // 0x68 - 0x40
		std::uint64_t pTransformIndices;
	};

	struct TransformAccessReadOnly
	{
		std::uint64_t pTransformData; // 0x0
		std::int32_t index; // 0x8
	};

	struct Matrix34
	{
		math::quaternion vec0;
		math::quaternion vec1;
		math::quaternion vec2;
	};

	class c_transform : public c_object {
	public:
		// 45 0F 58 0C C0 41 8B 04 89 85 C0 0F 89 ? ? ? ? 44 0F 28 64 24
		static inline math::vector3 get_position( std::uint64_t native_transform_pointer )
		{
			static const __m128 mulVec0 = { -2.000, 2.000, -2.000, 0.000 };
			static const __m128 mulVec1 = { 2.000, -2.000, -2.000, 0.000 };
			static const __m128 mulVec2 = { -2.000, -2.000, 2.000, 0.000 };

			TransformAccessReadOnly sTransformAccessReadOnly = g_vm->read<TransformAccessReadOnly>( native_transform_pointer + 0x88 );
			if ( !sTransformAccessReadOnly.pTransformData )
				return { };

			// sTransformData = *( _QWORD* ) ( sTransformAccessReadOnly.m128i_i64 [ 0 ] + 0x40 );
			// pTransformIndices = *( _QWORD* ) ( sTransformAccessReadOnly.m128i_i64 [ 0 ] + 0x68 );

			TransformData sTransformData = g_vm->read<TransformData>( sTransformAccessReadOnly.pTransformData + 0x40 );
			if ( !sTransformData.pTransformArray || !sTransformData.pTransformIndices )
				return { };

			int index = g_vm->read<int>( sTransformData.pTransformIndices + 0x4 * sTransformAccessReadOnly.index );
			__m128 result = g_vm->read<__m128>( sTransformData.pTransformArray + 0x30 * sTransformAccessReadOnly.index );

			int itterations_done = 0;

			while ( index >= 0 && ++itterations_done < 200 )
			{
				Matrix34 sMatrix34 = g_vm->read<Matrix34>( sTransformData.pTransformArray + 0x30 * index );

				__m128 xxxx = _mm_castsi128_ps( _mm_shuffle_epi32( *( __m128i* )( &sMatrix34.vec1 ), 0x00 ) );    // xxxx
				__m128 yyyy = _mm_castsi128_ps( _mm_shuffle_epi32( *( __m128i* )( &sMatrix34.vec1 ), 0x55 ) );    // yyyy
				__m128 zwxy = _mm_castsi128_ps( _mm_shuffle_epi32( *( __m128i* )( &sMatrix34.vec1 ), 0x8E ) );    // zwxy
				__m128 wzyw = _mm_castsi128_ps( _mm_shuffle_epi32( *( __m128i* )( &sMatrix34.vec1 ), 0xDB ) );    // wzyw
				__m128 zzzz = _mm_castsi128_ps( _mm_shuffle_epi32( *( __m128i* )( &sMatrix34.vec1 ), 0xAA ) );    // zzzz
				__m128 yxwy = _mm_castsi128_ps( _mm_shuffle_epi32( *( __m128i* )( &sMatrix34.vec1 ), 0x71 ) );    // yxwy
				__m128 tmp7 = _mm_mul_ps( *( __m128* )( &sMatrix34.vec2 ), result );

				result = _mm_add_ps(
					_mm_add_ps(
						_mm_add_ps(
							_mm_mul_ps(
								_mm_sub_ps(
									_mm_mul_ps( _mm_mul_ps( xxxx, mulVec1 ), zwxy ),
									_mm_mul_ps( _mm_mul_ps( yyyy, mulVec2 ), wzyw ) ),
								_mm_castsi128_ps( _mm_shuffle_epi32( _mm_castps_si128( tmp7 ), 0xAA ) ) ),
							_mm_mul_ps(
								_mm_sub_ps(
									_mm_mul_ps( _mm_mul_ps( zzzz, mulVec2 ), wzyw ),
									_mm_mul_ps( _mm_mul_ps( xxxx, mulVec0 ), yxwy ) ),
								_mm_castsi128_ps( _mm_shuffle_epi32( _mm_castps_si128( tmp7 ), 0x55 ) ) ) ),
						_mm_add_ps(
							_mm_mul_ps(
								_mm_sub_ps(
									_mm_mul_ps( _mm_mul_ps( yyyy, mulVec0 ), yxwy ),
									_mm_mul_ps( _mm_mul_ps( zzzz, mulVec1 ), zwxy ) ),
								_mm_castsi128_ps( _mm_shuffle_epi32( _mm_castps_si128( tmp7 ), 0x00 ) ) ),
							tmp7 ) ), *( __m128* )( &sMatrix34.vec0 ) );

				index = g_vm->read<int>( sTransformData.pTransformIndices + 0x4 * index );
			}

			return math::vector3( result.m128_f32 [ 0 ], result.m128_f32 [ 1 ], result.m128_f32 [ 2 ] );
		}
	};
}