#pragma once

namespace sdk {

	inline std::vector<enums::e_bone_ids> bones = {
		enums::e_bone_ids::head,
		enums::e_bone_ids::neck,
		enums::e_bone_ids::spine_1,
		enums::e_bone_ids::pelvis,

		// left foot
		enums::e_bone_ids::l_thigh_1,
		enums::e_bone_ids::l_calf,
		enums::e_bone_ids::l_foot,

		// right foot
		enums::e_bone_ids::r_thigh_1,
		enums::e_bone_ids::r_calf,
		enums::e_bone_ids::r_foot,

		// left hand
		enums::e_bone_ids::l_upperarm,
		enums::e_bone_ids::l_forearm_1,
		enums::e_bone_ids::l_forearm_2,

		// right hand
		enums::e_bone_ids::r_upperarm,
		enums::e_bone_ids::r_forearm_1,
		enums::e_bone_ids::r_forearm_2,
	};

	inline std::vector<std::pair<enums::e_bone_ids, enums::e_bone_ids > > bone_connections = {
		{ enums::e_bone_ids::head, enums::e_bone_ids::neck },
		{ enums::e_bone_ids::neck, enums::e_bone_ids::spine_1 },
		{ enums::e_bone_ids::spine_1, enums::e_bone_ids::pelvis },

		// left foot
		{ enums::e_bone_ids::pelvis, enums::e_bone_ids::l_thigh_1 },
		{ enums::e_bone_ids::l_thigh_1, enums::e_bone_ids::l_calf },
		{ enums::e_bone_ids::l_calf, enums::e_bone_ids::l_foot },

		// right foot
		{ enums::e_bone_ids::pelvis, enums::e_bone_ids::r_thigh_1 },
		{ enums::e_bone_ids::r_thigh_1, enums::e_bone_ids::r_calf },
		{ enums::e_bone_ids::r_calf, enums::e_bone_ids::r_foot },

		// left hand
		{ enums::e_bone_ids::neck, enums::e_bone_ids::l_upperarm },
		{ enums::e_bone_ids::l_upperarm, enums::e_bone_ids::r_forearm_1 },
		{ enums::e_bone_ids::l_forearm_1, enums::e_bone_ids::l_forearm_2 },

		// right hand
		{ enums::e_bone_ids::neck, enums::e_bone_ids::r_upperarm },
		{ enums::e_bone_ids::r_upperarm, enums::e_bone_ids::l_forearm_1 },
		{ enums::e_bone_ids::r_forearm_1, enums::e_bone_ids::r_forearm_2 },
	};

	class c_skeleton : public unity::c_mono_behaviour {
	public:
		declare_member( unity::list<unity::c_transform*>*, _values, 0x30 );
	};
}