﻿#pragma once

namespace unity {

	class c_game_object;

	template<typename T>
	struct c_scripting_object
	{
		void* vtable;
		char pad_1 [ 0x36 ];
		T managed; // Object_ScriptingPtr or aka. Managed PTR which points back to IL2Cpp managed object
		c_game_object* game_object;
	};

	template<typename T>
	struct scripting_object_info
	{
		T address;
		int index;
		c_scripting_object<T> object;
	};

	//struct NativeGameObject
	//	│
	//	├── 0x00 vtable
	//	├── ...
	//	├── 0x40 Component list pointer
	//	├── 0x40 Component list count
	//	├── 0x54 Tag
	//	├── ...
	//	├── 0x60 Name pointer

	enum scripting_objects : std::uint32_t {
		transform = 0,
		game_world = 1,
	};

	class c_game_object : public il2cpp::c_object {
	public:

		// 48 8B 41 ? 49 C1 E0 ? 4C 03 41 (QueryComponent)
		template <typename T>
		declare_member( c_dynamic_array<T>, components, 0x58 );

		// this changes often
		declare_member( std::uint64_t, name_ptr, 0x88 );

	public:
		template<typename T>
		inline scripting_object_info<T> get_scripting_object( const std::string&& name )
		{
			const auto array = components<std::uint64_t>( );
			if ( !array.data )
				return { };

			const auto size = array.size;
			if ( !size || size > 4000 || size <= 0 )
				return { };

			for ( int index = 0; index < size; index++ )
			{
				const auto scripting_object_pointer = g_vm->read<sdk::c_base_class*>( array.data + ( 0x10 * index + 0x8 ) );
				if ( !scripting_object_pointer->is_valid( ) )
					continue;

				const auto scripting_object = g_vm->read<c_scripting_object<T>>( scripting_object_pointer->get_current_class( ) );

				const auto managed = scripting_object.managed;
				if ( !managed->is_valid( ) )
					continue;

				const auto klass_name = managed->klass( )->get_name( );
				if ( klass_name.empty( ) )
					continue;

				if ( klass_name == name )
				{
					scripting_object_info<T> out = { };

					out.address = scripting_object_pointer->cast<T>( );
					out.index = index;
					out.object = g_vm->read<c_scripting_object<T>>( scripting_object_pointer->get_current_class( ) );

					return out;
				}
			}

			return { };
		}

		template<typename T>
		inline scripting_object_info<T> get_scripting_object( const std::uint32_t&& index )
		{
			const auto array = components<std::uint64_t>( );
			if ( !array.data )
				return { };

			if ( index > array.size )
				return { };

			const auto scripting_object_pointer = g_vm->read<sdk::c_base_class*>( array.data + ( 0x10 * index + 0x8 ) );
			if ( !scripting_object_pointer->is_valid( ) )
				return { };

			scripting_object_info<T> out = { };

			out.address = scripting_object_pointer->cast<T>( );
			out.object = g_vm->read<c_scripting_object<T>>( scripting_object_pointer->get_current_class( ) );

			return out;
		}

		template <typename T>
		inline T get_component( const std::string&& name )
		{
			const auto array = components<std::uint64_t>( );
			if ( !array.data )
				return T( );

			const auto size = array.size;
			if ( !size || size > 4000 || size <= 0 )
				return T( );

			for ( int index = 0; index < size; index++ )
			{
				const auto scripting_object_pointer = g_vm->read<sdk::c_base_class*>( array.data + ( 0x10 * index + 0x8 ) );
				if ( !scripting_object_pointer->is_valid( ) )
					continue;

				const auto scripting_object = g_vm->read<c_scripting_object<T>>( scripting_object_pointer->get_current_class( ) );

				const auto managed = scripting_object.managed;
				if ( !managed->is_valid( ) )
					continue;

				const auto klass_name = managed->klass( )->get_name( );
				if ( klass_name.empty( ) )
					continue;

				if ( klass_name == name )
					return managed;
			}

			return T( );
		}

		template <typename T>
		inline T get_component( const std::uint32_t&& index )
		{
			const auto array = components<std::uint64_t>( );
			if ( !array.data )
				return T( );

			if ( index > array.size )
				return T( );

			const auto scripting_object_pointer = g_vm->read<sdk::c_base_class*>( array.data + ( 0x10 * index + 0x8 ) );
			if ( !scripting_object_pointer->is_valid( ) )
				return T( );

			return g_vm->read<c_scripting_object<T>>( scripting_object_pointer->get_current_class( ) ).managed;
		}

		inline std::string get_name( )
		{
			return g_vm->read_string( name_ptr( ) );
		}
	};
}