#pragma once

namespace sdk {

	struct c_matrix {
		union {
			struct {
				float _11, _12, _13, _14;
				float _21, _22, _23, _24;
				float _31, _32, _33, _34;
				float _41, _42, _43, _44;
			};
			float m [ 4 ][ 4 ];
		};
	};

	class c_fps_camera : public unity::c_behaviour {
	public:
		// Camera::ScreenToWorldPoint
		// Screen position out of view frustum (screen pos %f, %f, %f) (Camera rect %d %d %d %d)
		declare_member( c_matrix, view_matrix, 0x128 );

		// Camera::UpdateVelocity
		// 0F 14 C4 89 83
		declare_member( math::vector3, position, 0x47C );

		// Camera::CalculateGateFitParams find the JMP to Camera_Set_Custom_PropAspect usually 1st
		// F3 0F 11 83 ? ? ? ? C6 83 ? ? ? ? ? 48 83 C4
		declare_member( float, aspect_ratio, 0x518 );
		apply_member( float, aspect_ratio, 0x518 );

		apply_member( WORD, ukn_aspect, 0x538 );
		apply_member( BYTE, ukn_aspect_1, 0x54A );

		inline void set_aspect_ratio( float value ) 
		{
			aspect_ratio( value );
			ukn_aspect( 257 );
			ukn_aspect_1( 1 );
		}

		inline bool in_screen( const math::vector2& position )
		{
			return position.x < unity::c_screen::width( ) && position.y < unity::c_screen::height( );
		}

		inline bool world_to_screen( const math::vector3& world, math::vector2* screen_out, const c_matrix& matrix )
		{
			const auto trans_vec = math::vector3( matrix._14, matrix._24, matrix._34 );
			const auto right_vec = math::vector3( matrix._11, matrix._21, matrix._31 );
			const auto up_vec = math::vector3( matrix._12, matrix._22, matrix._32 );

			const auto w = trans_vec.dot( world ) + matrix._44;
			if ( w < 0.5f )
				return false;

			const auto x = right_vec.dot( world ) + matrix._41;
			const auto y = up_vec.dot( world ) + matrix._42;

			*screen_out = math::vector2
			(
				( unity::c_screen::width_center( ) ) * ( 1.00f + x / w ),
				( unity::c_screen::height_center( ) ) * ( 1 - y / w )
			);

			return true;
		}
	};

	inline c_fps_camera* camera = { };
}