#pragma once

namespace sdk {

	class c_base_class {
	public:
		inline static bool is_class( std::string class_name, std::string name ) {
			return class_name == name;
		}

		inline static bool is_prefab( std::string prefab_name, std::string prefab ) {
			return prefab_name == prefab;
		}

		inline std::uint64_t get_current_class( ) const {
			return current_address;
		}

		inline bool is_valid( ) const {
			const auto ptr = reinterpret_cast< __int64 >( this );
			if ( ( ptr < 0xFFFFFFFFFF ) || ( ptr > 0x2FFFFFFFFFF ) || !memory::is_valid( ptr ) )
				return false;
			return true;
		}

		template <typename T>
		inline T cast( ) {
			return reinterpret_cast< T >( current_address );
		}
	};
}