#pragma once

class NotifyManager {
public:
    enum notify_status {
        notify_success,
        notify_error,
        notify_info,
        notify_base
    };

    enum notify_style {
        style_centered, 
        style_right,   
    };

    struct c_notify {
        std::string title;
        std::string message;
        const char* icon;

        c_color color;
        notify_style style;

        float duration = 3.f;
        float time = 0.f;
        ImVec2 pos { 0, 0 };
        float fade_time = 0.25f;
    };

    std::vector< c_notify > notifications;

    void erase_notifies( ) {
        notifications.erase(
            std::remove_if( notifications.begin( ), notifications.end( ), [ ] ( const c_notify& n ) {
                return n.time >= n.duration;
                } ),
            notifications.end( )
        );
    }

    void add( const std::string& title, const std::string& message, const char* icon, c_color color, notify_style style = style_right, float duration = 3.f ) {
        notifications.emplace_back( c_notify { title, message, icon, color, style, duration } );
    }

    void draw( ) {
        auto draw_list = GetBackgroundDrawList( );

        float offset = 0.f;
        for ( int i = 0; i < notifications.size( ); ++i ) {
            auto& n = notifications [ i ];
            float alpha = n.time <= n.fade_time ? n.time / n.fade_time : n.time >= n.duration - n.fade_time ? ( n.duration - n.time ) / n.fade_time : 1.f;

            n.color.a = alpha;

            ImVec2 size { ImMax( CalcTextSize( LangManager::get( ).translate( n.message ).c_str( ) ).x, CalcTextSize( LangManager::get( ).translate( n.title ).c_str( ) ).x + 24 ) + 28, GImGui->FontSize * 2 + 38 };

            if ( n.style == style_centered ) {
                if ( n.pos.x == 0 )
                    n.pos = ImVec2 { GetIO( ).DisplaySize.x / 2 - size.x / 2, GetIO( ).DisplaySize.y - 20 - offset - size.y };
                n.pos.y = ImLerp( n.pos.y, GetIO( ).DisplaySize.y - 20 - offset - size.y, GetIO( ).DeltaTime * 14 );

                draw_list->AddRectFilled( { n.pos.x + size.x / 2 - size.x / 2 * alpha, n.pos.y }, { n.pos.x + size.x / 2 + size.x / 2 * alpha, n.pos.y + size.y }, GetColorU32( ImGuiCol_WindowBg, alpha * 0.9f ) );

                draw_list->AddRectFilled( { n.pos.x + size.x / 2 - size.x / 2 * alpha, n.pos.y }, { n.pos.x + size.x / 2 - size.x / 2 * alpha + 1, n.pos.y + size.y }, n.color.to_im_color( ) );
                draw_list->AddRectFilled( { n.pos.x + size.x / 2 + size.x / 2 * alpha - 1, n.pos.y }, { n.pos.x + size.x / 2 + size.x / 2 * alpha, n.pos.y + size.y }, n.color.to_im_color( ) );
            }
            else {
                if ( n.pos.x == 0 ) n.pos = GetIO( ).DisplaySize - ImVec2 { 0, 20 + offset + size.y };

                n.pos.x = ImLerp( n.pos.x, GetIO( ).DisplaySize.x - 20 - size.x, GetIO( ).DeltaTime * 14 );
                n.pos.y = ImLerp( n.pos.y, GetIO( ).DisplaySize.y - 20 - offset - size.y, GetIO( ).DeltaTime * 14 );

                draw_list->AddRectFilled( n.pos, n.pos + size, GetColorU32( ImGuiCol_WindowBg, alpha ), 3 );
            }

            draw_list->AddText( fonts [ icons ].get( 14 ), 14, n.pos + ImVec2 { 14, 14 }, n.color.to_im_color( ), n.icon );
            draw_list->AddText( n.pos + ImVec2 { 38, 14 }, GetColorU32( ImGuiCol_Text, alpha ), LangManager::get( ).translate( n.title ).c_str( ) );
            draw_list->AddText( n.pos + ImVec2 { 14, 24 + GImGui->FontSize }, GetColorU32( ImGuiCol_TextDisabled, alpha ), LangManager::get( ).translate( n.message ).c_str( ) );

            n.time += 1.f / GetIO( ).Framerate;
            offset += size.y + 12;
        }

        erase_notifies( );
    }

    static NotifyManager& get( ) {
        static NotifyManager s {};
        return s;
    }
};