#pragma once

enum class FontType
{
	File,
	Memory
};

struct FontDefinition
{
	FontDefinition( unsigned char* data, size_t size, std::vector<float> sizes, const ImWchar* ranges, ImFontConfig config ) : type( FontType::Memory ), data( data ), size( size ), sizes( sizes ), ranges( ranges ), config( config ) { };
	FontDefinition( const char* name, std::vector<float> sizes, const ImWchar* ranges, ImFontConfig config ) : name( name ), type( FontType::File ), data( 0 ), size( 0 ), sizes( sizes ), ranges( ranges ), config( config ) { };

	FontType type;
	const char* name;
	unsigned char* data;
	size_t size;
	std::vector<float> sizes;
	const ImWchar* ranges;
	ImFontConfig config;
};

struct Font {
	std::vector< ImFont* > fonts;

	void setup( const std::vector<FontDefinition>& im_fonts ) {
		for ( int index = 0; index < im_fonts.size( ); ++index ) {
			const auto& font = im_fonts [ index ];

			if ( font.config.MergeMode )
				continue;

			for ( const auto& size : font.sizes ) {

				ImFont* base = ( font.type == FontType::Memory ) ? ImGui::GetIO( ).Fonts->AddFontFromMemoryTTF( font.data, font.size, size, &font.config, font.ranges )
					: ImGui::GetIO( ).Fonts->AddFontFromFileTTF( font.name, size, &font.config, font.ranges );

				const int next_index = index + 1;

				if ( next_index < im_fonts.size( ) && im_fonts [ next_index ].config.MergeMode ) {
					const auto& merge_font = im_fonts [ next_index ];

					if ( merge_font.type == FontType::Memory )
						ImGui::GetIO( ).Fonts->AddFontFromMemoryTTF( merge_font.data, merge_font.size, size, &merge_font.config, merge_font.ranges );
					else
						ImGui::GetIO( ).Fonts->AddFontFromFileTTF( merge_font.name, size, &merge_font.config, merge_font.ranges );
				}

				fonts.push_back( base );
			}
		}
	}

	ImFont* get( float size ) {
		auto it = std::find_if( fonts.begin( ), fonts.end( ), [ & ] ( const ImFont* a ) {
			return a->LegacySize == size;
			} );

		if ( it == fonts.end( ) ) {
			return nullptr;
		}

		return *it;
	}
};

class FontManager {
	std::vector< Font > fonts;
public:
	static FontManager& get( ) {
		static FontManager s { };
		return s;
	}

	auto& get_fonts( ) {
		return fonts;
	}
};

enum fonts {
	font,
	icons,
	visuals,
	fonts_size
};

static std::vector< Font >& fonts = FontManager::get( ).get_fonts( );