#ifndef TEXTURES_HPP
#define TEXTURES_HPP

namespace textures_interface {

	class c_textures {
	private:
		std::unordered_map<std::string, ID3D11Texture2D*> textures_from_file = { };
		std::unordered_map<std::string, ID3D11Texture2D*> textures_from_memory = { };

	public:
		c_textures( ) = default;
		~c_textures( ) = default;

		ID3D11Texture2D* create_texture_from_file( ID3D11Device* device, const fs::path& path );
		ID3D11Texture2D* create_texture_from_memory( ID3D11Device* device, const LPCVOID& data, UINT data_size );

		ID3D11Texture2D* get_texture_from_file( const std::string& name, const fs::path& default_path = fs::path( ) );
		ID3D11Texture2D* get_texture_from_memory( const std::string& shortname, const LPCVOID& data, UINT data_size );
	};

} inline auto textures = std::make_shared<textures_interface::c_textures>( );

#endif // !TEXTURES_HPP