#ifndef TEXTURES_CPP
#define TEXTURES_CPP

#include <impl/includes.hpp>

auto textures_interface::c_textures::create_texture_from_file( ID3D11Device* device, const fs::path& path ) -> ID3D11Texture2D*
{
	ID3D11Texture2D* texture = { };

	HRESULT result = D3DX11CreateShaderResourceViewFromFileA( device, path.string( ).c_str( ), nullptr, nullptr, ( ID3D11ShaderResourceView** ) &texture, nullptr );
	if ( FAILED( result ) )
		return nullptr;

	return texture;
}

auto textures_interface::c_textures::create_texture_from_memory( ID3D11Device* device, const LPCVOID& data, UINT data_size ) -> ID3D11Texture2D*
{
	ID3D11Texture2D* texture = { };

	HRESULT result = D3DX11CreateShaderResourceViewFromMemory( device, data, data_size, nullptr, nullptr, ( ID3D11ShaderResourceView** ) &texture, nullptr );
	if ( FAILED( result ) )
		return nullptr;

	return texture;
}

auto textures_interface::c_textures::get_texture_from_file( const std::string& name, const fs::path& default_path ) -> ID3D11Texture2D*
{
	if ( textures_from_file.find( name ) != textures_from_file.end( ) )
		return textures_from_file [ name ];

	fs::path item_image_path = default_path / ( name + HASH_STR( ".png" ) );
	if ( !fs::exists( item_image_path ) )
		return nullptr;

	ID3D11Texture2D* texture = create_texture_from_file( g_render->g_pd3dDevice, item_image_path );
	if ( !texture )
		return nullptr;

	textures_from_file.emplace( name, texture );

	return texture;
}

auto textures_interface::c_textures::get_texture_from_memory( const std::string& shortname, const LPCVOID& data, UINT data_size ) -> ID3D11Texture2D*
{
	if ( textures_from_memory.find( shortname ) != textures_from_memory.end( ) )
		return textures_from_memory [ shortname ];

	ID3D11Texture2D* texture = create_texture_from_memory( g_render->g_pd3dDevice, data, data_size );
	if ( !texture )
		return nullptr;

	textures_from_memory.emplace( shortname, texture );

	return texture;
}

#endif // !TEXTURES_CPP