#ifndef FRAMEWORK_HPP
#define FRAMEWORK_HPP

namespace framework {

	class c_framework {
	public:
		c_framework( ) = default;
		~c_framework( ) = default;

	public:
		void draw_line( ImVec2 x1, ImVec2 y2, const c_color& color, float thickness = 1.00f, bool outline = false );
		void dashed_line( const ImVec2& start, const ImVec2& end, const c_color& color, float thickness = 1.00f, float dash_length = 2.00f, bool outline = false );
		void dotted_line( const ImVec2& start, const ImVec2& end, const c_color& color, float thickness = 1.00f, float dot_spacing = 2.00f, bool outline = false );

		void draw_rect( const ImVec2& position, const ImVec2& size, const c_color& color, float rounding = 0.f, float thickness = 1.f, bool outline = false );
		void draw_filled_rect( const ImVec2& position, const ImVec2& size, const c_color& color, float rounding = 0.f );
		void draw_filled_multi_color_rect( const ImVec2& position, const ImVec2& size, const c_color& color_top_left, const c_color& color_top_right, const c_color& color_bottom_left, const c_color& color_bottom_right );

		void draw_box( const ImVec2& bottom_left, const ImVec2& bottom_right, const ImVec2& top_left, const ImVec2& top_right, float thickness, const c_color& color, const c_color& fill );
		void draw_corner_box( const ImVec2& bottom_left, const ImVec2& bottom_right, const ImVec2& top_left, const ImVec2& top_right, float thickness, const c_color& color, const c_color& fill );
		void draw_3d_box( const std::vector<math::vector2>& points, float thickness, const c_color& color );

		void draw_triangle( ImVec2 x_point, ImVec2 y_point, ImVec2 z_point, const c_color& color, bool outline = false, const c_color& outline_color = c_color::black( ), bool fill = false, float stroke = 1.00f );
		void draw_circle( float x, float y, float radius, const c_color& color, float stroke, bool filled = false, bool outline = false );

		void text( const std::string& input, const ImVec2& position, const c_color& color, float size, ImFont* font, bool outline = true );
		void add_image( ID3D11Texture2D* texture, const ImVec2& position, const ImVec2& size, const c_color& color = c_color::white( ), ImVec2 uv0 = ImVec2( 0, 0 ), ImVec2 uv1 = ImVec2( 1, 1 ) );
	};

} inline const auto g_framework = std::make_shared<framework::c_framework>( );

#endif // ! guard