﻿#ifndef FRAMEWORK_CPP
#define FRAMEWORK_CPP

#include <impl/includes.hpp>

void framework::c_framework::draw_line( ImVec2 x1, ImVec2 y2, const c_color& color, float thickness, bool outline ) {
	if ( outline ) {
		ImGui::GetBackgroundDrawList( )->AddLine( x1, y2, c_color::custom( 0.00f, 0.00f, 0.00f, color [3 ] ).to_im_color( ), thickness + 1.5f );
	}

	ImGui::GetBackgroundDrawList( )->AddLine( x1, y2, color.to_im_color( ), thickness );
}

void framework::c_framework::dashed_line( const ImVec2& start, const ImVec2& end, const c_color& color, float thickness, float dash_length, bool outline ) {
	float distance = std::hypot( end.x - start.x, end.y - start.y );
	ImVec2 direction = ImVec2( ( end.x - start.x ) / distance, ( end.y - start.y ) / distance );

	for ( float i = 0.0f; i < distance; i += dash_length * 2 ) {
		ImVec2 segment_start = ImVec2( start.x + direction.x * i, start.y + direction.y * i );
		ImVec2 segment_end = ImVec2( start.x + direction.x * std::min( i + dash_length, distance ),
			start.y + direction.y * std::min( i + dash_length, distance ) );

		draw_line( segment_start, segment_end, color, thickness, outline );
	}
}

void framework::c_framework::dotted_line( const ImVec2& start, const ImVec2& end, const c_color& color, float thickness, float dot_spacing, bool outline ) {
	float distance = std::hypot( end.x - start.x, end.y - start.y );
	ImVec2 direction = ImVec2( ( end.x - start.x ) / distance, ( end.y - start.y ) / distance );

	for ( float i = 0.0f; i < distance; i += dot_spacing ) {
		ImVec2 dot_position = ImVec2( start.x + direction.x * i, start.y + direction.y * i );

		draw_circle( dot_position.x, dot_position.y, thickness * 0.5f, color, 0.00f, true, outline );
	}
}

void framework::c_framework::draw_rect( const ImVec2& position, const ImVec2& size, const c_color& color, float rounding, float thickness, bool outline ) {
	if ( outline ) {
		ImGui::GetBackgroundDrawList( )->AddRect( position + ImVec2( 1.0f, 1.0f ), ImVec2( position.x + size.x, position.y + size.y ) - ImVec2( 1.0f, 1.0f ), c_color::custom( 0.00f, 0.00f, 0.00f, color [ 3 ] ).to_im_color( ), rounding, 0, thickness );
		ImGui::GetBackgroundDrawList( )->AddRect( position - ImVec2( 1.0f, 1.0f ), ImVec2( position.x + size.x, position.y + size.y ) + ImVec2( 1.0f, 1.0f ), c_color::custom( 0.00f, 0.00f, 0.00f, color [ 3 ] ).to_im_color( ), rounding, 0, thickness );
	}

	ImGui::GetBackgroundDrawList( )->AddRect( position, ImVec2( position.x + size.x, position.y + size.y ), color.to_im_color( ), rounding, 0, thickness );
}

void framework::c_framework::draw_filled_rect( const ImVec2& position, const ImVec2& size, const c_color& color, float rounding ) {
	ImGui::GetBackgroundDrawList( )->AddRectFilled( position, ImVec2( position.x + size.x, position.y + size.y ), color.to_im_color( ), rounding, 0 );
}

void framework::c_framework::draw_filled_multi_color_rect( const ImVec2& position, const ImVec2& size, const c_color& color_top_left, const c_color& color_top_right, const c_color& color_bottom_left, const c_color& color_bottom_right ) {
	ImGui::GetBackgroundDrawList( )->AddRectFilledMultiColor( position, ImVec2( position.x + size.x, position.y + size.y ), color_top_left.to_im_color( ), color_top_right.to_im_color( ), color_bottom_left.to_im_color( ), color_bottom_right.to_im_color( ) );
}

void framework::c_framework::draw_box( const ImVec2& bottom_left, const ImVec2& bottom_right, const ImVec2& top_left, const ImVec2& top_right, float thickness, const c_color& color, const c_color& fill )
{
	ImVec2 points [ 4 ] = {
		ImVec2( bottom_left.x, bottom_left.y ),
		ImVec2( bottom_right.x, bottom_right.y ),
		ImVec2( top_right.x, top_right.y ),
		ImVec2( top_left.x, top_left.y )
	};

	if ( g_vars->visuals.box_fill )
		ImGui::GetBackgroundDrawList( )->AddConvexPolyFilled( points, 4, fill.to_im_color( ) );

	if ( g_vars->visuals.box_outline ) 
	{
		constexpr auto offset = 1.00f;
		ImVec2 offsetPoints [ 4 ];

		offsetPoints [ 0 ] = ImVec2( points [ 0 ].x - offset, points [ 0 ].y - offset );
		offsetPoints [ 1 ] = ImVec2( points [ 1 ].x + offset, points [ 1 ].y - offset );
		offsetPoints [ 2 ] = ImVec2( points [ 2 ].x + offset, points [ 2 ].y + offset );
		offsetPoints [ 3 ] = ImVec2( points [ 3 ].x - offset, points [ 3 ].y + offset );

		ImGui::GetBackgroundDrawList( )->AddPolyline( offsetPoints, 4, c_color::custom( 0.00f, 0.00f, 0.00f, color [ 3 ] ).to_im_color( ), true, thickness );
	}

	ImGui::GetBackgroundDrawList( )->AddPolyline( points, 4, color.to_im_color( ), true, thickness );
}

void framework::c_framework::draw_corner_box( const ImVec2& bottom_left, const ImVec2& bottom_right, const ImVec2& top_left, const ImVec2& top_right, float thickness, const c_color& color, const c_color& fill )
{
	const auto horizontal_top = ImVec2( top_right.x - top_left.x, top_right.y - top_left.y );
	const auto horizontal_bottom = ImVec2( bottom_right.x - bottom_left.x, bottom_right.y - bottom_left.y );
	const auto vertical_left = ImVec2( bottom_left.x - top_left.x, bottom_left.y - top_left.y );
	const auto vertical_right = ImVec2( bottom_right.x - top_right.x, bottom_right.y - top_right.y );

	const float h_gap = 1.0f / g_vars->visuals.box_horizotanl_gap;
	const float v_gap = 1.0f / g_vars->visuals.box_vertical_gap;

	const ImVec2 h_offset_top = ImVec2( horizontal_top.x * h_gap, horizontal_top.y * h_gap );
	const ImVec2 h_offset_bottom = ImVec2( horizontal_bottom.x * h_gap, horizontal_bottom.y * h_gap );
	const ImVec2 v_offset_left = ImVec2( vertical_left.x * v_gap, vertical_left.y * v_gap );
	const ImVec2 v_offset_right = ImVec2( vertical_right.x * v_gap, vertical_right.y * v_gap );

	if ( g_vars->visuals.box_fill )
		ImGui::GetBackgroundDrawList( )->AddConvexPolyFilled( std::vector<ImVec2>{ bottom_left, bottom_right, top_right, top_left }.data( ), 4, fill.to_im_color( ) );

	draw_line( top_left, top_left + v_offset_left, color, thickness, g_vars->visuals.box_outline );
	draw_line( top_left, top_left + h_offset_top, color, thickness, g_vars->visuals.box_outline );

	draw_line( top_right, top_right + v_offset_right, color, thickness, g_vars->visuals.box_outline );
	draw_line( top_right, top_right - h_offset_top, color, thickness, g_vars->visuals.box_outline );

	draw_line( bottom_left, bottom_left - v_offset_left, color, thickness, g_vars->visuals.box_outline );
	draw_line( bottom_left, bottom_left + h_offset_bottom, color, thickness, g_vars->visuals.box_outline );

	draw_line( bottom_right, bottom_right - v_offset_right, color, thickness, g_vars->visuals.box_outline );
	draw_line( bottom_right, bottom_right - h_offset_bottom, color, thickness, g_vars->visuals.box_outline );
}

void framework::c_framework::draw_3d_box( const std::vector<math::vector2>& points, float thickness, const c_color& color )
{
	if ( points.size( ) < 8 )
		return;

	// Back Face
	draw_line( ImVec2( points [ 0 ].x, points [ 0 ].y ), ImVec2( points [ 1 ].x, points [ 1 ].y ), color, thickness ); // top left to top right
	draw_line( ImVec2( points [ 1 ].x, points [ 1 ].y ), ImVec2( points [ 2 ].x, points [ 2 ].y ), color, thickness ); // top right to bottom right
	draw_line( ImVec2( points [ 2 ].x, points [ 2 ].y ), ImVec2( points [ 3 ].x, points [ 3 ].y ), color, thickness ); // bottom right to bottom left
	draw_line( ImVec2( points [ 3 ].x, points [ 3 ].y ), ImVec2( points [ 0 ].x, points [ 0 ].y ), color, thickness ); // bottom left to top left

	// Front Face  
	draw_line( ImVec2( points [ 4 ].x, points [ 4 ].y ), ImVec2( points [ 5 ].x, points [ 5 ].y ), color, thickness ); // bottom left to bottom right
	draw_line( ImVec2( points [ 5 ].x, points [ 5 ].y ), ImVec2( points [ 6 ].x, points [ 6 ].y ), color, thickness ); // bottom right to top right
	draw_line( ImVec2( points [ 6 ].x, points [ 6 ].y ), ImVec2( points [ 7 ].x, points [ 7 ].y ), color, thickness ); // top right to top left
	draw_line( ImVec2( points [ 7 ].x, points [ 7 ].y ), ImVec2( points [ 4 ].x, points [ 4 ].y ), color, thickness ); // top left to bottom left

	// Side lines
	draw_line( ImVec2( points [ 0 ].x, points [ 0 ].y ), ImVec2( points [ 4 ].x, points [ 4 ].y ), color, thickness ); // top left to bottom left
	draw_line( ImVec2( points [ 1 ].x, points [ 1 ].y ), ImVec2( points [ 5 ].x, points [ 5 ].y ), color, thickness ); // top right to bottom right
	draw_line( ImVec2( points [ 2 ].x, points [ 2 ].y ), ImVec2( points [ 6 ].x, points [ 6 ].y ), color, thickness ); // bottom right to top right
	draw_line( ImVec2( points [ 3 ].x, points [ 3 ].y ), ImVec2( points [ 7 ].x, points [ 7 ].y ), color, thickness ); // bottom left to top left
}

void framework::c_framework::draw_triangle( ImVec2 x_point, ImVec2 y_point, ImVec2 z_point, const c_color& color, bool outline, const c_color& outline_color, bool filed, float stroke )
{
	if ( outline )
		ImGui::GetBackgroundDrawList( )->AddTriangle( x_point, y_point, z_point, c_color::custom( outline_color [ 0 ], outline_color [ 1 ], outline_color [ 2 ], color [ 3 ] ).to_im_color( ), stroke + 1.f );

	if ( filed )
		ImGui::GetBackgroundDrawList( )->AddTriangleFilled( x_point, y_point, z_point, color.to_im_color( ) );
	else
		ImGui::GetBackgroundDrawList( )->AddTriangle( x_point, y_point, z_point, color.to_im_color( ), stroke );
}

void framework::c_framework::draw_circle( float x, float y, float radius, const c_color& color, float stroke, bool filled, bool outline )
{
	if ( outline )
		ImGui::GetBackgroundDrawList( )->AddCircle( ImVec2( x, y ), radius + stroke, c_color::custom( 0.00f, 0.00f, 0.00f, color [ 3 ] ).to_im_color( ), 100, stroke );

	if ( filled )
		ImGui::GetBackgroundDrawList( )->AddCircleFilled( ImVec2( x, y ), radius, color.to_im_color( ), 100 );
	else
		ImGui::GetBackgroundDrawList( )->AddCircle( ImVec2( x, y ), radius, color.to_im_color( ), 100, stroke );
}

void framework::c_framework::add_image( ID3D11Texture2D* texture, const ImVec2& position, const ImVec2& size, const c_color& color, ImVec2 uv0, ImVec2 uv1 )
{
	ImGui::GetBackgroundDrawList( )->AddImage( ( ImTextureID ) texture, position, ImVec2( position.x + size.x, position.y + size.y ), uv0, uv1, color.to_im_color( ) );
}

void framework::c_framework::text( const std::string& input, const ImVec2& position, const c_color& color, float size, ImFont* font, bool outline )
{
	const char* text = input.c_str( );

	if ( outline ) {
		ImVec2 offsets[ ] = {
			{ -1, -1 }, { -1,  1 },
			{  1, -1 }, {  1,  1 }
		};

		ImU32 outline_col = c_color::custom( 0.0f, 0.0f, 0.0f, color [ 3 ] ).to_im_color( );

		for ( const auto& offset : offsets ) {
			ImGui::GetBackgroundDrawList( )->AddText( font, size, ImVec2( position.x + offset.x, position.y + offset.y ), outline_col, text );
		}
	}

	ImGui::GetBackgroundDrawList( )->AddText( font, size, position, color.to_im_color( ), text );
}

#endif