#pragma once
#include <cstdint>
#include <corecrt_math.h>

class c_color {
protected:
	constexpr float to_value( int __value ) { return static_cast< float >( __value / 255.f ); }

	constexpr uint8_t to_value( float __value ) { return static_cast< uint8_t >( __value * 255.f ); }

public:
	c_color( ) : r( 1.f ), g( 1.f ), b( 1.f ), a( 1.f ) { };

	c_color( int red, int green, int blue, int alpha ) : r( to_value( red ) ), g( to_value( green ) ), b( to_value( blue ) ), a( to_value( alpha ) ) { };

	c_color( float red, float green, float blue, float alpha = 1.00f ) : r( red ), g( green ), b( blue ), a( alpha ) { };

	c_color( const c_color& color ) : r( color.r ), g( color.g ), b( color.b ), a( color.a ) { };

public:
	float* to_array( ) { return reinterpret_cast< float* >( this ); };
	const float* to_array( ) const { return reinterpret_cast< const float* >( this ); };
	const ImColor to_im_color( float alpha = 0.00f ) const { return ImColor( r, g, b, alpha == 0.00f ? a : alpha ); }

public:
	c_color& operator=( const c_color& color ) { r = color.r; g = color.g; b = color.b; a = color.a; return *this; }
	float operator[]( size_t index ) const { return to_array( ) [ index ]; };
	float& operator[]( size_t index ) { return to_array( ) [ index ]; };

public:
	const c_color mix( const c_color& c2, float factor ) const { return c_color( r + factor * ( c2.r - r ), g + factor * ( c2.g - g ), b + factor * ( c2.b - b ), a + factor * ( c2.a - a ) ); }
	const c_color get_rgb( float frequency = 2.00f );
	const c_color to_color_mode( enums::color_mode mode );

public:
	static auto transparent( ) -> c_color { return { 0.f, 0.f, 0.f, 0.f }; }
	static auto black( float alpha = 1.f ) -> c_color { return { 0.f, 0.f, 0.f, alpha }; }
	static auto white( float alpha = 1.f ) -> c_color { return { 1.f, 1.f, 1.f, alpha }; }
	static auto red( float alpha = 1.f ) -> c_color { return { 1.f, 0.f, 0.f, alpha }; }
	static auto green( float alpha = 1.f ) -> c_color { return { 0.f, 1.f, 0.f, alpha }; }
	static auto blue( float alpha = 1.f ) -> c_color { return { 0.f, 0.f, 1.f, alpha }; }
	static auto yellow( float alpha = 1.f ) -> c_color { return { 1.f, 1.f, 0.f, alpha }; }
	static auto orange( float alpha = 1.f ) -> c_color { return { 1.f, 0.5f, 0.f, alpha }; }
	static auto cyan( float alpha = 1.f ) -> c_color { return { 0.f, 0.5f, 1.f, alpha }; }
	static auto turquoise( float alpha = 1.f ) -> c_color { return { 0.f, 1.f, 1.f, alpha }; }
	static auto custom( float r, float g, float b, float alpha = 1.f ) -> c_color { return { r, g, b, alpha }; }
	static auto interpolate( float factor ) -> c_color { factor = ( factor < 0.0f ) ? 0.0f : ( factor > 1.0f ) ? 1.0f : factor; return c_color( 1.0f, 1.0f - factor, 1.0f - factor, 1.0f ); }
	static auto green_to_red( float factor ) -> c_color { const auto r = ( factor >= 0.50f ) ? 255.00f : static_cast< std::uint8_t >( 255.00f * factor / 0.50f ); const auto g = ( factor >= 0.50f ) ? static_cast< std::uint8_t >( 255.00f - 255.00f * ( factor - 0.50f ) / 0.50f ) : 255.00f; return c_color( r / 255.f, g / 255.f, 0.0f, 255.0f ); }

	static auto scheme( float alpha = 1.f ) -> c_color { return { 0.8f, 0.3f, 0.3f, alpha }; }

public:
	float r;
	float g;
	float b;
	float a;
};
