#ifndef COLORS_CPP
#define COLORS_CPP

#include <impl/includes.hpp>

auto c_color::get_rgb( float frequency ) -> const c_color
{
	const auto time_now = std::chrono::high_resolution_clock::now( );

	const auto duration = std::chrono::duration_cast< std::chrono::milliseconds >( time_now.time_since_epoch( ) ).count( ) / 1000.0f;

	int r = std::sin( frequency * duration + 0 ) * 127 + 128;
	int g = std::sin( frequency * duration + 2 ) * 127 + 128;
	int b = std::sin( frequency * duration + 4 ) * 127 + 128;

	return c_color( r / 255.f, g / 255.f, b / 255.f, a );
}

auto c_color::to_color_mode( enums::color_mode mode ) -> const c_color 
{
	switch ( mode ) {

	case enums::color_mode::normal:
		return c_color( r, g, b, a );
	case enums::color_mode::rgb:
		return get_rgb( g_vars->ui.rgb_speed );
	case enums::color_mode::pastel:
		return c_color( r * 0.8f + 0.2f, g * 0.8f + 0.2f, b * 0.8f + 0.2f, a );
	case enums::color_mode::d_pastel:
		return c_color( r * 0.6f + 0.4f, g * 0.6f + 0.4f, b * 0.6f + 0.4f, a );
	case enums::color_mode::saturated:
		return c_color( fmin( r * 1.5f, 1.0f ), fmin( g * 1.5f, 1.0f ), fmin( b * 1.5f, 1.0f ), a );
	default:
		return c_color( r, g, b, a );
	}

	return c_color( r, g, b, a );
}

#endif // !COLORS_CPP
