#ifndef MELON_HPP
#define MELON_HPP

namespace melon_interface {

	inline const std::string JWT_PRIVATE = HASH_STR( "hm7HtdH3tSM2Eoatb9WQQMxvhAXzIECxfqvbf6m4OHGzgOryotHLejV0UkKgfR0r" );

	enum jwt_request_code : std::uint32_t {
		missing_auth_header = 600,
		missing_bearer,
		jwt_verification_failure,
		authorized,
	};

	enum class setup_error_code {
		server_error,
		authorization_error,
		response_empty,
		bad_iv,
		bad_cipher,
		decryption_failure,
		setup_successful
	};

	class c_api {
	private:
		std::string issuer = HASH_STR( "melonapi" );
		std::string audience = HASH_STR( "rust" );

	private:
		std::string url = { };

	public:
		c_api( ) : url( HASH_STR( "https://melonapi.com/" ) ) { };
		~c_api( ) = default;

		[[nodiscard]] setup_error_code setup( ) const;
		void switch_debug_ctx( ) { url = HASH_STR( "http://localhost:8080/" ); }

		template<typename T>
		std::string create_token( T duration, std::string issuer, std::string audience ) const
		{
			return jwt::create( )
				.set_issuer( issuer )
				.set_audience( audience )
				.set_expires_in( std::chrono::seconds( duration ) )
				.sign( jwt::algorithm::hs256( JWT_PRIVATE ) );
		}

		template<typename T>
		T get_safe( const nlohmann::json& json, const char* key ) const
		{
			if ( json.contains( key ) )
				return json.at( key ).get<T>( );
			return T {};
		}

		void error_box( int error_code, bool exit = true ) const;
		void internal_log( const char* field, const std::string& file, const int& line, ... ) const;

		void console( const char* title );
	};

} inline auto api = std::make_shared<melon_interface::c_api>( );

#define log(field, ...) api->internal_log( field, HASH_STR(__FILE__), __LINE__, ##__VA_ARGS__)

#define log_with_code(field, code, ...) ( api->internal_log(field, HASH_STR(__FILE__), __LINE__, ##__VA_ARGS__ ), code)

#define log_bad(field, ...) ( api->internal_log(field, HASH_STR(__FILE__), __LINE__, ##__VA_ARGS__), false)
#define log_bad_exit(field, func, ...) ( api->internal_log(field, HASH_STR(__FILE__), __LINE__, ##__VA_ARGS__), (func), false)

#define log_return(field, ...) api->internal_log( field, HASH_STR(__FILE__), __LINE__, ##__VA_ARGS__)
#define log_return_exit(field, func, ...) ( api->internal_log( field, HASH_STR(__FILE__), __LINE__, ##__VA_ARGS__), ( func ) )

#endif // !MELON_HPP
