#ifndef MELON_CPP
#define MELON_CPP

#include <impl/includes.hpp>

auto melon_interface::c_api::console( const char* title ) -> void
{
    const auto console_handle = LI_FN( GetConsoleWindow ).safe_cached( )( );

    RECT r;
    LI_FN( GetWindowRect ).safe_cached( )( console_handle, &r );
    LI_FN( MoveWindow ).safe_cached( )( console_handle, r.left, r.top, 900, 650, TRUE );

    CONSOLE_FONT_INFOEX cfi;
    cfi.cbSize = sizeof( cfi );
    cfi.nFont = 0;
    cfi.dwFontSize.X = 0;
    cfi.dwFontSize.Y = 16;
    cfi.FontFamily = FF_DONTCARE;
    cfi.FontWeight = FW_NORMAL;
    std::wcscpy( cfi.FaceName, HASH_STR( L"Cascadia Code" ) );

    LI_FN( SetCurrentConsoleFontEx ).safe_cached( )( LI_FN( GetStdHandle ).safe_cached( )( STD_OUTPUT_HANDLE ), FALSE, &cfi );
    ::SetWindowPos( console_handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_DRAWFRAME | SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW );
    SetConsoleTitleA( title );
}

auto melon_interface::c_api::error_box( int error_code, bool exit ) const -> void
{
    std::ostringstream message;

    message << HASH_STR( "It seems we've run into some trouble on your machine.\n\n" )
        << HASH_STR( "Session ID: " ) << rand( ) << HASH_STR( "\n" )
        << HASH_STR( "Architecture: " ) << sizeof( void* ) * 8 << HASH_STR( "-bit\n" )
        << HASH_STR( "Code: 0x" ) << error_code << HASH_STR( "\n\n" )
        << HASH_STR( "Would you like to upload the crash log for support team to investigate?" );

    auto result = LI_FN( MessageBoxA ).safe_cached( )( nullptr, message.str( ).c_str( ), HASH_STR( "Rust" ), MB_ICONERROR | MB_YESNO );
    if ( exit )
        ExitProcess( 1 );
}

auto melon_interface::c_api::internal_log( const char* field, const std::string& file, const int& line, ... ) const -> void
{
    char buffer [ 1024 ];

    va_list args;
    va_start( args, field );
    vsnprintf( buffer, sizeof( buffer ), field, args );
    va_end( args );

    auto now = std::chrono::system_clock::now( );
    auto now_t = std::chrono::system_clock::to_time_t( now );

    std::tm now_tm;
    localtime_s( &now_tm, &now_t );

    size_t backslash_pos = file.find_last_of( '\\' );
    std::string trimmed = file.substr( backslash_pos + 1 );

    std::stringstream ss;
    ss << HASH_STR( "[" ) << std::put_time( &now_tm, HASH_STR( "%Y-%m-%d %H:%M" ) ) << HASH_STR( "] [" ) << trimmed << HASH_STR( ":" ) << line << HASH_STR( "] - " ) << buffer;

    printf( HASH_STR( "%s\n" ), ss.str( ).c_str( ) );
}

auto melon_interface::c_api::setup( ) const -> setup_error_code
{

    return setup_error_code::setup_successful;
}

#endif // !MELON_CPP
