#ifndef UTILITY_HPP
#define UTILITY_HPP

namespace utility {

    static NTSTATUS( __stdcall* NtDelayExecution )( BOOL Alertable, PLARGE_INTEGER DelayInterval ) = ( NTSTATUS( __stdcall* )( BOOL, PLARGE_INTEGER ) ) GetProcAddress( GetModuleHandleA( HASH_STR( "ntdll.dll" ) ), HASH_STR( "NtDelayExecution" ) );
    static NTSTATUS( __stdcall* ZwSetTimerResolution )( IN ULONG RequestedResolution, IN BOOLEAN Set, OUT PULONG ActualResolution ) = ( NTSTATUS( __stdcall* )( ULONG, BOOLEAN, PULONG ) ) GetProcAddress( GetModuleHandleA( HASH_STR( "ntdll.dll" ) ), HASH_STR( "ZwSetTimerResolution" ) );

    inline void sleep_short( float milliseconds ) {
        static bool once = true;
        if ( once )
        {
            ULONG actualResolution;
            ZwSetTimerResolution( 1, true, &actualResolution );
            once = false;
        }

        LARGE_INTEGER interval;
        interval.QuadPart = -1 * ( int ) ( milliseconds * 10000.0f );
        NtDelayExecution( false, &interval );
    }

    template <typename T = float>
    inline T bound( T current, T min, T max ) {
        if ( current < min ) {
            return min;
        }
        else if ( current > max ) {
            return max;
        }
        return current;
    }

    struct drag_state {
        bool is_dragging;
        ImVec2 drag_offset;
    };

    static std::default_random_engine m_generator;

    template<typename T>
    T generate_number( T min, T max, const std::unordered_set<T>& exclusions = { }, const std::function<bool( int )>& function = { } )
    {
        T generated_number;

        if constexpr ( std::is_integral_v<T> ) {
            std::uniform_int_distribution<T> range( min, max );
            do {
                generated_number = range( m_generator );
            } while ( exclusions.find( generated_number ) != exclusions.end( ) || ( function && !function( generated_number ) ) );
        }
        else if constexpr ( std::is_floating_point_v<T> ) {
            std::uniform_real_distribution<T> range( min, max );
            do {
                generated_number = range( m_generator );
            } while ( exclusions.find( generated_number ) != exclusions.end( ) || ( function && !function( generated_number ) ) );
        }

        return generated_number;
    }

    math::vector2 calculate_angle( const math::vector3& player, const math::vector3& target );
    math::vector2 cos_tan_sin_line_h( float angle, float range, std::int32_t x, std::int32_t y, std::int32_t length );
    math::vector2 calculate_radar_point( math::vector3 position, math::vector3 local, float distance, float angle, float size, float range );

    math::vector2 get_cursor( );
    bool is_hovered( math::vector2 Start, math::vector2 Size );

    std::string format_time( const float& time_in_minutes );
    float random_float( float a, float b );

    float get_lerp( math::vector3 center, math::vector3 firstposition, math::vector3 lastposition );
    float lerp( float default_val, float target, float alpha );
    bool line_cirlce_intersection( math::vector3 center, float radius, math::vector3 raystart, math::vector3 rayend );

    void update_function( const std::uint32_t& time, std::chrono::steady_clock::time_point& timestamp, const std::function<void( )>& task );
    void handle_drag( ImVec2& draw_position, const ImVec2& top_left_rect, const ImVec2& rect_size, const bool& menu, drag_state& drag_state );

    std::wstring select_file( const std::wstring& extension, const std::wstring& description, const std::wstring& pattern );
    fs::path select_folder( const std::wstring& title );

    void copy_to_clipboard( const std::string& string );
}

#endif // !UTILITY_HPP
