#ifndef MUTEXES_HPP
#define MUTEXES_HPP

namespace mutexes {
    class manual_shared_mutex {
    private:
        SRWLOCK srw = SRWLOCK_INIT;

    public:
        void lock( ) {
            AcquireSRWLockExclusive( &srw );
        }

        void unlock( ) {
            ReleaseSRWLockExclusive( &srw );
        }

        void lock_shared( ) {
            AcquireSRWLockShared( &srw );
        }

        void unlock_shared( ) {
            ReleaseSRWLockShared( &srw );
        }
    };
}

#endif // !MUTEXES_HPP