﻿#ifndef VISUALS_CPP
#define VISUALS_CPP

#include <impl/includes.hpp>

auto visual::c_visual::render_players( ) -> void
{
	const auto font_size = g_vars->fonts.visuals_medium_size;

	ImFont* visuals_font = fonts [ visuals ].get( font_size );
	if ( !visuals_font )
		return log_return( HASH_STR( "!visuals_font" ) );

	const auto& actors = g_entity->player_actors.load( );
	if ( !actors )
		return log_return( HASH_STR( "!actors" ) );

	auto& cached_players = *actors;

	const auto size = cached_players.size( );
	if ( size < 0 || size > entity::max_players_size )
		return log_return( HASH_STR( "!max_players_size" ) );

	const auto view_matrix = sdk::camera->view_matrix( );

	for ( auto& cached_entity : cached_players ) {
		auto& player = cached_entity.second;

		auto transform = player.transform;
		if ( !transform->is_valid( ) )
			continue;

		math::vector3 origin_position = player.origin_position;
		if ( !origin_position.valid( ) )
			continue;

		math::vector3 base_world = { origin_position.x, origin_position.y, origin_position.z };
		math::vector3 head_world = { origin_position.x, origin_position.y + 1.75f, origin_position.z };

		math::vector2 head_screen, base_screen;

		bool base = sdk::camera->world_to_screen( base_world, &base_screen, view_matrix ) || !sdk::camera->in_screen( base_screen );
		bool head = sdk::camera->world_to_screen( head_world, &head_screen, view_matrix ) || !sdk::camera->in_screen( head_screen );

		player.flags.is_on_screen = base && head;

		double top_offset_non_bounding = 20.00;
		double bottom_offset_non_bounding = 5.00;

		const c_color* color_override = nullptr;

		if ( g_vars->visuals.skeleton && player.flags.is_on_screen )
		{
			std::vector<sdk::object::c_bone_info> bones = player.skeleton.bones;

			for ( const auto& [first, second] : sdk::bone_connections ) 
			{
				const auto first_bone = std::find_if( bones.begin( ), bones.end( ),
					[ first ] ( const sdk::object::c_bone_info& b ) { return b.id == first; } );
				const auto second_bone = std::find_if( bones.begin( ), bones.end( ),
					[ second ] ( const sdk::object::c_bone_info& b ) { return b.id == second; } );

				if ( first_bone == bones.end( ) || second_bone == bones.end( ) )
					continue;

				const auto first_position = first_bone->position;
				const auto second_position = second_bone->position;

				if ( !first_position.valid( ) || !second_position.valid( ) )
					continue;

				math::vector2 start, end;
				if ( !sdk::camera->world_to_screen( first_position, &start, view_matrix ) || !sdk::camera->world_to_screen( second_position, &end, view_matrix ) || !sdk::camera->in_screen( start ) || !sdk::camera->in_screen( end ) )
					continue;

				g_framework->draw_line(
					ImVec2( start.x, start.y ),
					ImVec2( end.x, end.y ),
					color_override ? *color_override : g_vars->visuals.skeleton_color.to_color_mode( enums::color_mode( g_vars->visuals.skeleton_mode ) ),
					g_vars->visuals.skeleton_thickness,
					g_vars->visuals.skeleton_outline
				);
			}
		}

		if ( g_vars->visuals.distance && player.flags.is_on_screen )
		{
			const std::string& distance = std::to_string( player.distance ) + HASH_STR( "M" );
			const ImVec2 distance_size = ImGui::CalcTextSize( distance.c_str( ) );

			const auto& set_text_color = color_override
				? *color_override
				: g_vars->visuals.distance_color;

			const ImVec2 distance_position = ImVec2(
				base_screen.x - ( distance_size.x / 2 ),
				base_screen.y + bottom_offset_non_bounding
			);

			g_framework->text(
				distance,
				distance_position,
				set_text_color,
				font_size,
				visuals_font
			);

			bottom_offset_non_bounding += font_size;
		}
	}
}

#endif