#pragma once

namespace settings
{
	class c_settings
	{
	public: 
		c_settings( ) = default;
		~c_settings( ) = default;

		void load( );
		void save( );
		void reset( );

		struct {
			bool box_outline;
			bool box_fill;

			float box_horizotanl_gap;
			float box_vertical_gap;

			bool skeleton;
			c_color skeleton_color;
			int skeleton_mode;
			bool skeleton_outline;
			float skeleton_thickness;

			bool distance;
			c_color distance_color;

		} visuals;

		struct {
			bool no_recoil;
			bool no_sway;
			bool instant_ads;
			bool fast_reload;

			bool aspect_ratio_changer;
			float aspect_ratio;

			bool extra_lean;

		} misc;

		struct {
			std::string branding;
		} core;

		struct {
			float visuals_medium_size;
			float visuals_large_size;
		} fonts;

		struct {
			bool menu;
			int menu_key;

			bool vsync;
			bool is_focused;

			bool hide_tooltips;
			float rgb_speed;
		} ui;
	};

}
inline auto g_vars = std::make_shared<settings::c_settings>( );