#ifndef RENDER_HPP
#define RENDER_HPP

extern IMGUI_IMPL_API LRESULT ImGui_ImplWin32_WndProcHandler( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam );

namespace render
{
    enum class setup_error_code
    {
        render_invalid_pid,
        render_invalid_common_error,
        render_invalid_window,
        render_invalid_d3d_failure,
        system_operational,
        render_overlay_failure
    };

    class c_render
    {
    public:
        RECT m_rect { };
        MSG m_msg { };

        HWND window_target { };
        HWND overlay { };

        int width { };
        int height { };

        int width_center { };
        int height_center { };

        bool shutdown { };
        bool is_spoofed { };
    public:
        IDXGISwapChain* g_pSwapChain { };
        ID3D11Device* g_pd3dDevice { };
        ID3D11DeviceContext* g_pd3dDeviceContext { };
        ID3D11RenderTargetView* g_mainRenderTargetView { };

        [[nodiscard]] setup_error_code setup( const std::wstring& proc_name );

        HWND get_window_handle( std::uint32_t pid );

        bool get_screen_status( );
        bool get_window( );

        void tick( );

        void end_scene( );
        void begin_scene( );
        void cleanup( );

    public:
        void update_cursor( )
        {
            ImGuiIO& io = ImGui::GetIO( );
            static bool previous_keys_down [ 256 ] = { false };

            io.MouseDown [ 0 ] = GetAsyncKeyState( VK_LBUTTON ) & 0x8000;
            io.MouseDown [ 1 ] = GetAsyncKeyState( VK_RBUTTON ) & 0x8000;
            io.MouseDown [ 2 ] = GetAsyncKeyState( VK_MBUTTON ) & 0x8000;
            io.MouseDown [ 3 ] = GetAsyncKeyState( VK_XBUTTON1 ) & 0x8000;
            io.MouseDown [ 4 ] = GetAsyncKeyState( VK_XBUTTON2 ) & 0x8000;

            POINT cursorPos;
            GetCursorPos( &cursorPos );
            ScreenToClient( overlay, &cursorPos );
            io.MousePos = ImVec2( static_cast< float >( cursorPos.x ), static_cast< float >( cursorPos.y ) );

            io.AddKeyEvent( ImGuiKey_ModShift, ( GetAsyncKeyState( VK_SHIFT ) & 0x8000 ) != 0 );
            io.AddKeyEvent( ImGuiKey_ModCtrl, ( GetAsyncKeyState( VK_CONTROL ) & 0x8000 ) != 0 );
            io.AddKeyEvent( ImGuiKey_ModAlt, ( GetAsyncKeyState( VK_MENU ) & 0x8000 ) != 0 );

            for ( int i = 0; i < 256; i++ )
            {
                bool key_down = ( GetAsyncKeyState( i ) & 0x8000 ) != 0;

                if ( key_down != previous_keys_down [ i ] )
                {
                    ImGuiKey imgui_key = ImGuiKey_None;

                    switch ( i )
                    {
                    case VK_BACK: imgui_key = ImGuiKey_Backspace; break;
                    case VK_DELETE: imgui_key = ImGuiKey_Delete; break;
                    case VK_RETURN: imgui_key = ImGuiKey_Enter; break;
                    case VK_ESCAPE: imgui_key = ImGuiKey_Escape; break;
                    case VK_TAB: imgui_key = ImGuiKey_Tab; break;
                    case VK_LEFT: imgui_key = ImGuiKey_LeftArrow; break;
                    case VK_RIGHT: imgui_key = ImGuiKey_RightArrow; break;
                    case VK_UP: imgui_key = ImGuiKey_UpArrow; break;
                    case VK_DOWN: imgui_key = ImGuiKey_DownArrow; break;
                    case VK_HOME: imgui_key = ImGuiKey_Home; break;
                    case VK_END: imgui_key = ImGuiKey_End; break;
                    case VK_PRIOR: imgui_key = ImGuiKey_PageUp; break;
                    case VK_NEXT: imgui_key = ImGuiKey_PageDown; break;
                    case VK_INSERT: imgui_key = ImGuiKey_Insert; break;
                    case VK_SPACE: imgui_key = ImGuiKey_Space; break;
                    default:
                        if ( i >= 'A' && i <= 'Z' ) {
                            imgui_key = ( ImGuiKey ) ( ImGuiKey_A + ( i - 'A' ) );
                        }
                        else if ( i >= '0' && i <= '9' ) {
                            imgui_key = ( ImGuiKey ) ( ImGuiKey_0 + ( i - '0' ) );
                        }
                        break;
                    }

                    if ( imgui_key != ImGuiKey_None )
                    {
                        io.AddKeyEvent( imgui_key, key_down );
                    }

                    if ( key_down && !previous_keys_down [ i ] )
                    {
                        if ( i >= 'A' && i <= 'Z' ) {
                            bool shift_pressed = ( GetAsyncKeyState( VK_SHIFT ) & 0x8000 ) != 0;
                            bool caps_lock = ( GetKeyState( VK_CAPITAL ) & 0x0001 ) != 0;

                            if ( !shift_pressed && !caps_lock ) {
                                io.AddInputCharacter( static_cast< ImWchar >( i + 32 ) );
                            }
                            else {
                                io.AddInputCharacter( static_cast< ImWchar >( i ) );
                            }
                        }
                        else if ( i >= '0' && i <= '9' ) {
                            io.AddInputCharacter( static_cast< ImWchar >( i ) );
                        }
                        else if ( i == VK_SPACE ) {
                            io.AddInputCharacter( static_cast< ImWchar >( ' ' ) );
                        }
                    }
                }

                previous_keys_down [ i ] = key_down;
            }
        }
    };

    inline LRESULT WINAPI WndProc(
        HWND hWnd,
        UINT msg,
        WPARAM wParam,
        LPARAM lParam ) {

        if ( ImGui_ImplWin32_WndProcHandler( hWnd, msg, wParam, lParam ) ) {
            return true;
        }

        switch ( msg )
        {
        case WM_SIZE:
            if ( wParam == SIZE_MINIMIZED )
                return 0;
            return 0;
        case WM_SYSCOMMAND:
            if ( ( wParam & 0xfff0 ) == SC_KEYMENU )
                return 0;
            break;
        case WM_DESTROY:
            ::PostQuitMessage( 0 );
            return 0;
        case WM_MOUSEWHEEL: {
            short wheelDelta = GET_WHEEL_DELTA_WPARAM( wParam );

            wheel = ( wheelDelta > 0 ) ? 1 : ( wheelDelta < 0 ) ? -1 : 0;
        }
        }

        return ::DefWindowProcW( hWnd, msg, wParam, lParam );
    }

} inline auto g_render = std::make_shared<render::c_render>( );

#endif // ! guard