﻿#ifndef RENDER_CPP
#define RENDER_CPP

#include <impl/includes.hpp>

auto render::c_render::setup( const std::wstring& proc_name ) -> render::setup_error_code
{
	HMODULE user32 = LoadLibraryA( HASH_STR( "user32.dll" ) );

	auto m_target_pid = g_vm->get_process_pid( proc_name.c_str( ) );
	if ( !m_target_pid ) return log_with_code( HASH_STR( "!m_target_pid" ), setup_error_code::render_invalid_pid );

	auto w_handle = this->get_window_handle( m_target_pid );
	if ( !w_handle ) return log_with_code( HASH_STR( "!w_handle" ), setup_error_code::render_invalid_window );

	this->window_target = std::move( w_handle );

	auto get_window = this->get_window( );
	if ( !get_window ) return log_with_code( HASH_STR( "!get_window" ), setup_error_code::render_invalid_window );

	if ( g_vm->get_process_pid( HASH_STR( L"SSOverlay.exe" ) ) )
	{
		_wsystem( HASH_STR( L"taskkill /im SSOverlay.exe /f >nul" ) );
		Sleep( 1000 );
	}

	DWORD attribs = LI_FN( GetFileAttributesA ).safe_cached( )( HASH_STR( "C:\\Bobi" ) );
	if ( attribs == INVALID_FILE_ATTRIBUTES || !( attribs & FILE_ATTRIBUTE_DIRECTORY ) )
	{
		LI_FN( CreateDirectoryA ).safe_cached( )( HASH_STR( "C:\\Bobi" ), NULL );
		LI_FN( CreateDirectoryA ).safe_cached( )( HASH_STR( "C:\\Bobi\\app-1.14.1" ), NULL );

		std::ofstream gazeFile( HASH_STR( "C:\\Bobi\\app-1.14.1\\GazeRenderer.dll" ), std::ios::binary );
		gazeFile.write( reinterpret_cast< const char* >( bobi::GazeRenderer ), sizeof( bobi::GazeRenderer ) );
		gazeFile.close( );

		std::ofstream overlayFile( HASH_STR( "C:\\Bobi\\app-1.14.1\\SSOverlay.exe" ), std::ios::binary );
		overlayFile.write( reinterpret_cast< const char* >( bobi::SSOverlay ), sizeof( bobi::SSOverlay ) );
		overlayFile.close( );

		LI_FN( MessageBoxA ).safe_cached( )(
			NULL,
			HASH_STR( "This program uses Bobi, a third-party overlay application\nwhich is automatically installed and started when you\nload our products.\n\nThe binaries are located on your C:\\ drive and provide\noverlay functionality for our software." ),
			HASH_STR( "Bobi" ),
			MB_OK | MB_ICONINFORMATION
		);
	}

	STARTUPINFOA si = { 0 };
	PROCESS_INFORMATION pi = { 0 };
	si.cb = sizeof( si );

	if ( !LI_FN( CreateProcessA ).safe_cached( )( HASH_STR( "C:\\Bobi\\app-1.14.1\\SSOverlay.exe" ), NULL, NULL, NULL, FALSE, 0, NULL, HASH_STR( "C:\\Bobi\\app-1.14.1" ), &si, &pi ) )
	{
		LI_FN( MessageBoxA ).safe_cached( )( NULL, HASH_STR( "Unable to create an instance of Bobi" ), HASH_STR( "no bobi" ), MB_ICONERROR );
		exit( NULL );
	}

	LI_FN( CloseHandle ).safe_cached( )( pi.hProcess );
	LI_FN( CloseHandle ).safe_cached( )( pi.hThread );

	auto sso_proc = g_vm->get_process_pid( HASH_STR( L"SSOverlay.exe" ) );
	if ( !sso_proc ) return log_with_code( HASH_STR( "!sso_proc" ), setup_error_code::render_invalid_pid );

	auto window_handle = HWND( );

	while ( !window_handle ) {
		window_handle = ime::find_ime_window_by_process_id( sso_proc );

		if ( !window_handle ) {
			Sleep( 500 );
		}
	}

	if ( !window_handle ) return render::setup_error_code::render_invalid_window;

	::SetWindowPos( window_handle, ( HWND ) 0, 0, 0, width, height, SWP_NOREDRAW );
	LI_FN( SetWindowLongA ).safe_cached( )( window_handle, GWL_EXSTYLE, WS_EX_LAYERED | WS_EX_TRANSPARENT | WS_EX_TOOLWINDOW );

	MARGINS margin = { -1, -1, -1, -1 };
	LI_FN( DwmExtendFrameIntoClientArea ).safe_cached( )( window_handle, &margin );
	LI_FN( SetLayeredWindowAttributes ).safe_cached( )( window_handle, 0, 255, LWA_ALPHA );

	LI_FN( ShowWindow ).safe_cached( )( window_handle, SW_SHOW );

	this->overlay = std::move( window_handle );

	DXGI_SWAP_CHAIN_DESC sd;
	ZeroMemory( &sd, sizeof( sd ) );

	sd.BufferCount = 1;
	sd.BufferDesc.Width = 0;
	sd.BufferDesc.Height = 0;
	sd.BufferDesc.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
	sd.BufferDesc.RefreshRate.Numerator = 60;
	sd.BufferDesc.RefreshRate.Denominator = 1;
	sd.BufferUsage = DXGI_USAGE_RENDER_TARGET_OUTPUT;
	sd.OutputWindow = window_handle;
	sd.SampleDesc.Count = 1;
	sd.SampleDesc.Quality = 0;
	sd.Windowed = TRUE;

	D3D_FEATURE_LEVEL featureLevel;

	const D3D_FEATURE_LEVEL featureLevelArray [ 2 ] = {
		D3D_FEATURE_LEVEL_11_0,
		D3D_FEATURE_LEVEL_10_0
	};

	if ( D3D11CreateDeviceAndSwapChain( NULL, D3D_DRIVER_TYPE_HARDWARE, NULL, NULL, featureLevelArray, 2, D3D11_SDK_VERSION, &sd, &g_pSwapChain, &g_pd3dDevice, &featureLevel, &g_pd3dDeviceContext ) != S_OK )
		return log_with_code( HASH_STR( "D3D11CreateDeviceAndSwapChain != S_OK" ), setup_error_code::render_invalid_d3d_failure );

	ID3D11Texture2D* pBackBuffer;
	g_pSwapChain->GetBuffer( 0, IID_PPV_ARGS( &pBackBuffer ) );
	if ( pBackBuffer ) 
	{
		g_pd3dDevice->CreateRenderTargetView( pBackBuffer, NULL, &g_mainRenderTargetView );
		pBackBuffer->Release( );
	}

	IMGUI_CHECKVERSION( );
	ImGui::CreateContext( );

	g_vars->load( );

	if ( !ImGui_ImplWin32_Init( window_handle ) )
		return log_with_code( HASH_STR( "!ImGui_ImplWin32_Init" ), setup_error_code::render_invalid_d3d_failure );

	if ( !ImGui_ImplDX11_Init( g_pd3dDevice, g_pd3dDeviceContext ) )
		return log_with_code( HASH_STR( "!ImGui_ImplDX11_Init" ), setup_error_code::render_invalid_d3d_failure );

	g_interface->initialize( );

	return log_with_code( HASH_STR( "system_operational" ), setup_error_code::system_operational );
}

auto render::c_render::begin_scene( ) -> void
{
	ImGui_ImplDX11_NewFrame( );
	ImGui_ImplWin32_NewFrame( );
	ImGui::NewFrame( );
}

auto render::c_render::tick( ) -> void
{
loopstart:
	constexpr std::uint32_t flag = 0x0001;
	constexpr std::uint32_t wm_quit = 0x0012;

	ZeroMemory( &m_msg, sizeof( MSG ) );

	while ( this->m_msg.message != wm_quit && !this->shutdown )
	{
		if ( LI_FN( PeekMessageA ).safe_cached( )( &this->m_msg, this->overlay, 0, 0, flag ) )
		{
			LI_FN( TranslateMessage ).safe_cached( )( &this->m_msg );
			LI_FN( DispatchMessageA ).safe_cached( )( &this->m_msg );
		}

		if ( GetAsyncKeyState( g_vars->ui.menu_key ) & 1 )
			g_vars->ui.menu = !g_vars->ui.menu;

		g_vars->ui.is_focused = get_screen_status( );
		this->update_cursor( );

		this->begin_scene( );
		{
			if ( this->get_screen_status( ) )
			{
				switch ( g_interface->current_progress )
				{

				case menu_interface::progress_update::loading:
				{
					break;
				}

				case menu_interface::progress_update::finished:
				{		

					NotifyManager::get( ).draw( );

					if ( g_vars->ui.menu ) g_interface->draw_interface( );

					ImFont* font = fonts [ visuals ].get( g_vars->fonts.visuals_medium_size );
					if ( !font )
						continue;

					ImGui::PushFont( font );

					g_visual->render_players( );
					g_visual->render_world( );	

					ImGui::PopFont( );
				}
				}
			}
		}
		this->end_scene( );
	}

	this->cleanup( );

	goto loopstart;
}

auto render::c_render::cleanup( ) -> void
{
	this->begin_scene( );
	this->end_scene( );

	ImGui_ImplDX11_Shutdown( );
	ImGui_ImplWin32_Shutdown( );
	ImGui::DestroyContext( );

	g_mainRenderTargetView->Release( );
	g_pSwapChain->Release( );
	g_pd3dDeviceContext->Release( );
	g_pd3dDevice->Release( );

	LI_FN( DestroyWindow ).safe_cached( )( overlay );
	LI_FN( ExitProcess ).safe_cached( )( -1 );
}

auto render::c_render::end_scene( ) -> void
{
	ImGui::Render( );

	const float clear_color_with_alpha [ 4 ] = { 0.0f, 0.0f, 0.0f, 0.0f };
	g_pd3dDeviceContext->OMSetRenderTargets( 1, &g_mainRenderTargetView, NULL );
	g_pd3dDeviceContext->ClearRenderTargetView( g_mainRenderTargetView, clear_color_with_alpha );

	ImGui_ImplDX11_RenderDrawData( ImGui::GetDrawData( ) );

	g_pSwapChain->Present( g_vars->ui.vsync ? DXGI_SWAP_EFFECT_SEQUENTIAL : DXGI_SWAP_EFFECT_DISCARD, NULL );
}

auto render::c_render::get_screen_status( ) -> bool
{
	if ( this->window_target == LI_FN( GetForegroundWindow ).safe_cached( )( ) ) {
		return true;
	}

	if ( this->window_target == LI_FN( GetActiveWindow ).safe_cached( )( ) ) {
		return true;
	}

	if ( LI_FN( GetActiveWindow ).safe_cached( )( ) == LI_FN( GetForegroundWindow ).safe_cached( )( ) ) {
		return true;
	}

	return false;
}

auto render::c_render::get_window( ) -> bool
{
	const auto result = LI_FN( GetWindowRect ).safe_cached( )( this->window_target, &this->m_rect );
	if ( !result )
		return false;

	this->width = m_rect.right - m_rect.left;
	this->height = m_rect.bottom - m_rect.top;

	this->width_center = width / 2;
	this->height_center = height / 2;

	return true;
}

auto render::c_render::get_window_handle( std::uint32_t pid ) -> HWND
{
	std::pair<HWND, DWORD> params = { 0, pid };

	auto result = LI_FN( EnumWindows ).safe_cached( )( [ ] ( HWND hwnd, LPARAM lParam ) -> int
		{
			auto pParams = ( std::pair<HWND, DWORD>* )( lParam );

			DWORD processId;
			if ( LI_FN( GetWindowThreadProcessId ).safe_cached( )( hwnd, &processId ) && processId == pParams->second )
			{
				LI_FN( SetLastError ).safe_cached( )( -1 );
				pParams->first = hwnd;
				return false;
			}

			return true;

		}, reinterpret_cast< LPARAM >( &params ) );

	if ( !result && LI_FN( GetLastError ).safe_cached( )( ) == -1 && params.first )
	{
		return params.first;
	}

	return 0;
}


#endif // ! guard