﻿#ifndef INTERFACE_CPP
#define INTERFACE_CPP

#include <impl/includes.hpp>

auto menu_interface::c_interface::initialize( ) -> void
{
	size = ImVec2 { 660, 675 };

	GImGui->IO.IniFilename = "";

	StyleManager::get( ).Styles( );
	StyleManager::get( ).Colors( );

	LangManager::get( ).initialize( );

	fonts.resize( fonts_size );

	auto config = ImFontConfig( );

	config.FontLoaderFlags = ImGuiFreeTypeBuilderFlags_ForceAutoHint | ImGuiFreeTypeBuilderFlags_LoadColor;
	config.OversampleH = 1;
	config.OversampleV = 1;

	auto merged_config = config;
	merged_config.MergeMode = true;

	fonts.at( font ).setup( {
		{ binary::b_font, sizeof( binary::b_font ), { 14.00f, 12.00f }, ImGui::GetIO( ).Fonts->GetGlyphRangesCyrillic( ), config },
		{ HASH_STR( "C:\\Windows\\Fonts\\msyh.ttc" ), { 14.00f, 12.00f }, ImGui::GetIO( ).Fonts->GetGlyphRangesChineseSimplifiedCommon( ), merged_config }
	} );

	fonts.at( visuals ).setup( {
		{ binary::minecraftia, sizeof( binary::minecraftia ), { g_vars->fonts.visuals_medium_size, g_vars->fonts.visuals_large_size }, ImGui::GetIO( ).Fonts->GetGlyphRangesCyrillic( ), config },
		{ HASH_STR( "C:\\Windows\\Fonts\\msyh.ttc" ), { g_vars->fonts.visuals_medium_size, g_vars->fonts.visuals_large_size }, ImGui::GetIO( ).Fonts->GetGlyphRangesChineseSimplifiedCommon( ), merged_config }
	} );

	const static ImWchar icons_ranges[ ] = { 0x1 + 1000, 0x1 + 5881, 0 };
	fonts.at( icons ).setup( {
		{ binary::glyphter, sizeof( binary::glyphter ), { 14.00f, 12.00f }, icons_ranges, config }
	} );

	ChildManager& cm = ChildManager::get( );
	auto& widgets = WidgetsManager::get( );

	TabsManager::get( ).add_page( 0, [ & ] ( ) {
		BeginGroup( );
		{
			cm.beginchild( HASH_STR( "Settings" ) );
			{
				widgets.Checkbox( HASH_STR( "Instant ADS" ), &g_vars->misc.instant_ads );
				widgets.Checkbox( HASH_STR( "No Recoil" ), &g_vars->misc.no_recoil );
				widgets.Checkbox( HASH_STR( "No Sway" ), &g_vars->misc.no_sway );
				widgets.Checkbox( HASH_STR( "Fast Reload" ), &g_vars->misc.fast_reload );

				TextDisabled( LangManager::get( ).translate( HASH_STR( "Skeletons" ) ).c_str( ) );

				widgets.Checkbox( HASH_STR( "Skeletons" ), &g_vars->visuals.skeleton, 0, g_vars->visuals.skeleton_color.to_array( ), [ & ] ( ) {
				
					widgets.Combo( HASH_STR( "Color Mode" ), &g_vars->visuals.skeleton_mode, color_modes );
					widgets.Checkbox( HASH_STR( "Outline" ), &g_vars->visuals.skeleton_outline );
					widgets.SliderFloat( HASH_STR( "Scale" ), &g_vars->visuals.skeleton_thickness, 0.1f, 4.f );
				} );

				widgets.Checkbox( HASH_STR( "Distance" ), &g_vars->visuals.distance, 0, g_vars->visuals.distance_color.to_array( ) );

				widgets.Checkbox( HASH_STR( "Aspect Ratio Changer" ), &g_vars->misc.aspect_ratio_changer, 0, 0, [ & ] ( ) {
					widgets.SliderFloat( HASH_STR( "Ratio" ), &g_vars->misc.aspect_ratio, 0.1f, 3.f );
					TooltipManager::get( ).draw( HASH_STR( "Adjust screen aspect ratio" ) );
					} );
				TooltipManager::get( ).draw( HASH_STR( "Modifies screen aspect ratio" ) );
			}
			cm.endchild( );


		}
		EndGroup( );
	} );

	this->current_progress = progress_update::finished;
}

auto menu_interface::c_interface::draw_interface( ) -> void
{
	static bool init = false;
	if ( !init ) {
		for ( int i = 0; i < TabsManager::get( ).get_tabs( ).size( ); ++i ) {
			if ( TabsManager::get( ).get_tabs( ) [ i ].pages.empty( ) ) continue;

			TabsManager::get( ).set_tab( i );
			for ( int j = 0; j < TabsManager::get( ).get_tabs( ) [ i ].pages.size( ); ++j ) {
				TabsManager::get( ).set_subtab( j );
				TabsManager::get( ).get_tabs( ) [ i ].pages [ j ]( );
			}

			TabsManager::get( ).set_subtab( 0 );
		}

		TabsManager::get( ).set_tab( 0 );

		init = true;
	}

	SetNextWindowSize( size );
	Begin( HASH_STR( "GUI" ), 0, ImGuiWindowFlags_NoDecoration | ImGuiWindowFlags_NoBringToFrontOnFocus );
	{
		BeginChild( HASH_STR( "navbar" ), { 0, 56 }, 0, ImGuiWindowFlags_NoBackground );
		{
			sprites_interface::sprite_data watermark = sprite_manager->get( g_vars->core.branding );
			if ( watermark.texture )
				GetWindowDrawList( )->AddImage( ( ImTextureID ) watermark.texture, GetWindowPos( ) + ImVec2 { GetWindowHeight( ) / 2 - 13, GetWindowHeight( ) / 2 - 13 }, GetWindowPos( ) + ImVec2 { GetWindowHeight( ) / 2 + 13, GetWindowHeight( ) / 2 + 13 } );

			SetCursorPosX( 56 );
			PushStyleColor( ImGuiCol_FrameBg, GetColorU32( ImGuiCol_FrameBg, 0.f ) );
			PushStyleVar( ImGuiStyleVar_FrameBorderSize, 0 );
			PushStyleVar( ImGuiStyleVar_FramePadding, { 16, GetWindowHeight( ) / 2 - GImGui->FontSize / 2 } );
			PushItemFlag( ImGuiItemFlags_NoNav, true );
			GetWindowDrawList( )->AddRectFilled( GetCurrentWindow( )->DC.CursorPos, GetCurrentWindow( )->DC.CursorPos + ImVec2 { 1, GetWindowHeight( ) }, GetColorU32( ImGuiCol_Border ) );
			static bool ac = false;
			if ( WidgetsManager::get( ).TextField( HASH_STR( "##search" ), SearchManager::get( ).search_buf, sizeof( SearchManager::get( ).search_buf ), { 200, 0 }, HASH_STR( "Search..." ), I_SEARCH ) ) {
				SearchManager::get( ).update( );
			}

			if ( ac && !ImGui::IsItemActive( ) && SearchManager::get( ).search_buf [ 0 ] == '\0' ) {
				ImGui::SetKeyboardFocusHere( -1 );
			}

			ac = IsItemActive( );

			PopItemFlag( );
			PopStyleVar( 2 );
			PopStyleColor( );

			static float tabs_size = 0;
			SetCursorPos( { GetWindowWidth( ) - tabs_size - 21, 0 } );
			float p1 = GetCurrentWindow( )->DC.CursorPos.x;
			BeginChild( HASH_STR( "tabs" ), { 0, GetWindowHeight( ) }, ImGuiChildFlags_AlwaysAutoResize | ImGuiChildFlags_AutoResizeX );
			TabsManager::get( ).render_tabs( 13, true );
			EndChild( );
			SameLine( 0, 0 );
			tabs_size = GetCurrentWindow( )->DC.CursorPos.x - p1;
		}
		EndChild( );

		SetCursorPos( { 0, 56 } );
		PushStyleColor( ImGuiCol_ChildBg, ImColor { 0, 0, 0 }.Value );
		PushStyleColor( ImGuiCol_Border, ImColor { 255, 231, 231, 20 }.Value );
		BeginChild( HASH_STR( "main" ), { 0, -40 }, ImGuiChildFlags_AlwaysUseWindowPadding | ImGuiChildFlags_Border, ImGuiWindowFlags_NoScrollbar | ImGuiWindowFlags_NoScrollWithMouse );
		{
			PopStyleColor( 2 );

			if ( strlen( SearchManager::get( ).search_buf ) == 0 && SearchManager::get( ).get_anim( ) < 0.05f ) {
				TabsManager::get( ).render_subtabs( 8 );

				auto window = GetCurrentWindow( );

				PushStyleVar( ImGuiStyleVar_Alpha, GImGui->Style.Alpha * TabsManager::get( ).get_anim( ) * GImGui->Style.Alpha );
				PushStyleVar( ImGuiStyleVar_WindowPadding, { 14, 14 } );
				BeginChild( HASH_STR( "content" ), { 0, 0 }, ImGuiChildFlags_AlwaysUseWindowPadding, ImGuiWindowFlags_NoBackground | ImGuiWindowFlags_NoScrollbar | ImGuiWindowFlags_NoScrollWithMouse );
				{
					TabsManager::get( ).draw_page( window );
				}
				EndChild( );
				PopStyleVar( 2 );
			}
			else {
				PushStyleVar( ImGuiStyleVar_WindowPadding, { 14, 14 } );
				BeginChild( HASH_STR( "content2" ), { 0, 0 }, ImGuiChildFlags_AlwaysUseWindowPadding, ImGuiWindowFlags_NoBackground | ImGuiWindowFlags_NoScrollbar | ImGuiWindowFlags_NoScrollWithMouse );
				{
					ChildManager::get( ).smoothscroll( );
					SearchManager::get( ).draw( );
				}
				EndChild( );
				PopStyleVar( );
			}
		}
		EndChild( );

		SetCursorPosY( GetCursorPosY( ) - GImGui->Style.ItemSpacing.y );
		BeginChild( HASH_STR( "footer" ), { 0, 0 }, 0, ImGuiWindowFlags_NoBackground );
		{
			SetCursorPos( { GetWindowHeight( ) / 2 - 12, GetWindowHeight( ) / 2 - 13 } );
			CompBuilder::get( ).OpenButton( HASH_STR( "lang selector" ), { 32 + fonts [ font ].get( 12 )->CalcTextSizeA( 12, FLT_MAX, -1, LangManager::get( ).get_lang_name( ).c_str( ) ).x, 24 }, [ & ] ( CompBuilder::OpenButtonEnv env ) {
				GetWindowDrawList( )->AddRectFilled( env.bb.Min, env.bb.Max, GetColorU32( ImGuiCol_ChildBg ), GImGui->Style.FrameRounding );
				GetWindowDrawList( )->AddText( fonts [ icons ].get( 12 ), 12, { env.bb.Min.x + 6, env.bb.GetCenter( ).y - 6 }, GetColorU32( ImGuiCol_Scheme ), I_LANGUAGE__KATAKANA );
				GetWindowDrawList( )->AddText( fonts [ font ].get( 12 ), 12, { env.bb.Min.x + 26, env.bb.GetCenter( ).y - 6 }, GetColorU32( ImGuiCol_Text ), LangManager::get( ).get_lang_name( ).c_str( ) );

				if ( env.pressed ) {
					env.open = !env.open;
				}

				if ( env.hovered ) env.open = true;

				if ( env.anim.open > 0.05f ) {
					PushStyleVar( ImGuiStyleVar_Alpha, env.anim.open );
					PushStyleVar( ImGuiStyleVar_ItemSpacing, { 0, 0 } );
					PushStyleVar( ImGuiStyleVar_WindowRounding, GImGui->Style.FrameRounding );
					PushStyleVar( ImGuiStyleVar_WindowPadding, { 0, 8 } );
					PushStyleVar( ImGuiStyleVar_FramePadding, { 10, 8 } );
					PushStyleVar( ImGuiStyleVar_WindowBorderSize, 1 );
					PushStyleColor( ImGuiCol_WindowBg, GetColorU32( ImGuiCol_FrameBg ) );
					Begin( HASH_STR( "lang selector" ), 0, ImGuiWindowFlags_NoDecoration | ImGuiWindowFlags_NoMove );
					{
						SetWindowPos( { env.bb.Min.x, env.bb.GetCenter( ).y - GetWindowHeight( ) / 2 } );
						SetWindowSize( { 100, ( GetCurrentWindow( )->ContentSize.y + GImGui->Style.WindowPadding.y * 2 ) * env.anim.open } );

						BringWindowToDisplayFront( GetCurrentWindow( ) );
						BringWindowToFocusFront( GetCurrentWindow( ) );

						if ( !IsWindowHovered( ImGuiHoveredFlags_AllowWhenBlockedByActiveItem ) && !env.hovered ) {
							env.open = false;
						}

						PushStyleColor( ImGuiCol_FrameBg, GetColorU32( ImGuiCol_FrameBgHovered ) );

						for ( int i = 0; i < LangManager::get( ).get_langs( ).size( ); ++i ) {
							if ( WidgetsManager::get( ).Selectable( LangManager::get( ).get_langs( ) [ i ].label, LangManager::get( ).get_lang( ) == i ) ) {
								LangManager::get( ).set_lang( i );
							}
						}

						PopStyleColor( );
					}
					End( );
					PopStyleColor( );
					PopStyleVar( 6 );
				}
				} );

			std::string key_text = HASH_STR( "Menu: " ) + std::string( key_name_list [ g_vars->ui.menu_key ] );
			ImVec2 key_text_size = ImGui::CalcTextSize( key_text.c_str( ) );

			GetWindowDrawList( )->AddText( GetWindowPos( ) + ImVec2 { GetWindowWidth( ) - 15 - key_text_size.x, GetWindowHeight( ) / 2 - GImGui->FontSize / 2 - 1 }, GetColorU32( ImGuiCol_Text ), key_text.c_str( ) );

		}
		EndChild( );

		PopupManager::get( ).handle( );
	}
	End( );

	wheel = 0;
}

#endif // !INTERFACE_CPP