#pragma once

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#ifndef _CRT_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_WARNINGS
#endif // !_CRT_SECURE_NO_WARNINGS

#ifndef _CRT_NON_CONFORMING_SWPRINTFS
#define _CRT_NON_CONFORMING_SWPRINTFS
#endif // _CRT_NON_CONFORMING_SWPRINTFS

#ifndef IMGUI_DEFINE_MATH_OPERATORS
#define IMGUI_DEFINE_MATH_OPERATORS
#endif // !IMGUI_DEFINE_MATH_OPERATORS

#define NOMINMAX

#include <memory>
#include <thread>
#include <mutex>
#include <chrono>
#include <limits>
#include <string>
#include <tuple>
#include <algorithm>
#include <utility>

#include <filesystem>
namespace fs = std::filesystem;

#include <fstream>
#include <random>
#include <iostream>
#include <queue>
#include <typeindex>
#include <expected>

#include <cmath>
#include <corecrt_math_defines.h>

#define SECURITY_INTERACTIVE_RID 0x00000004
#include <atlsecurity.h> 

#define TEST_BIT(value, bit) (((value) & (1 << (bit))) != 0)

#define INLINE
#define FORCEINLINE __forceinline

#include <vector>
#include <unordered_map>
#include <unordered_set>

#include <ShObjIdl.h>
#include <shlobj.h>

#include <curl/curl.h>

#include <windows.h>
#include <winternl.h>
#include <ntstatus.h>
#include <winioctl.h>
#include <mmeapi.h>
#include <tlhelp32.h>
#include <dwmapi.h>

#include <mmsystem.h>
#pragma comment(lib, "winmm.lib")

#include <commdlg.h>
#pragma comment(lib, "Comdlg32.lib")

// json

#include <nlohmann/json.hpp>

// vcruntimes

#include <impl/vcruntimes/hexrays.hpp>
#include <impl/vcruntimes/hash.hpp>
#include <impl/vcruntimes/constant.hpp>
#include <impl/vcruntimes/lazy_import.hpp>

// Melon Auto updating API dependencies

// jwt

#include <jwt-cpp/jwt.h>

// crypto dependencies

#include <cryptopp/aes.h>
#include <cryptopp/modes.h>
#include <cryptopp/filters.h>
#include <cryptopp/osrng.h>
#include <cryptopp/base64.h>

// curl for people

#include <cpr/cpr.h>

// End of Melon Auto updating API dependencies

// threads

#include <workspace/backend/elements/thread/thread.hpp>

// ime

#include <ime/ime.hpp>

// d3d11

#include <d3d11.h>
#include <d3dx11.h>

// imgui

#include <imgui/imgui.h>
#include <imgui/imgui_internal.h>

// imgui impl

#include <imgui/imgui_impl_dx11.h>
#include <imgui/imgui_impl_win32.h>
#include <imgui/imgui_freetype.h>

// internal elements

#include <workspace/backend/elements/mutexes/mutexes.hpp>

// resource

#include <dependencies/binaries/bobi.h>
#include <dependencies/binaries/fonts.h>
#include <dependencies/binaries/icons.h>
#include <dependencies/binaries/unicodes.hpp>

// colors

#include <workspace/unity/core/enums/enums.hpp>
#include <workspace/drawing/colors/colors.hpp>

// global variables

#include <impl/vars/vars.hpp>

// cherry

#include <cherry/cherry.hpp>

// kernel structs

#include <dependencies/efi/ntos/ia32.hpp>
#include <dependencies/efi/efi.hpp>

// unity sdk

#include <workspace/unity/core/math/vector.hpp>
#include <workspace/backend/elements/utility/util.hpp>

#include <workspace/unity/sdk.hpp>
#include <workspace/unity/core/structs/objects.hpp>

// melon

#include <workspace/backend/internal/melon/encryptions/cryptopp.hpp>
#include <workspace/backend/internal/melon/api/api.hpp>

// physx

//#include <embree4/rtcore.h>
//
//#include <impl/game/enviroment/physx/sdk/bvh.hpp>
//#include <impl/game/enviroment/physx/sdk/physx.hpp>
//#include <impl/game/enviroment/physx/embree4/embree.hpp>
//#include <impl/game/enviroment/physx/trace/trace.hpp>

// drawing sdk

#include <workspace/drawing/textures/textures.hpp>
#include <workspace/drawing/sprites/sprites.hpp>
#include <workspace/drawing/framework/framework.hpp>

// game source sdk

#include <impl/game/players/players.hpp>
#include <impl/game/environment/environment.hpp>

// visualization

#include <impl/visual/visuals.hpp>

// interface widgets

#include <workspace/drawing/widgets/styles/style_manager.hpp>
#include <workspace/drawing/widgets/font/font_manager.hpp>
#include <workspace/drawing/widgets/language/language_manager.hpp>
#include <workspace/drawing/widgets/animations/animations.hpp>
#include <workspace/drawing/widgets/help/help_manager.hpp>
#include <workspace/drawing/widgets/pop ups/popup_manager.hpp>
#include <workspace/drawing/widgets/tooltips/tooltip_manager.hpp>
#include <workspace/drawing/widgets/tabs/tabs_manager.hpp>
#include <workspace/drawing/widgets/search/search_manager.hpp>
#include <workspace/drawing/widgets/colors/color_picker.hpp>
#include <workspace/drawing/widgets/notify/notification.hpp>
#include <workspace/drawing/widgets/widgets/widgets_manager.hpp>
#include <workspace/drawing/widgets/components/component_builder.hpp>
#include <workspace/drawing/widgets/childs/child_manager.hpp>

// menu

#include <impl/menu/menu.hpp>

// render

#include <impl/render/render.hpp>