#ifndef PLAYERS_HPP
#define PLAYERS_HPP

namespace entity
{
	constexpr int max_cache_ittr = 100;

	constexpr int max_entities_size = 4000;
	constexpr int max_players_size = 600;

	inline mutexes::manual_shared_mutex player_mutex;

	enum class actor_tag_t : std::uint32_t 
	{
		player,
		world,
	};

	class c_cache_timer
	{
	private:
		std::chrono::high_resolution_clock::time_point start_time;
		double average_cache_time;
		int cache_count;

	public:
		c_cache_timer( ) : start_time( std::chrono::high_resolution_clock::time_point( ) ), average_cache_time( 0.00 ), cache_count( 0 ) { };
		~c_cache_timer( ) = default;

		void start( ) { start_time = std::chrono::high_resolution_clock::now( ); }
		void end( const std::string& function, int max_ittr, bool debug = false );

		double get_average( ) const { return average_cache_time; }
		int count( ) const { return cache_count; }
	};

	class c_entity
	{
	private:
		std::unordered_map<std::uint64_t, actor_tag_t> global_actors = { };
		std::unordered_set<std::uint64_t> current_actors_set = { };

	public:
		std::atomic<std::shared_ptr<std::unordered_map<std::uint64_t, sdk::object::c_actor>>> player_actors;
		//std::atomic<std::shared_ptr<std::unordered_map<sdk::c_base_combat_entity*, sdk::object::c_entity>>> world_actors;

		c_entity( ) 
		{
			player_actors.store( std::make_shared<std::unordered_map<std::uint64_t, sdk::object::c_actor>>( ) );
			//world_actors.store( std::make_shared<std::unordered_map<sdk::c_base_combat_entity*, sdk::object::c_entity>>( ) );
		}
		~c_entity( ) = default;

		void reset_current_set( ) { current_actors_set.clear( ); };

		bool handle_player( std::uint64_t player_handle );
		//bool handle_world_item( unity::c_game_object* game_object, sdk::c_base_combat_entity* base_combat_entity );

		sdk::object::c_local_player local_player;

		const auto get_local_data( ) const { player_mutex.lock_shared( ); auto copy = local_player; player_mutex.unlock_shared( ); return copy; }
		void set_local_data( const sdk::object::c_local_player& data ) { player_mutex.lock( ); local_player = data; player_mutex.unlock( ); }

		void tick( );

		void cache_actors( );
		void warmup_pointers( );
		bool cache_local_player( );
		void initialize( );

		void second_tick( );

		void update_players( ) const;
		bool verify_player( sdk::object::c_actor& player ) const;
	};

} inline auto g_entity = std::make_shared<entity::c_entity>( );

#endif // PLAYERS_HPP