﻿#ifndef PLAYERS_CPP
#define PLAYERS_CPP

#include <impl/includes.hpp>

struct BaseObject
{
	uint64_t previousObjectLink;
	uint64_t nextObjectLink;
	uint64_t object;
};

struct GameObjectManager
{
	uint64_t lastTaggedObject;
	uint64_t taggedObjects;
	uint64_t lastActiveObject;
	uint64_t activeObjects;
	uint64_t LastActiveNode;
	uint64_t ActiveNodes;
};

uintptr_t GetObjectFromList( uintptr_t listPtr, uintptr_t lastObjectPtr, const char* objectName )
{
	char ObjectName [ 128 ] {};
	uintptr_t classNamePtr = 0;

	BaseObject activeObject = g_vm->read<BaseObject>( listPtr );
	BaseObject lastObject = g_vm->read<BaseObject>( lastObjectPtr );

	if ( activeObject.object != NULL )
	{
		while ( activeObject.object != 0 && activeObject.object != lastObject.object )
		{
			classNamePtr = g_vm->read<uint64_t>( activeObject.object + 0x88 );
			g_vm->read_physical( classNamePtr, &ObjectName, sizeof( ObjectName ), false );

			if ( strcmp( ObjectName, objectName ) == 0 )
				return activeObject.object;

			activeObject = g_vm->read<BaseObject>( activeObject.nextObjectLink );
		}
	}
	if ( lastObject.object != NULL )
	{
		classNamePtr = g_vm->read<uint64_t>( lastObject.object + 0x88 );
		g_vm->read_physical( classNamePtr, &ObjectName, sizeof( ObjectName ), false );

		if ( strcmp( ObjectName, objectName ) == 0 )
			return lastObject.object;
	}

	ZeroMemory( ObjectName, sizeof( ObjectName ) );

	return 0;
}


auto entity::c_entity::tick( ) -> void
{
loop_start:

	constexpr auto pointers_update_interval = 15000;
	constexpr auto local_player_update_interval = 5000;
	constexpr auto actors_update_interval = 250;

	auto last_pointer_tick = std::chrono::steady_clock::now( );
	auto last_actors_tick = last_pointer_tick;
	auto last_local_player_tick = last_pointer_tick;

	std::vector<unsigned int> intervals = {
		pointers_update_interval, local_player_update_interval, actors_update_interval
	};

	const auto& lowest_interval = *min_element( intervals.begin( ), intervals.end( ) );

	this->initialize( );

	while ( true ) {
		threads::manager->set_state( threads::thread_type::cache, false );

		utility::update_function( pointers_update_interval, last_pointer_tick,
			[ & ] { warmup_pointers( ); }
		);

		utility::update_function( local_player_update_interval, last_local_player_tick,
			[ & ] { cache_local_player( ); }
		);

		utility::update_function( actors_update_interval, last_actors_tick,
			[ & ] { cache_actors( ); }
		);

		threads::manager->set_state( threads::thread_type::cache, true );

		utility::sleep_short( lowest_interval );
	}

	goto loop_start;
}

auto entity::c_entity::initialize( ) -> void
{
	warmup_pointers( );
	cache_actors( );
	cache_local_player( );
}

struct CameraArray
{
	std::uint64_t Cameras;
	std::uint64_t MinCount;
	std::uint64_t CurCount;
	std::uint64_t MaxCount;
};

std::uint64_t get_fps_camera( )
{
	auto camera_array = g_vm->read<CameraArray>( g_vm->read<std::uint64_t>( g_vm->unity_player + 0x19F0040 ) );

	for ( int index = 0; index < camera_array.CurCount; index++ )
	{
		const auto entry = g_vm->read<std::uint64_t>( camera_array.Cameras + ( index * 8 ) );
		if ( !entry )
			continue;

		const auto game_object = g_vm->read<unity::c_game_object*>( entry + 0x58 );
		if ( !game_object->is_valid( ) )
			continue;

		const std::string name = game_object->get_name( );
		if ( name.empty( ) )
			continue;

		if ( name.find( "FPS Camera" ) != std::string::npos || name.find( "FPSCamera" ) != std::string::npos )
		{
			const auto camera_native_object = game_object->get_scripting_object<sdk::c_fps_camera*>( HASH_STR( "Camera" ) );
			if ( !camera_native_object.address->is_valid( ) )
				continue;

			printf( "%s\n", camera_native_object.object.managed->klass( )->get_name( ).c_str( ) );

			return camera_native_object.address->get_current_class( );
		}
	}

	return 0;
}


//template <typename T>
//struct ListNode
//{
//
//};
//
//struct GameObjectManager
//{
//    ListNode<unity::c_game_object*>* LastTaggedNode; // 0x0
//    ListNode<unity::c_game_object*>* TaggedNodes; // 0x8
//    ListNode<unity::c_game_object*>* LastMainCameraTaggedNode; // 0x10
//    ListNode<unity::c_game_object*>* MainCameraTaggedNodes; // 0x18
//    ListNode<unity::c_game_object*>* LastActiveNode; // 0x20
//    ListNode<unity::c_game_object*>* ActiveNodes; // 0x28
//};


auto entity::c_entity::warmup_pointers( ) -> void
{
	const auto reset = [ & ] ( ) -> void { sdk::game_world = nullptr; sdk::camera = nullptr; };

	// 48 8B 35 ? ? ? ? 48 85 F6 0F 84 ? ? ? ? 8B 46
	const auto game_object_manager = g_vm->read<uintptr_t>( g_vm->unity_player + 0x1A21378 );
	if ( !game_object_manager )
		return log_return_exit( HASH_STR( "!game_object_manager" ), reset( ) );

	const auto active_objects = g_vm->read<DWORD_PTR>( game_object_manager + 0x28 );
	if ( !active_objects )
		return log_return_exit( HASH_STR( "!active_objects" ), reset( ) );

	const auto last_active_objects = g_vm->read<DWORD_PTR>( game_object_manager + 0x20 );
	if ( !last_active_objects )
		return log_return_exit( HASH_STR( "!last_active_objects" ), reset( ) );

	const auto game_world_game_obj = GetObjectFromList( active_objects, last_active_objects, HASH_STR( "GameWorld" ) );
	if ( !game_world_game_obj )
		return log_return_exit( HASH_STR( "!game_world_game_obj" ), reset( ) );

	// ClientLocalGameWorld
	// ClientNetworkGameWorld
	// Or at Index 1

	const auto game_world = ( ( unity::c_game_object* ) game_world_game_obj )->get_component<sdk::c_game_world*>( unity::scripting_objects::game_world );
	if ( !game_world->is_valid( ) )
		return log_return_exit( HASH_STR( "!game_world" ), reset( ) );

	sdk::game_world = game_world;

	const auto fps_camera_game_object = get_fps_camera( );
	if ( !fps_camera_game_object )
		return log_return_exit( HASH_STR( "!fps_camera" ), reset( ) );

	sdk::camera = ( sdk::c_fps_camera* ) ( fps_camera_game_object );
}

auto entity::c_entity::cache_local_player( ) -> bool
{
	sdk::object::c_local_player player = { };

	const auto game_world = sdk::game_world;
	if ( !game_world->is_valid( ) )
		return log_bad_exit( HASH_STR( "!game_world" ), set_local_data( player ) );

	const auto main_player = game_world->main_player( );
	if ( !main_player->is_valid( ) )
		return log_bad_exit( HASH_STR( "!main_player" ), set_local_data( player ) );

	player.main_player = main_player;

	set_local_data( player );

	return true;
}

auto entity::c_entity::cache_actors( ) -> void
{
	static c_cache_timer timer;
	timer.start( );

	this->reset_current_set( );

	const auto game_world = sdk::game_world;
	if ( !game_world->is_valid( ) )
		return;

	const auto registered_players = game_world->registered_players( );
	if ( !registered_players->is_valid( ) )
		return log_return( HASH_STR( "!registered_players" ) );

	const auto _items = registered_players->_items( );
	if ( !_items->is_valid( ) )
		return log_return( HASH_STR( "!_items" ) );

	const auto _size = registered_players->_size( );
	if ( !_size || _size > 4000 )
		return;

	for ( int index = 0; index < _size; index++ ) {

		const auto player = registered_players->get( _items, index );
		if ( !player->is_valid( ) )
			continue;

		auto player_handle = player->get_current_class( );

		current_actors_set.insert( player_handle );

		const auto& current_map = player_actors.load( );
		if ( !current_map )
			continue;

		const auto& cached_actors = *current_map;

		const bool is_cached = cached_actors.find( player_handle ) != cached_actors.end( );
		if ( is_cached )
			continue;

		if ( handle_player( player_handle ) )
			global_actors.emplace( player_handle, actor_tag_t::player );
	}

	for ( auto it = global_actors.begin( ); it != global_actors.end( ); ) {
		const auto& [pointer, actor_tag] = *it;
		const bool should_erase = current_actors_set.find( pointer ) == current_actors_set.end( );

		if ( actor_tag == actor_tag_t::player ) {
			const auto player = pointer;

			const auto& actors = player_actors.load( );
			const auto new_map = std::make_shared<std::unordered_map<std::uint64_t, sdk::object::c_actor>>( *actors );

			if ( should_erase ) {
				new_map->erase( player );
			}
			else {
				const auto id = new_map->find( player );
				if ( id != new_map->end( ) )
					if ( !verify_player( id->second ) )
						new_map->erase( id );
			}

			player_actors.store( new_map );
		}

		if ( should_erase ) {
			it = global_actors.erase( it );
		}
		else {
			++it;
		}
	}

	timer.end( HASH_STR( "c_entity::cache_actors" ), max_cache_ittr );
}

auto entity::c_entity::handle_player( std::uint64_t player_handle ) -> bool
{
	sdk::object::c_actor actor = { };

	actor.player = player_handle;

	//auto player = reinterpret_cast< sdk::c_client_player* >( player_handle );
	auto player = reinterpret_cast< sdk::c_observed_player_view* >( player_handle );

	const auto native_object = player->native_object( ).value;
	if ( !native_object->is_valid( ) )
		return false;

	const auto game_object = native_object->game_object( );
	if ( !game_object->is_valid( ) )
		return false;

	const auto transform = game_object->get_scripting_object<unity::c_transform*>( unity::scripting_objects::transform ).address;
	if ( !transform->is_valid( ) )
		return false;

	actor.game_object = game_object;
	actor.transform = transform;

	if ( !verify_player( actor ) ) return false;

	const auto _player_body = player->_player_body( );
	if ( !_player_body->is_valid( ) )
		return false;

	actor.player_body = _player_body;

	const auto skeleton = _player_body->skeleton_root_joint( );
	if ( !skeleton->is_valid( ) )
		return false;

	const auto _values = skeleton->_values( );
	if ( !_values->is_valid( ) )
		return false;

	const auto _items = _values->_items( );
	if ( !_items->is_valid( ) )
		return false;

	actor.transforms = _values;

	sdk::object::c_skeleton skeleton_object;
	skeleton_object.bones.reserve( sdk::bones.size( ) );

	for ( enums::e_bone_ids id : sdk::bones ) {

		const auto transform = _values->get( _items, id )->native_object( ).value->cast<unity::c_transform*>( );
		if ( !transform->is_valid( ) )
			continue;

		skeleton_object.bones.push_back( { transform, id } );
	}

	actor.skeleton = skeleton_object;

	const auto& current_map = player_actors.load( );
	if ( !current_map )
		return false;

	auto new_map = std::make_shared<std::unordered_map<std::uint64_t, sdk::object::c_actor>>( *current_map );
	new_map->emplace( player_handle, actor );

	player_actors.store( new_map );

	return true;
}

auto entity::c_entity::second_tick( ) -> void
{
loop_start:

	constexpr auto players_update_interval = 1;
	constexpr auto entities_update_interval = 1;

	auto last_players_update_tick = std::chrono::steady_clock::now( );
	auto last_entities_update_tick = last_players_update_tick;

	std::vector<unsigned int> intervals = {
		players_update_interval, entities_update_interval
	};

	const auto& lowest_interval = *min_element( intervals.begin( ), intervals.end( ) );

	while ( true ) {
		threads::manager->set_state( threads::thread_type::entity, false );

		utility::update_function( players_update_interval, last_players_update_tick,
			[ & ] { update_players( ); }
		);

		threads::manager->set_state( threads::thread_type::entity, true );

		utility::sleep_short( lowest_interval );
	}

	goto loop_start;
}

auto entity::c_entity::verify_player( sdk::object::c_actor& player ) const -> bool
{
	const auto player_handle = player.player;

	const auto transform = player.transform;
	if ( !transform->is_valid( ) )
		return false;

	return true;
}

auto entity::c_entity::update_players( ) const -> void
{
	static c_cache_timer timer;
	timer.start( );

	const auto local = get_local_data( );

	const auto camera_instance = sdk::camera;
	if ( !camera_instance )
		return;

	const auto camera_position = camera_instance->position( );
	if ( !camera_position.valid( ) )
		return log_return( HASH_STR( "!camera_position" ) );

	const auto view_matrix = camera_instance->view_matrix( );

	const auto& actors = player_actors.load( );
	if ( !actors )
		return log_return( HASH_STR( "!actors" ) );

	auto& cached_players = *actors;

	const auto size = cached_players.size( );
	if ( size < 0 || size > max_players_size )
		return log_return( HASH_STR( "!max_players_size" ) );

	for ( auto& cached_entity : cached_players ) {
		auto& player = cached_entity.second;

		const auto player_handle = player.player;
		const auto game_object = player.game_object;

		player.transform = game_object->get_scripting_object<unity::c_transform*>( unity::scripting_objects::transform ).address;
		if ( !player.transform->is_valid( ) )
			continue;

		player.origin_position = unity::c_transform::get_position( player.transform->get_current_class( ) );
		player.distance = camera_position.distance( player.origin_position );

		math::vector2 screen;
		if ( !camera_instance->world_to_screen( player.origin_position, &screen, view_matrix ) || !camera_instance->in_screen( screen ) )
			continue;

		const auto process_skeleton = [ & ] ( ) -> void {
			sdk::object::c_skeleton& skeleton = player.skeleton;

			std::vector<sdk::object::c_bone_info>& cached_bones = skeleton.bones;
			if ( cached_bones.size( ) > sdk::bones.size( ) )
				return;

			for ( sdk::object::c_bone_info& bone : cached_bones )
				bone.position = unity::c_transform::get_position( bone.transform->get_current_class( ) );

		}; if ( g_vars->visuals.skeleton ) process_skeleton( );
	}

	timer.end( HASH_STR( "c_entity::update_players" ), max_cache_ittr );
}

auto entity::c_cache_timer::end( const std::string& function, int max_ittr, bool debug ) -> void
{
	const auto end_time = std::chrono::high_resolution_clock::now( );
	const auto duration = std::chrono::duration_cast< std::chrono::microseconds >( end_time - start_time ).count( );

	average_cache_time = ( average_cache_time * cache_count + duration ) / ( cache_count + 1 );
	cache_count++;

	if ( debug )
		log( HASH_STR( "[%s] average time: %.2f ms over %d itterations" ), function.c_str( ), average_cache_time / 1000.0, cache_count );

	if ( cache_count == max_ittr )
		cache_count = 0;
}

#endif // !PLAYERS_CPP