#ifndef WEAPON_CPP
#define WEAPON_CPP

#include <impl/includes.hpp>

auto environment_interface::c_environment::weapon( ) -> void
{
	static entity::c_cache_timer timer;

	timer.start( );

	const auto data = g_entity->get_local_data( );

	const auto main_player = data.main_player;
	if ( !main_player->is_valid( ) )
		return;

	const auto pwa = main_player->procedural_weapon_animation( );
	if ( !pwa->is_valid( ) )
		return;

	if ( g_vars->misc.no_recoil )
	{
		const auto shootingg = pwa->shootingg( );
		if ( shootingg->is_valid( ) )
		{
			const auto new_shot_recoil = shootingg->new_shot_recoil( );
			if ( new_shot_recoil->is_valid( ) )
			{
				new_shot_recoil->recoil_effect_on( false );
			}
		}
	}

	if ( g_vars->misc.no_sway )
	{
		const auto walk = pwa->walk( );
		if ( walk->is_valid( ) )
			walk->intensity( 0.00f );

		const auto breath = pwa->breath( );
		if ( breath->is_valid( ) )
			breath->intensity( 0.00f );

		const auto force_react = pwa->force_react( );
		if ( force_react->is_valid( ) )
			force_react->intensity( 0.00f );

		pwa->aim_sway_max( math::vector3( ) );
		pwa->aim_sway_min( math::vector3( ) );
	}

	if ( g_vars->misc.instant_ads )
	{
		pwa->_aiming_speed( 1000.00f );
	}

	timer.end( HASH_STR( "c_environment::weapon" ), entity::max_cache_ittr );
}

#endif // !WEAPON_CPP
