#ifndef SKILLS_CPP
#define SKILLS_CPP

#include <impl/includes.hpp>

auto environment_interface::c_environment::skills( ) -> void
{
	static entity::c_cache_timer timer;

	timer.start( );

	const auto data = g_entity->get_local_data( );

	const auto main_player = data.main_player;
	if ( !main_player->is_valid( ) )
		return;

	const auto profile = main_player->profile( );
	if ( !profile->is_valid( ) )
		return;

	const auto skills = profile->skills( );
	if ( !skills->is_valid( ) )
		return;

	if ( g_vars->misc.fast_reload )
	{
		const auto mag_drills_load_speed = skills->mag_drills_load_speed( );
		if ( mag_drills_load_speed->is_valid( ) )
			mag_drills_load_speed->set( 50.00f );

		const auto mag_drills_unload_speed = skills->mag_drills_unload_speed( );
		if ( mag_drills_unload_speed->is_valid( ) )
			mag_drills_unload_speed->set( 50.00f );
	}

	timer.end( HASH_STR( "c_environment::skills" ), entity::max_cache_ittr );
}

#endif // !SKILLS_CPP
